//
//  InspectionResultDetailsModel.m
//  patrol
//
//  Created by 曹云霄 on 16/9/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionResultDetailsModel.h"


#define DEFAULT 17

@implementation InspectionResultDetailsModel


+ (BOOL)propertyIsOptional:(NSString *)propertyName
{
    return YES;
}

+ (NSDictionary *)objectClassInArray{
    return @{@"answers" : [NewAnswers class]};
}
@end


@implementation NewAnswers

+ (NSDictionary *)objectClassInArray{
    return @{@"details" : [NewDetails class]};
}

+ (BOOL)propertyIsOptional:(NSString *)propertyName
{
    return YES;
}


- (CGFloat)questionHeight
{
    if (_questionHeight) {
        return _questionHeight;
    }
    _questionHeight = [self calculateStringHeight:self.questionTitle size:CGSizeMake(ScreenSize.width-56-30, CGFLOAT_MAX)];
    return _questionHeight;
}

- (CGFloat)remarkHeight
{
    if (!self.answered) {
        return 0;
    }
    if (_remarkHeight) {
        return _remarkHeight;
    }
    if (!self.remark.length) {
        self.remark = nil;
        return 0;
    }
    _remarkHeight = [self calculateStringHeight:self.remark size:CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
    return _remarkHeight;
}

/// DEFAULT表示默认高度
- (CGFloat)contentHeight
{
    if (!self.answered) {
        return DEFAULT;
    }
    if (_contentHeight) {
        return _contentHeight;
    }
    switch (self.questionType) {
        case kICRQestionTypeSingleSel://0单选
        {
            NewDetails *detail = [self.details firstObject];
            _contentHeight = [self calculateStringHeight:detail.questionValue size:CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        case kICRQestionTypeMultipleSel://1多选
        {
            NSMutableString *mutableString = [NSMutableString string];
            for (NewDetails *detail in self.details) {
                [mutableString appendString:[NSString stringWithFormat:@"%@   ",detail.stringValue]];
            }
            _contentHeight = [self calculateStringHeight:mutableString size:CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        case kICRQestionTypeReply://2回复类
        {
            NewDetails *detail = [self.details firstObject];
            _contentHeight = [self calculateStringHeight:detail.questionValue size:CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        case kICRQestionTypeScore://3评分类
        {
            _contentHeight = [self calculateStringHeight:[NSString stringWithFormat:@"%@%@",self.score,@"分"] size: CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        case kICRQestionTypeStoreInv://4库存调查类
        {
            NSMutableArray *tempArray = [NSMutableArray array];
            for (NewDetails *detail in self.details) {
                [tempArray addObject:@(detail.numberValue)];
            }
            NSSet *set = [NSSet setWithArray:tempArray];
            //40表格高度
            _contentHeight = ([set allObjects].count+1) * 40;
        }
            break;
        case kICRQestionTypeSpeciesInv://5品类调查类
        {
            NSMutableArray *tempArray = [NSMutableArray array];
            for (NewDetails *detail in self.details) {
                [tempArray addObject:@(detail.numberValue)];
            }
            NSSet *set = [NSSet setWithArray:tempArray];
            //40表格高度
            _contentHeight = ([set allObjects].count+1) * 40;
        }
            break;
        case kICRQestionTypeStarNum://6星数类
        {
            _contentHeight = DEFAULT;
        }
            break;
        case kICRQestionTypeSingleScore://7单选打分
        {
            NewDetails *detail = [self.details firstObject];
            _contentHeight = [self calculateStringHeight:[NSString stringWithFormat:@"%@   %@分",detail.questionValue,self.score] size: CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        case kICRQestionTypeYesOrNO://8是非题
        {
            NewDetails *detail = [self.details firstObject];
            _contentHeight = [self calculateStringHeight:[NSString stringWithFormat:@"%ld",detail.numberValue] size:CGSizeMake(ScreenSize.width-72-15, CGFLOAT_MAX)];
        }
            break;
        default:
            break;
    }
    return  (_contentHeight < DEFAULT)?DEFAULT:_contentHeight;
}

- (CGFloat)resultAttachmentsHeight
{
    if (!self.answered) {/// 未回答情况
        return 0;
    }
    if (_resultAttachmentsHeight) {
        return _resultAttachmentsHeight;
    }
    _resultAttachmentsHeight = [self calculateResultAttachmentsHeight:_resultAttachments.count lineNumber:3];
    return _resultAttachmentsHeight;
}

#pragma mark - 计算字符串高度
- (CGFloat)calculateStringHeight:(NSString *)textString size:(CGSize)size
{
    /// 72为左边距     15为右边距
    CGFloat stringHeight = [textString boundingRectWithSize:size options:NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading attributes:@{NSFontAttributeName:[UIFont systemFontOfSize:14]} context:nil].size.height;
    return stringHeight;
}


#pragma mark - 计算附件高度
- (CGFloat)calculateResultAttachmentsHeight:(NSInteger)arrayCount lineNumber:(NSInteger)number
{
    CGFloat attachmentHeight = (ScreenSize.width-72-15-20)/3;//附件高度
    CGFloat intervalWidth = 10;//附件间隔
    CGFloat cellHeight = 0;
    if (arrayCount == 0) {
        return arrayCount;
    }
    if (arrayCount %number == 0) {
        cellHeight += attachmentHeight * arrayCount/number + (arrayCount/number - 1) * intervalWidth;
    }else if (arrayCount %number == 1){
        cellHeight += attachmentHeight * (arrayCount + 2)/number + ((arrayCount + 2)/number -1) * intervalWidth;
    }else{
        cellHeight += attachmentHeight * (arrayCount + 1)/number + ((arrayCount + 1)/number -1) * intervalWidth;
    }
    return cellHeight;
}

@end


@implementation NewDetails

+ (BOOL)propertyIsOptional:(NSString *)propertyName
{
    return YES;
}

@end

@implementation RealStore



@end


