//
//  InspectionResultModel.h
//  patrol
//
//  Created by 曹云霄 on 16/9/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "JSONModel.h"

@class Records;
@class PagingResult;
@class Inspectors;
@class Results;



@protocol Records @end
@protocol PagingResult @end
@protocol Inspectors @end
@protocol Results @end




@interface InspectionResultModel : JSONModel

@property (nonatomic, strong) NSArray<Records> *records;

@property (nonatomic, assign) NSInteger planCount;

@property (nonatomic, assign) NSInteger manTimes;

@property (nonatomic, assign) NSInteger storeCount;

@property (nonatomic, strong) PagingResult* paging;

@property (nonatomic, assign) NSInteger remainStoreCount;


@end

/**
 *  分页数据
 */
@interface PagingResult : JSONModel

@property (nonatomic, assign) NSInteger page;

@property (nonatomic, assign) NSInteger recordCount;

@property (nonatomic, assign) NSInteger pageSize;

@property (nonatomic, assign) NSInteger pageCount;

@end


/**
 *  VI检查列表
 */
@interface Records : JSONModel

@property (nonatomic, copy) NSString *category;

@property (nonatomic, copy) NSString *remark;

@property (nonatomic, copy) NSString *endDate;
@property (nonatomic, assign) NSInteger storeCount;
@property (nonatomic, assign) NSInteger remainStoreCount;
@property (nonatomic,assign) NSInteger  questionCount;
@property (nonatomic, assign) NSInteger resultStoreCount;

@property (nonatomic, assign) NSInteger state;

@property (nonatomic, copy) NSString *uuid;

@property (nonatomic, copy) NSString *beginDate;

/**
 是否是临时巡检
 */
@property (nonatomic, assign) BOOL temp;

@property (nonatomic, strong) NSArray<Inspectors> *inspectors;

@property (nonatomic, copy) NSString *name;

@end
/**
 *  VI检查员
 */
@interface Inspectors : JSONModel

@property (nonatomic, copy) NSString *personUuid;

@property (nonatomic, assign) NSInteger finishCount;

@property (nonatomic, assign) NSInteger personStoreCount;

@property (nonatomic, strong) NSArray<Results> *results;

@property (nonatomic, copy) NSString *user_uuid;

@property (nonatomic, copy) NSString *user_name;

@property (nonatomic, copy) NSString *user_code;

@end


/**
 *  VI检查结果
 */
@interface Results : JSONModel

@property (nonatomic, copy) NSString *store_name;

@property (nonatomic, copy) NSString *store_code;

@property (nonatomic, copy) NSString *store_uuid;

@property (nonatomic, copy) NSString *endTime;

@property (nonatomic, copy) NSString *beginTime;

@property (nonatomic, assign) CGFloat score;

@property (nonatomic, assign) NSInteger resultState;

@property (nonatomic, copy) NSString *resultuuid;

@property (nonatomic,copy) NSString *realstoreUuid;

@property (nonatomic,assign) NSInteger reportCount;

@property (nonatomic, strong) NSNumber<Optional> *state;

@end


