//
//  InspectionHeaderTableViewCell.m
//  patrol
//
//  Created by 曹云霄 on 16/9/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionHeaderTableViewCell.h"

@implementation InspectionHeaderTableViewCell

- (void)awakeFromNib {
    // Initialization code
    [super awakeFromNib];
}

#pragma mark - 赋值
- (void)setPlanModel:(Records *)planModel
{
    _planModel = planModel;
    self.planNameLabel.text = planModel.name;
    self.planStateLabel.text = [self returnStateString:planModel.state];
}

#pragma mark - 通过状态码来返回文字
- (NSString *)returnStateString:(NSInteger)state
{
    NSString *stateString = nil;
    switch (state) {
        case 0:
            stateString = @"未执行";
            break;
        case 1:
            stateString = @"已执行";
            break;
        case 2:
            stateString = @"执行中";
            break;
        case 3:
            stateString = @"已结束";
            break;
        case 4:
            stateString = @"已取消";
            break;
            
        default:
            break;
    }
    return stateString;
}

@end
