//
//  SupervisionHeaderTableViewCell.m
//  patrol
//
//  Created by 曹云霄 on 16/9/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SupervisionHeaderTableViewCell.h"

@implementation SupervisionHeaderTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    
    [self setProgressView];
}

#pragma mark - 赋值
- (void)setModel:(Inspectors *)model
{
    self.supervisionNameLabel.text = [NSString stringWithFormat:@"%@",model.user_name];
    CGFloat storesCount = model.personStoreCount;
    self.taskProgressLabel.text = [NSString stringWithFormat:@"%.0f%@(%ld/%.0f%@)",(model.finishCount/storesCount)*100.0,@"%",model.finishCount,storesCount,@"店"];
    [self.progressView setProgress:model.finishCount / storesCount animated:YES];
    self.supervisionNameLabel.textColor = [model.user_uuid isEqualToString:kUser.f_user_uuid] ? ICR_TINTCOLOR : [UIColor blackColor];
}

#pragma mark -设置进度条风格
- (void)setProgressView
{
    [self.progressView performAction:M13ProgressViewActionNone animated:YES];
    self.progressView.animateStripes = YES;
    self.progressView.cornerType = M13ProgressViewStripedBarCornerTypeRounded;
}

@end
