//
//  GTOStoreItemView.m
//  total
//
//  Created by freecui on 15/9/15.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOStoreItemView.h"
#import "GTOStore.h"
#import "GTOProcessValue.h"
#import "ICRStoreResult.h"
@interface GTOStoreItemView ()
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;
@property (strong, nonatomic) IBTUILabel *m_storeNameValueLabel;
@property (strong, nonatomic) IBTUILabel *m_processLabel;
@property (strong, nonatomic) UILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;//进度条
@property (strong, nonatomic) IBTUIButton *m_positionBtn;
//@property (strong, nonatomic) UIView *m_positionView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@property (nonatomic, strong) GTOStore *d_store;

@property (nonatomic, strong) IBTUIButton *m_storeStateBtn;
@property (nonatomic, strong) ICRStoreResult *m_storeResult;
@end

@implementation GTOStoreItemView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self _init];
    }
    return self;
}

- (void)_init {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameValueLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
//    self.m_positionBtn = [[IBTUIButton alloc]init];
//    //[self.m_positionBtn setTitle:@"定位" forState:UIControlStateNormal];
//    [self.m_positionBtn setBackgroundImage:[UIImage imageNamed:@"bnavi_icon_location_fixed"] forState:UIControlStateNormal];
//    self.m_positionView = [[UIView alloc]init];
//    UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(positionClicked)];
//    [_m_positionView addGestureRecognizer:tapGesture];
    self.m_processLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    

    
    [self addSubview:_m_storeNameLabel];
    [self addSubview:_m_storeNameValueLabel];
    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];

   
   // [self addSubview:_m_positionView];
 
}
- (void)layoutSubviews {
//    CGFloat leftPadding = 10; CGFloat topPadding = 5;
    CGFloat lblH = 16;
//    CGFloat noPaddingViewHalf = ( self.width - 2 * leftPadding ) * 0.5;
    
    self.m_storeNameLabel.frame = ((CGRect){
        .origin.x = GTO_LEFT_PADDING ,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = 80,
        .size.height = lblH
    });[self.m_storeNameLabel sizeToFit];
    self.m_storeNameValueLabel.frame = ((CGRect){
        .origin.x = _m_storeNameLabel.right ,
        .origin.y = _m_storeNameLabel.y,
        .size.width = 80,
        .size.height = lblH
    });  [self.m_storeNameValueLabel sizeToFit];
    
    UIFont *font = [UIFont systemFontOfSize:15];
    if (self.m_storeResult.state == kPatrolStoreStateSubmitted) {
        self.m_storeStateBtn = [[self class] buttonWithTitle:@"已提交"
                                              titleLabelFont:font
                                                 borderColor:GTO_GRAY_TINT_COLOR titleColor:GTO_GRAY_TINT_COLOR];

    } else if (self.m_storeResult.state == kPatrolStoreStateUnsubmitted){
        self.m_storeStateBtn = [[self class] buttonWithTitle:@"待提交"
                                              titleLabelFont:font
                                                 borderColor:[UIColor redColor] titleColor:[UIColor redColor]];
    } else if (self.m_storeResult.state == kPatrolStoreStateUnfinished) {
        self.m_storeStateBtn = [[self class] buttonWithTitle:@"未填完"
                                              titleLabelFont:font
                                                 borderColor:[UIColor orangeColor] titleColor:[UIColor orangeColor]];
    } else{}
    self.m_storeStateBtn.userInteractionEnabled = NO;
    self.m_storeStateBtn.frame = ((CGRect){
        .origin.x = self.width - GTO_LEFT_PADDING - 70 ,
        .origin.y = _m_storeNameLabel.y,
        .size.width = 70,
        .size.height = 20
    });
    [self addSubview:_m_storeStateBtn];
//    self.m_positionBtn.frame = ((CGRect){
//        .origin.x = self.width - 80 - GTO_LEFT_PADDING ,
//        .origin.y = _m_storeNameLabel.y,
//        .size.width = 80,
//        .size.height = lblH
//    });
//    CLog(@"self.width %lf",self.width);
//    self.m_positionView.frame = ((CGRect){
//        .origin.x = self.width - 80 - GTO_LEFT_PADDING ,
//        .origin.y = _m_storeNameLabel.y,
//        .size.width = 80,
//        .size.height = lblH
//    });
//    IBTUILabel *positionLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(0, 0, _m_positionView.width * 0.5, _m_positionView.height) text:@"定位" font:[UIFont systemFontOfSize:17] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
//    UIImageView *imgV = [[UIImageView alloc]initWithFrame:CGRectMake(positionLbl.right, 0, positionLbl.width, positionLbl.height)];
//    imgV.image = [UIImage imageNamed:@"CellCustomArrow"];
//    imgV.contentMode = UIViewContentModeCenter;
//    
//    [self.m_positionView addSubview:positionLbl];
//    [self.m_positionView addSubview:imgV];
    
    self.m_processLabel.frame = ((CGRect){
        .origin.x = _m_storeNameLabel.x,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING  ,
        .size.width = _m_storeNameLabel.width,
        .size.height = lblH
    });

    self.m_processValueLabel.frame = ((CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = _m_storeNameValueLabel.width,
        .size.height = lblH
    });

    self.m_processFractionLabel.frame = ((CGRect){
        .origin.x = self.width - _m_storeNameLabel.x * 2 - 80,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 80,
        .size.height = lblH
    });
    
    CGRect rect = (CGRect){
        .origin.x = _m_storeNameLabel.x,
        .origin.y = _m_processFractionLabel.y ,
        .size.width = self.width - _m_storeNameLabel.x * 2 - _m_processFractionLabel.width- 5 ,
        .size.height = lblH,
    };
    
    [self.m_processBarView removeFromSuperview];
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    
    [self addSubview:_m_processBarView];
    

}
+ (IBTUIButton *)buttonWithTitle: (NSString *)title
                  titleLabelFont: (UIFont *)font
                     borderColor: (UIColor *)borderColor
                      titleColor: (UIColor *)titleColor{
    IBTUIButton *btn = [IBTUIButton buttonWithType:UIButtonTypeCustom];
    btn.layer.cornerRadius = 10;
    btn.layer.masksToBounds = YES;
    btn.layer.borderColor = borderColor.CGColor ?:[[UIColor blackColor] CGColor];
    btn.layer.borderWidth = 1.5;
    [btn setTitle:title forState:UIControlStateNormal];
    [btn setTitleColor:titleColor?:[UIColor blackColor] forState:UIControlStateNormal];
    btn.titleLabel.font = font;
    [btn.titleLabel setTextAlignment:NSTextAlignmentRight];
    return btn;
}
//- (void)positionClicked {
//    if ([_delegate respondsToSelector:@selector(storeItemView:)]) {
//        [self.delegate storeItemView:self];// positionString:<#(NSString *)#>]
//    }
//}
@end


@implementation GTOStoreItemView (configure)
- (void)updateWithStoreResult: (ICRStoreResult *)storeResult {
    
    
    self.m_storeResult = storeResult;
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称: "];
    self.m_storeNameValueLabel.text = storeResult.store_name;
    self.m_processLabel.text = @"VI检查进度: ";
    if (storeResult.state == kPatrolStoreStateSubmitted) {
        self.d_processLength = 1.0 * storeResult.questions.count / storeResult.questions.count;
        int percent = self.d_processLength * 100;
        //self.m_processValueLabel.text = [NSString stringWithFormat:@"未完成 %d%%",percent];
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
    self.m_processFractionLabel.text = [NSString stringWithFormat:@"%ld/%ld(题)",storeResult.questions.count,storeResult.questions.count];
    } else {
        self.d_processLength = 1.0 * storeResult.answers.count / storeResult.questions.count;
        int percent = self.d_processLength * 100;
//        self.m_processValueLabel.text = [NSString stringWithFormat:@"未完成 %d%%",percent];
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
        self.m_processFractionLabel.text = [NSString stringWithFormat:@"%ld/%ld(题)",storeResult.answers.count,storeResult.questions.count];
    }
    
    
    [self layoutSubviews];
}
- (void)updateWithStore: (GTOStore *)store
         inspectorState: (NSInteger)state
    proceeValue: (GTOProcessValue *)proceeValue
{
    
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称:"];
    self.m_storeNameValueLabel.text = store.name;
    self.m_processLabel.text = @"VI检查进度";
//    int finishProblems = (int )proceeValue.finishNumber;
//    int totalProblems = (int)proceeValue.totalNumber;
////    if (arrDisplayResults) {
////        for(GTODisplayResult *display in arrDisplayResults) {
////            finishProblems += display.arrAnswers.count;
////            totalProblems += display.arrQuestions.count;
////        }
////
////    }
//    int percent = 0; self.d_processLength = 0;
//    if (totalProblems) {
//        self.d_processLength = 1.0 * finishProblems / totalProblems;
//       percent = self.d_processLength * 100;
//    }
//   
//    if (state == 0) {
//        self.m_processValueLabel.textColor = GTO_RED_COLOR;
//        self.m_processValueLabel.text = [NSString stringWithFormat:@"未完成 %d%%",percent];
//        self.m_processFractionLabel.textColor = GTO_RED_COLOR;
//        self.m_processFractionLabel.text = [NSString stringWithFormat:@"%d/%d (题)",finishProblems,totalProblems];
//
//    } else if (state == 1) {
//        self.m_processValueLabel.textColor = GTO_GRAY_TINT_COLOR;
//        self.m_processValueLabel.text = [NSString stringWithFormat:@"未完成 %d%%",percent];
//        self.m_processFractionLabel.textColor = GTO_GRAY_TINT_COLOR;
//        self.m_processFractionLabel.text = [NSString stringWithFormat:@"%d/%d(题)",finishProblems,totalProblems];
//    } else {
//    
//    }
//    
//    
//    self.d_store = store;
    
    [self layoutSubviews];
}


@end
