//
//  PatrolTaskCollectionViewCell.h
//  patrol
//
//  Created by 曹云霄 on 2017/2/23.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PatrolTaskCustomModel.h"
@interface PatrolTaskCollectionViewCell : UICollectionViewCell

/**
 任务状态
 */
@property (weak, nonatomic) IBOutlet UIImageView *stateImageView;

/**
 门店name
 */
@property (weak, nonatomic) IBOutlet UILabel *storeNameLabel;

/**
 坐标状态
 */
@property (weak, nonatomic) IBOutlet UIImageView *coordStateImageView;

/**
 内容
 */
@property (weak, nonatomic) IBOutlet UILabel *contentLabel;

/**
 任务数据
 */
@property (nonatomic,strong) PatrolTaskCustomModel *customModel;

/**
 门店信息
 */
@property (nonatomic,strong) Results *storeModel;


/**
 刷新cell

 @param customModel 任务信息
 @param storeModel 门店信息
 */
- (void)refreshCellCustomModel:(PatrolTaskCustomModel *)customModel withStoreModel:(Results *)storeModel;

@end
