//
//  PatrolTaskCollectionViewCell.m
//  patrol
//
//  Created by 曹云霄 on 2017/2/23.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolTaskCollectionViewCell.h"
#import "CalculateHelper.h"
@implementation PatrolTaskCollectionViewCell


- (void)awakeFromNib {
    [super awakeFromNib];
    self.contentLabel.font = [UIFont systemFontOfSize:22];
}

/**
 刷新cell
 
 @param customModel 任务信息
 @param storeModel 门店信息
 */
- (void)refreshCellCustomModel:(PatrolTaskCustomModel *)customModel withStoreModel:(Results *)storeModel
{
    _customModel = customModel;
    _storeModel = storeModel;
    self.storeNameLabel.text =  storeModel.store_name;
    self.stateImageView.image = [ToolsManager returnPatrolTaskStateImage:[storeModel.state integerValue]];
    self.coordStateImageView.image = [ToolsManager returnStoreCoordStateImage:storeModel.realstoreUuid withTaskState:customModel.state];
    if ([storeModel.store_uuid isEqualToString:storeModel.realstoreUuid]) {
        self.coordStateImageView.image = TCImage(@"coord_matching");
    }else{
        self.coordStateImageView.image = TCImage(@"coord_mismatching");
    }
    [self refreshContentLabel];
}

/**
 刷新内容
 */
- (void)refreshContentLabel
{
    if (!self.customModel.state) {
        self.contentLabel.text = [NSString stringWithFormat:@"%ld/%ld",self.storeModel.reportCount,self.customModel.questionCount];
        self.contentLabel.font = [UIFont systemFontOfSize:22];
    }else {
        if (self.storeModel.score) {
            NSDecimalNumber *score = [CalculateHelper calculateNum1:@(self.storeModel.score) num2:@(0) type:CalculateTypeAdd roundingType:NSRoundPlain cutLenth:2];
            NSString *string = [NSString stringWithFormat:@"%.2lf%@(%ld/%ld)",score.floatValue,@"分",self.storeModel.reportCount,self.customModel.questionCount];
            NSRange storeRange = [string rangeOfString:[NSString stringWithFormat:@"(%ld/%ld)",self.storeModel.reportCount,self.customModel.questionCount]];
            NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:string];
            [attributedString addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:15] range:storeRange];
            [attributedString addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:22] range:NSMakeRange(0, storeRange.location)];
            self.contentLabel.attributedText = attributedString;
        }else {
            NSString *string = [NSString stringWithFormat:@"%ld/%ld",self.storeModel.reportCount,self.customModel.questionCount];
            self.contentLabel.text = string;
        }
    }
}


@end


