//
//  PatrolExamTitleTableViewCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamCategoryTableViewCell.h"

@implementation PatrolExamCategoryTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    NSMutableArray *questions = [NSMutableArray array];
    NSMutableArray *answers = [NSMutableArray array];
    for (ZJPatrolDetail_questions *question in cellModel.viewModel.detail.questions) {
        if ([question.category isEqualToString:cellModel.category]) {
            for (NSString *key in cellModel.viewModel.dicAnswers.allKeys) {
                if ([key isEqualToString:question.uuid]) {
                    ZJPatrolDetail_results_answers *answer = (ZJPatrolDetail_results_answers *)[cellModel.viewModel.dicAnswers objectForKey:key];
                    if (answer.details.count) {
                        [answers addObject:@1];
                    }
                }
            }
            [questions addObject:question];
        }
    }
    NSString *string = [NSString stringWithFormat:@"%@ (%ld/%ld)",cellModel.category,answers.count,questions.count];
    NSRange range = [string rangeOfString:[NSString stringWithFormat:@"(%ld/%ld)",answers.count,questions.count]];
    NSMutableAttributedString *attributedStr = [[NSMutableAttributedString alloc] initWithString:string];
    [attributedStr addAttribute:NSForegroundColorAttributeName
                          value:GTO_BLUE_DEEP_COLOR
                          range:range];
    self.labelCategory.attributedText = attributedStr;
}





















@end
