//
//  PatrolExamQuestionTableViewCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamQuestionTableViewCell.h"
#import "PatrolExamCellViewModel.h"

@implementation PatrolExamQuestionTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
}

- (void)actionNotiAnswerChanged:(NSNotification *)noti {
    PatrolExamCellViewModel *cellModel = noti.object;
    if ([cellModel.question.uuid isEqualToString:self.cellModel.question.uuid]) {
        if (cellModel.answer != nil) {
            [self bluePin];
            if (cellModel.cellType == ExamCellTypeStar) {
                if ([cellModel.answer.score isEqualToNumber:@0]) {
                    [self redPin];
                }else{
                    [self bluePin];
                }
            }
        }else{
            [self redPin];
        }
    }
}

- (void)redPin {
    self.imgPin.image = TCImage(@"patrol_exam_red_pin");
}

- (void)bluePin {
    self.imgPin.image = TCImage(@"patrol_exam_blue_pin");
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    self.labelTitle.text = cellModel.question.title;
    self.labelStandScore.text = [NSString stringWithFormat:@"%@%@", cellModel.question.standScore,@"分"];
        self.labelStandScore.hidden = cellModel.question.standScore == nil;
    ZJPatrolDetail_results_answers *answer = self.cellModel.answer;
    if (answer) {
        [self bluePin];
    }else{
        [self redPin];
    }
}

@end
