
//
//  PatrolExamScoreCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamScoreCell.h"

@implementation PatrolExamScoreCell


- (void)awakeFromNib {
    [super awakeFromNib];
    self.slider.popUpViewCornerRadius = 0.0;
    [self.slider setMaxFractionDigitsDisplayed:0];
    self.slider.popUpViewColor = [UIColor colorWithHue:0.55 saturation:0.8 brightness:0.9 alpha:0.7];
    self.slider.font = [UIFont systemFontOfSize:20];
    self.slider.textColor = [UIColor colorWithHue:0.55 saturation:1.0 brightness:0.5 alpha:1];
    self.slider.popUpViewWidthPaddingFactor = 1.7;
    [self.slider showPopUpViewAnimated:YES];
    [self.slider addTarget:self action:@selector(actionSliderValueChaged:) forControlEvents:UIControlEventValueChanged];
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    self.slider.minimumValue = [cellModel.question.scoreFrom floatValue];
    self.slider.maximumValue = [cellModel.question.scoreTo floatValue];
    self.slider.value = [cellModel.answer.score floatValue];
    self.labelMinScore.text = [NSString stringWithFormat:@"%@分",cellModel.question.scoreFrom];
    self.labelMaxScore.text = [NSString stringWithFormat:@"%@分",cellModel.question.scoreTo];
}

- (void)actionSliderValueChaged:(ASValueTrackingSlider *)slider {
    ZJPatrolDetail_results_answers *answer = self.cellModel.getAnswer;
    answer.score = @(slider.value);
    self.cellModel.viewModel.blockAnswerAction();
    [self.cellModel postNoti];
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
