//
//  PatrolExamYesNoCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamYesNoCell.h"

@implementation PatrolExamYesNoCell

- (void)awakeFromNib
{
    [super awakeFromNib];
    [self.btnYes setTitle:@"是" forState:UIControlStateNormal];
    [self.btnNo setTitle:@"否" forState:UIControlStateNormal];
    [self.btnYes horizontalCenterImageAndTitle:5];
    [self.btnNo horizontalCenterImageAndTitle:5];
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    if (cellModel.answer.details.count > 0) {
        ZJPatrolDetail_results_answers_details *detail = cellModel.answer.details[0];
        if ([detail.index isEqualToNumber:@1]) {
            self.btnYes.selected = YES;
            self.btnNo.selected = NO;
            self.btnIgnore.selected = NO;
        }else if ([detail.index isEqualToNumber:@2]){
            self.btnNo.selected = YES;
            self.btnYes.selected = NO;
            self.btnIgnore.selected = NO;
        }else if ([detail.index isEqualToNumber:@3]){
            self.btnNo.selected = NO;
            self.btnYes.selected = NO;
            self.btnIgnore.selected = YES;
        }else {
            self.btnYes.selected = NO;
            self.btnNo.selected = NO;
            self.btnIgnore.selected = NO;
        }
    }else {
        [self.btnNo deselectAllButtons];
    }
}

/**
 选项点击事件

 @param sender RadioButton
 sender.tag
 0 表示是
 1 表示否
 2 表示无此项
 */
- (IBAction)actionTap:(RadioButton *)sender {
    ZJPatrolDetail_results_answers *answer = self.cellModel.getAnswer;
    if (answer.details.count == 0) {
        answer.details = (NSMutableArray <ZJPatrolDetail_results_answers_details,Optional> *)[NSMutableArray array];
        ZJPatrolDetail_results_answers_details *detail = [ZJPatrolDetail_results_answers_details new];
        [answer.details addObject:detail];
    }
    ZJPatrolDetail_results_answers_details *detail = answer.details[0];
    if (sender.tag == 0) {
        detail.index = @1;
    }else if (sender.tag == 1) {
        detail.index = @2;
    }else {
        detail.index = @3;
    }
    self.cellModel.viewModel.blockAnswerAction();
    //刷新标题图标
    [self.cellModel postNoti];
}

@end















