//
//  PatrolStartAnswerConfirmVC.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolStartAnswerConfirmVC.h"
#import "ZJPatrolStore.h"


@interface PatrolStartAnswerConfirmVC ()

@property (strong, nonatomic) ZJPatrolStore *storeSelected;
@property (strong, nonatomic) NSString *latitute;
@property (strong, nonatomic) NSString *longtitude;
@end

@implementation PatrolStartAnswerConfirmVC

- (void)viewDidLoad {
    [super viewDidLoad];

    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    [self.startCheckButton setTitle:@"开始检查" forState:UIControlStateNormal];
    [self.view layoutIfNeeded];
}

- (void)setStoreSelected:(ZJPatrolStore *)storeSelected {
    _storeSelected = storeSelected;
}

#pragma mark -开始答题请求
- (IBAction)actionStartAnswer:(id)sender {
    [self httpStart];
}

#pragma mark -开始答题请求
- (void)httpStart {
   [RequestManager request_BeginPatrolPlanAnswer:self.viewModel.plan.uuid storeUuid:self.viewModel.storeResult.store_uuid selectedStoreUuid:self.storeSelected.uuid ?: @"" longtitude:kUser.longitude latitute:kUser.latitude success:^(id returnValue) {
       if ([BaseViewModel verifyData:returnValue]) {
           self.viewModel.storeResult.state = @(2);
           [self hide];
           if (self.blockStart) {
               self.blockStart();
           }
       }
   } failure:^(id errorValue) {
       [IBTLoadingView showTextOnly:errorValue];
   }];
}

- (IBAction)actionCancel:(id)sender {
    [self hide];
    [self.superVC.navigationController popViewControllerAnimated:YES];
}

- (void)actionTap:(UITapGestureRecognizer *)tap {
    [self actionCancel:nil];
}

@end
