//
//  PatrolExamCellViewModel.h
//  patrol
//
//  Created by Javen on 2017/2/28.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZJPatrolDetail.h"
@class PatrolExamViewModel;
/**
 cell题型
 
 - ExamCellTypeSingle: 单选题
 - ExamCellTypeMultiple: 多选题
 - ExamCellTypeStar: 星数题
 - ExamCellTypeYesNO: 是非题
 - ExamCellTypeInput: 输入题
 - ExamCellTypeCatogory: 分类
 - ExamCellTypeQuestion: 题目
 - ExamCellTypeScore: slider选择分数
 - ExamCellTypeAttachment: 附件
 - ExamCellTypeSelectScore: 单选打分题
 */
typedef NS_ENUM(NSInteger, ExamCellType) {
    ExamCellTypeSingle = 0,
    ExamCellTypeMultiple = 1,
    ExamCellTypeInput = 2,
    ExamCellTypeScore = 3,
    ExamCellTypeStar = 6,
    ExamCellTypeSelectScore = 7,
    ExamCellTypeYesNO = 8,
    ExamCellTypeCatogory,
    ExamCellTypeQuestion,
    ExamCellTypeAttachment,
};
@interface PatrolExamCellViewModel : NSObject


/**
 cell类型
 */
@property (nonatomic, assign) ExamCellType cellType;

/**
 cell高度
 */
@property (nonatomic, assign) CGFloat height;

/**
 问题
 */
@property (strong, nonatomic) ZJPatrolDetail_questions *question;

/**
 问题的选项
 */
@property (strong, nonatomic) ZJPatrolDetail_questions_details *questionDetail;

/**
 问题答案
 */
@property (strong, nonatomic) ZJPatrolDetail_results_answers *answer;

/**
 分类
 */
@property (strong, nonatomic) NSString *category;

@property (weak, nonatomic) PatrolExamViewModel *viewModel;

@property (assign, nonatomic) NSInteger level;
@property (nonatomic, assign) BOOL isOpen;

+ (PatrolExamCellViewModel *)modelWithType:(ExamCellType)type viewModel:(PatrolExamViewModel *)viewModel;


/**
 获取答案（如果不存在，则创建）

 @return return value description
 */
- (ZJPatrolDetail_results_answers *)getAnswer;

/**
 有操作发送的通知
 */
- (void)postNoti;

@end
