//
//  PatrolExamCellViewModel.m
//  patrol
//
//  Created by Javen on 2017/2/28.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamCellViewModel.h"
#import "PatrolExamViewModel.h"



@implementation PatrolExamCellViewModel

+ (PatrolExamCellViewModel *)modelWithType:(ExamCellType)type viewModel:(PatrolExamViewModel *)viewModel{
    PatrolExamCellViewModel *model = [PatrolExamCellViewModel new];
    model.cellType = type;
    model.viewModel = viewModel;
    model.isOpen = YES;
    return model;
}

- (ZJPatrolDetail_results_answers *)getAnswer {
    self.answer = [self.viewModel answerFromCellModel:self];
    return self.answer;
}

- (ZJPatrolDetail_results_answers *)answer {
    _answer = [self.viewModel.dicAnswers objectForKey:self.question.uuid];
    return _answer;
}

/**
 对answer有操作发送的通知
 */
- (void)postNoti {
    [[NSNotificationCenter defaultCenter] postNotificationName:kNotiPatrolAnswerChange object:self];
}

@end
