//
//  PatrolExamViewModel.h
//  patrol
//
//  Created by Javen on 2017/3/3.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PatrolExamCellViewModel.h"
#import "PatrolTaskCustomModel.h"
#import "PatrolExamState.h"
typedef NS_ENUM(NSInteger, AnswerSubmitAction) {
    AnswerSubmitActionSave,
    AnswerSubmitActionCommit
};
@interface PatrolExamViewModel : NSObject
@property (strong, nonatomic) NSMutableArray *arrCellData;
@property (strong, nonatomic) NSMutableDictionary *dicAnswers;
@property (strong, nonatomic) ZJPatrolDetail_inspectors *inspector;
@property (strong, nonatomic) ZJPatrolDetail *detail;
@property (strong, nonatomic) ZJPatrolDetail_results *result;
@property (nonatomic, copy) void (^blockReloadData)(void);
@property (nonatomic, copy) void (^blockAnswerAction)(void);
@property (nonatomic, copy) void (^blockReHttp)(void);

/**
 门店VI检查的结果
 */
@property (strong, nonatomic) Results *storeResult;

/**
 VI检查计划
 */
@property (strong, nonatomic) PatrolTaskCustomModel *plan;
@property (strong, nonatomic) PatrolExamState *state;


/**
 加载问题详情

 @param complete complete description
 */
- (void)httpDetailComplete:(void (^)(void))complete;


/**
 返回需要被操作的indexPath数组，如果cell是展开状态，则返回的是需要被收起的indexPath数组，如果cell是收起状态，则返回的是需要被展开的indexPath数组

 @param indexPath 当前下标
 @return indexPach array
 */
- (NSMutableArray *)indexPathWithSelectIndexPath:(NSIndexPath *)indexPath;

/**
 打开所有题目
 */
- (NSMutableArray *)openAll;

/**
 折叠所有题目
 */
- (NSMutableArray *)closeAll;

/**
 获取答案，如果没有self.answer为空，则会自动生成一个答案
 
 @return 答案
 */
- (ZJPatrolDetail_results_answers *)answerFromCellModel:(PatrolExamCellViewModel *)cellModel;

/**
 保存答案

 @param action 保存方式 保存/提交
 @param complete complete description
 */
- (void)httpSubmitAnswerWithAction:(AnswerSubmitAction)action complete:(void (^)(BOOL isSuccess))complete;
@end
