//
//  PatrolExamTopView.m
//  patrol
//
//  Created by Javen on 2017/2/27.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamTopView.h"

@implementation PatrolExamTopView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/
- (void)setViewModel:(PatrolExamViewModel *)viewModel {
    _viewModel = viewModel;
    self.labelOperator.text = viewModel.inspector.user_name;
    self.labelPosision.text = viewModel.inspector.store_name;
    self.labelTime.text = [self configTimeBegin:viewModel.detail.beginDate end:viewModel.detail.endDate];
    self.labelTitle.text = viewModel.plan.name;
    self.labelState.text = viewModel.state.text;
    
    NSMutableArray *answerArray = [NSMutableArray array];
    for (id object in viewModel.dicAnswers.allValues) {
        if ([object isKindOfClass:[ZJPatrolDetail_results_answers class]]) {
            ZJPatrolDetail_results_answers *answer = (ZJPatrolDetail_results_answers *)object;
            if (answer.details.count) {
                [answerArray addObject:@1];
            }
        }
    }
    self.labelProgress.text = [NSString stringWithFormat:@"%lu/%lu",answerArray.count, viewModel.detail.questions.count];
}

- (NSString *)configTimeBegin:(NSString *)begin end:(NSString *)end {
    return [NSString stringWithFormat:@"%@%@ ~ %@%@",@"起：",begin, @"止：",end];
}













@end
