//
//  GTONewAddPineeringViewController.m
//  total
//  新增拓站
//  Created by freecui on 15/10/14.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOAlertInfoPioneeringViewController.h"
#import "GTONewAddPioneeringViewController.h"
#import "GTOPatrolTemplate.h"
#import "GTOPioneering.h"
#import "GTOPioneeringTemplateViewController.h"
#import "GTOQuestionManager.h"
#import "GTOSignViewController.h"
#import "GXFBottomView.h"
#import "GXFTableViewCell.h"

#import "GTOAnswer.h"
#import "GTOQResultViewController.h"
#import "GTOQuestion.h"
#import "ICRPostAttachment.h"
#import "RETableViewManager.h"
@interface GTONewAddPioneeringViewController () <
    UITableViewDataSource, UITableViewDelegate, GXFBottomViewDelegate,
    UITextFieldDelegate, GTOAlertInfoPioneeringViewControllerDelegate>
typedef NS_ENUM(NSUInteger, bottomTag) {
  kbottomDelBtnsTag = 0,
  kbottomBackBtnsTag
};
#define BOTTOM_TEXT_DELETE @"删除拓站"
#define BOTTOM_TEXT_BACK @"返回列表"
@property(nonatomic, strong) UITableView *c_tableView;
@property(nonatomic, strong) GTOPioneering *d_pioneering;
@property(nonatomic, strong) GTOPatrolTemplate *d_patrolTemplate;
@property(nonatomic, strong) GTOSignViewController *c_signVC;
@property(nonatomic, assign) BOOL isStartPioneering; //
@property(nonatomic, strong) GTOAlertInfoPioneeringViewController *alertInfoVC;
@property(strong, readwrite, nonatomic) RETableViewManager *manager;
@property(strong, readwrite, nonatomic) RETextItem *titleItem;
@property(strong, readwrite, nonatomic) RERadioItem *templeteSelectItem;
@property(strong, readwrite, nonatomic) RETextItem *locationItem;
@property(strong, readwrite, nonatomic) RETextItem *remarkItem;
@property(nonatomic, strong) BMKMapView *c_mapView;
@property(nonatomic, strong) GXFBottomView *bottomV;
//重构

@property(nonatomic, strong) NSArray *d_arrCategorys; //问题按区域分
@end

@implementation GTONewAddPioneeringViewController

- (void)viewDidLoad {
  [super viewDidLoad];
  // Do any additional setup after loading the view.

  self.title = @"新增拓站";
  [self p_initData];
  [self p_initWithSubViews];
}
- (void)viewWillAppear:(BOOL)animated {
  [super viewWillAppear:animated];
  [self appearMap];
  [self fetchLocalNoSubmittedPioneering];
}
- (void)fetchLocalNoSubmittedPioneering {
  ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
    NSString *sql =
        [NSString stringWithFormat:@"SELECT *  FROM %@ WHERE %@=?",
                                   [GTOPioneering TableName], @"state"];
    NSLog(@"%@", sql);

    return [db executeQuery:sql, GTO_PIONEERING_STATE_LOCAL];
  };

  __weak typeof(self) weakSelf = self;
  ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
    __strong __typeof(weakSelf) strongSelf = weakSelf;
    if (!fetchedObjects) {
      if (_bottomV.tag == kbottomDelBtnsTag) {
        [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_BACK
                                forState:UIControlStateNormal];
        self.bottomV.tag = kbottomBackBtnsTag;
      }

      return;
    }
    if (!_d_pioneering) {
      self.d_pioneering = [[GTOPioneering alloc] init];
    }
    _d_pioneering = fetchedObjects[0];
    //        [strongSelf appearMap];

    // tableview
    _titleItem.value = _d_pioneering.title;
    _templeteSelectItem.value = _d_pioneering.templateName;
    _remarkItem.value = _d_pioneering.remark;

    [_titleItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    [_templeteSelectItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    [_remarkItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    _c_tableView.userInteractionEnabled = NO;
    // bottomView
    if (_bottomV.tag == kbottomBackBtnsTag) {
      [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_DELETE
                              forState:UIControlStateNormal];
      self.bottomV.tag = kbottomDelBtnsTag;
    }

    [strongSelf p_addAlerInfoPioneeringView];
  };

  ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
  [dbCtrl runFetchForClass:[GTOPioneering class]
                fetchBlock:fetchBlk
         fetchResultsBlock:fetchResultsBlk];
}
- (void)appearMap {
  BOOL condition = _c_signVC.latitudeX || _c_signVC.longitudeY ||
                   _d_pioneering.longitude || _d_pioneering.latitude;
  if (condition) {
    _c_mapView.hidden = NO;
    BMKPointAnnotation *pointAnnotation = [[BMKPointAnnotation alloc] init];
    CLLocationCoordinate2D coor;
    coor.latitude = [_c_signVC.latitudeX floatValue]; // 31.2357360000;//
    coor.longitude = [_c_signVC.longitudeY floatValue]; // 121.5292150000;//
    pointAnnotation.coordinate = coor;

    [_c_mapView addAnnotation:pointAnnotation];
    _c_mapView.showsUserLocation = YES;
    _c_mapView.centerCoordinate =
        CLLocationCoordinate2DMake(coor.latitude, coor.longitude);
    _c_mapView.zoomLevel = 17;
  }
}
- (void)p_initData {
  if (!_d_pioneering) {
    self.d_pioneering = [[GTOPioneering alloc] init];
  }
}
- (void)p_initWithSubViews {
  CGFloat signBtnW = 120;
  UIButton *signBtn = [[UIButton alloc]
      initWithFrame:CGRectMake(self.view.width - signBtnW, 0, signBtnW, 44)];
  signBtn.titleLabel.font = [UIFont systemFontOfSize:20];
  [signBtn.titleLabel setTextAlignment:NSTextAlignmentRight];
  [signBtn setTitle:@"记录位置" forState:UIControlStateNormal];
  [signBtn setTitleColor:GTO_BLUE_TINT_COLOR forState:UIControlStateNormal];
  // [signBtn setImage:[UIImage imageNamed:@"icon_nav_start"]
  // forState:UIControlStateNormal];
  [signBtn addTarget:self
                action:@selector(signClicked)
      forControlEvents:UIControlEventTouchUpInside];
  [self.view addSubview:signBtn];
  UIImageView *imgV = [[UIImageView alloc]
      initWithFrame:CGRectMake(self.view.width - signBtn.left - 44, signBtn.y,
                               44, signBtn.height)];
  imgV.image = [UIImage imageNamed:@"icon_nav_start"];

  // table
  self.c_tableView = [[UITableView alloc]
      initWithFrame:CGRectMake(0, signBtn.bottom, ScreenSize.width, 44 * 3)
              style:(UITableViewStylePlain)];

  [self.view addSubview:self.c_tableView];
  self.manager =
      [[RETableViewManager alloc] initWithTableView:self.c_tableView];
  RETableViewSection *section = [RETableViewSection section];
  [self.manager addSection:section];
  self.titleItem =
      [RETextItem itemWithTitle:@"标题：" value:nil
                    placeholder:@"请输入标题"];
  self.templeteSelectItem =
      [RERadioItem itemWithTitle:@"拓站模板："
                           value:nil
                selectionHandler:^(RERadioItem *item) {
                  GTOPioneeringTemplateViewController *VC =
                      [[GTOPioneeringTemplateViewController alloc] init];
                  VC.purpose = @"explorer";
                  // if (VC.choseBaseInfo) {
                  VC.choseBaseInfo = ^(NSArray *templateNames) {
                    GTOPatrolTemplate *patroTemplate = templateNames[0];
                    self.templeteSelectItem.value = patroTemplate.name;
                    self.d_patrolTemplate = patroTemplate;
                    [item reloadRowWithAnimation:UITableViewRowAnimationNone];
                  };
                  [self PushViewController:VC animated:YES];

                }];
  self.remarkItem =
      [RETextItem itemWithTitle:@"备注" value:nil
                    placeholder:@"输入备注内容"];
  [section addItem:_titleItem];
  [section addItem:_templeteSelectItem];
  [section addItem:_remarkItem];

  IBTUILabel *attentionLbl =
      [[IBTUILabel alloc] initWithFrame:CGRectMake(10, _c_tableView.bottom + 10,
                                                   self.view.width, 20)
                                   text:@"注：开始拓站店前请先签到"
                                   font:[UIFont systemFontOfSize:16]
                              tintColor:[UIColor blackColor]
                        backgroundColor:nil
                          textAlignment:NSTextAlignmentLeft];
  [self.view addSubview:attentionLbl];

  CGRect rect = CGRectMake(0, attentionLbl.bottom + 20, self.view.width,
                           self.view.height - (attentionLbl.bottom + 20) -
                               BottomViewHeight - 20 - 64);
  self.c_mapView = [[BMKMapView alloc] initWithFrame:rect];
  [self.view addSubview:_c_mapView];
  _c_mapView.hidden = YES;

  GXFBottomView *bottomV = [[GXFBottomView alloc]
         initWithFrame:CGRectMake(0, _c_mapView.bottom + 20, self.view.width,
                                  BottomViewHeight)
       leftButtonColor:GTO_RED_COLOR
      rightButtonColor:GTO_BLUE_DEEP_COLOR
          LeftBtnTitle:@"返回列表"
         rightBtnTitle:@"开始拓站"];
  bottomV.delegate = self;
  bottomV.tag = kbottomBackBtnsTag;
  self.bottomV = bottomV;
  [self.view addSubview:_bottomV];
}

- (void)p_pioneeringWithatrolTemplate:(GTOPatrolTemplate *)patrolTemple {
  [self p_initData];
  ICRUserUtil *userU = [ICRUserUtil sharedInstance];

  self.d_pioneering.title = _titleItem.value;
  self.d_pioneering.remark = _remarkItem.value;
  self.d_pioneering.uuid = [userU mobileID]; // patrolTemple.uuid;
  self.d_pioneering.version = 0; //新建时为0
  self.d_pioneering.state = GTO_PIONEERING_STATE_LOCAL;
  self.d_pioneering.pioneer_uuid = userU.f_user_uuid;
  self.d_pioneering.pioneer_name = userU.f_user_name;
  self.d_pioneering.pioneer_code = userU.f_user_code;
  self.d_pioneering.templateName = patrolTemple.name;
  self.d_pioneering.beginDate = [[NSDate date] httpParameterString];
  self.d_pioneering.enterprise = userU.f_enterprise_uuid;
  self.d_pioneering.create_time = patrolTemple.create_time; //
  self.d_pioneering.create_id = patrolTemple.create_id;
  self.d_pioneering.create_operName = patrolTemple.create_operName;
  self.d_pioneering.lastModify_time = patrolTemple.lastModify_time;
  self.d_pioneering.lastModify_id = patrolTemple.lastModify_id;

  self.d_pioneering.latitude = _c_signVC.latitudeX;   //@"38.12"; //
  self.d_pioneering.longitude = _c_signVC.longitudeY; //@"89.77"; //

  self.d_pioneering.purpose = patrolTemple.purpose;
  NSMutableArray *muArrQuestions = [NSMutableArray array];
  for (NSDictionary *dictQuestion in patrolTemple.questions) {
    GTOQuestion *question = [GTOQuestion DBObject];
    [question praseFromJsonDict:dictQuestion];
    question.uuid = [[ICRUserUtil sharedInstance] mobileID];
    question.pioneeringUuid = self.d_pioneering.uuid;
    [question saveToDBWithHandleData:NULL complete:NULL fail:NULL];
    [muArrQuestions addObject:[question dictForCommit]];
  }
  self.d_pioneering.questions = muArrQuestions; // patrolTemple.questions;//
  [self p_pioneeringDisplayResults];
}
- (void)p_savePioneering {
  __weak typeof(self) weakSelf = self;
  [_d_pioneering saveToDBWithHandleData:NULL
      complete:^{
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        [IBTLoadingView hideHUDWithText:nil];
        self.isStartPioneering = YES;

        GTOAlertInfoPioneeringViewController *alertInfoVC =
            [[GTOAlertInfoPioneeringViewController alloc]
                initWithPioneering:_d_pioneering];
        self.alertInfoVC = alertInfoVC;
        alertInfoVC.delegate = self;
        [[UIApplication sharedApplication]
                .keyWindow addSubview:_alertInfoVC.view];
      }
      fail:^(NSError *error) {

        [IBTLoadingView hideHUDWithText:error.localizedDescription];
      }];
}
- (void)p_pioneeringDisplayResults {
  //问题的分类
  if (!_d_arrCategorys) {
    NSUInteger uiQuestionsCount = [_d_pioneering.questions count];

    NSArray *arrQuestIDs = [_d_pioneering.questions valueForKeyPath:@"uuid"];

    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
      NSString *sql = [NSString
          stringWithFormat:@"SELECT DISTINCT category  FROM %@ WHERE %@ IN %@  "
                           @"ORDER BY %@ ASC",
                           [GTOQuestion TableName], @"uuid",
                           [IBTModel
                               ValuePlaceholdersWithCount:uiQuestionsCount],
                           @"uuid"];
      NSLog(@"%@", sql); // lineno没有，因为现在后台没有给问题排序

      return [db executeQuery:sql withArgumentsInArray:arrQuestIDs];
    };

    __weak typeof(self) weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
      __strong __typeof(weakSelf) strongSelf = weakSelf;
      NSMutableArray *muArr = [NSMutableArray array];
      for (GTOQuestion *question in fetchedObjects) {
        [muArr addObject:question.category];
      }
      strongSelf.d_arrCategorys = [NSArray arrayWithArray:muArr];

    };

    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[GTOQuestion class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
  }

  //答案  （新建任务答案肯定是没有的，所以这个可以不写）
  ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
    NSString *sql =
        [NSString stringWithFormat:@"SELECT * FROM %@ WHERE %@ = ?",
                                   [GTOAnswer TableName], @"pioneeringUuid"];
    NSLog(@"%@", sql); // lineno没有，因为现在后台没有给问题排序

    return [db executeQuery:sql, _d_pioneering.uuid];
  };

  __weak typeof(self) weakSelf = self;
  ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
    __strong __typeof(weakSelf) strongSelf = weakSelf;
    NSMutableArray *muArrDisplayRs = [NSMutableArray array];

    for (NSString *category in _d_arrCategorys) {

      //答案
      GTODisplayResult *displayR = [[GTODisplayResult alloc] init];
      NSMutableArray *muArrAnswers = [NSMutableArray array];

      for (GTOAnswer *answer in fetchedObjects) {
        if ([answer.category isEqualToString:category])
          //[muArrAnswers addObject:answer];
          [muArrAnswers addObject:[answer dictForCommit]];
      }

      //问题
      NSMutableArray *muArrQuestions = [NSMutableArray array];
      for (NSDictionary *dict in _d_pioneering.questions) {
        if ([dict[@"category"] isEqualToString:category]) {
          GTOQuestion *question = [GTOQuestion DBObject];
          [question praseFromJsonDict:dict];
          //  question.uuid = [[ICRUserUtil sharedInstance]
          //  mobileID];//给所有问题分配唯一标识
          [muArrQuestions addObject:[question dictForCommit]];
        }
      }

      displayR.arrAnswers = muArrAnswers;
      displayR.category = category;
      displayR.isDisplay = NO;

      displayR.arrQuestions = muArrQuestions;

      //            displayR.answerNumber = muArrAnswers.count;
      //            displayR.questionNumber = muArrQuestions.count;
      [muArrDisplayRs addObject:[displayR dictForCommit]];
    }
    // strongSelf.d_arrDisplayResults = muArrDisplayRs;
    strongSelf.d_pioneering.arrCategorys = _d_arrCategorys;
    strongSelf.d_pioneering.arrDisplayResults = muArrDisplayRs;
    strongSelf.d_pioneering.state = GTO_PIONEERING_STATE_LOCAL;
    [strongSelf p_savePioneering];

    [_c_tableView reloadData];

  };

  ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
  [dbCtrl runFetchForClass:[GTOAnswer class]
                fetchBlock:fetchBlk
         fetchResultsBlock:fetchResultsBlk];
}
- (void)p_addAlerInfoPioneeringView {
  GTOAlertInfoPioneeringViewController *alertInfoVC =
      [[GTOAlertInfoPioneeringViewController alloc]
          initWithPioneering:_d_pioneering];
  self.alertInfoVC = alertInfoVC;
  alertInfoVC.delegate = self;
  [[UIApplication sharedApplication].keyWindow addSubview:_alertInfoVC.view];
}
#pragma GXFBottomViewDelegate
- (void)bottomView:(GXFBottomView *)bottomView
  oneButtonClicked:(UIButton *)oneBtn {

  //    if (!self.c_signVC || !self.c_signVC.latitudeX ||
  //    !self.c_signVC.longitudeY) {
  //        [IBTLoadingView showTextOnly:@"开始拓站前，请先签到"
  //        inView:self.view];
  //        return;
  //    }

  if (!_titleItem.value || _titleItem.value.length <= 0) {
    [IBTLoadingView showTextOnly:@"请填写标题" inView:self.view];
    return;
  }
  if (!_templeteSelectItem.value || _templeteSelectItem.value.length <= 0) {
    [IBTLoadingView showTextOnly:@"请选择拓站模板" inView:self.view];
    return;
  }

  //    if (!_isStartPioneering) {//同一个界面点击创建拓站任务，只能创建一次
  if (!_d_pioneering.uuid) {
    [self p_pioneeringWithatrolTemplate:_d_patrolTemplate];

  } else {
    // self.d_isNext = YES;
    [self p_addAlerInfoPioneeringView];
  }
  _c_tableView.userInteractionEnabled = NO;
  if (_bottomV.tag == kbottomBackBtnsTag) {
    [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_DELETE
                            forState:UIControlStateNormal];
    self.bottomV.tag = kbottomDelBtnsTag;
  }
}
- (void)bottomView:(GXFBottomView *)bottomView
 leftButtonClicked:(UIButton *)leftBtn {
  if (bottomView.tag == kbottomBackBtnsTag) {
    [self PopViewControllerAnimated:YES];
    return;
  }
  ICRDataBaseController *dataBaseC = [ICRDataBaseController sharedController];
  [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
    NSString *strSql =
        [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",
                                   [GTOPioneering TableName], @"state"];
    BOOL del = [db executeUpdate:strSql, GTO_PIONEERING_STATE_LOCAL];
    if (!del) {
      [IBTLoadingView showTextOnly:@"删除失败"];
      return;
    }
    _d_pioneering = nil;
    _titleItem.value = nil;
    _templeteSelectItem.value = nil;
    _remarkItem.value = nil;
    _d_arrCategorys = nil;
    self.d_pioneering = nil;

    [_titleItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    [_templeteSelectItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    [_remarkItem reloadRowWithAnimation:UITableViewRowAnimationNone];
    _c_tableView.userInteractionEnabled = YES;

    if (_bottomV.tag == kbottomDelBtnsTag) {
      [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_BACK
                              forState:UIControlStateNormal];
      self.bottomV.tag = kbottomBackBtnsTag;
    }
  }];

  [self localDelete];
}
//本地删除
- (void)localDelete {
  ICRDataBaseController *dataBaseC = [ICRDataBaseController sharedController];
  //删除本地答案
  [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
    NSString *strSql =
        [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",
                                   [GTOAnswer TableName], @"pioneeringUuid"];
    [db executeUpdate:strSql, _d_pioneering.uuid];
  }];
  //删除本地问题
  [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
    NSString *strSql =
        [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",
                                   [GTOQuestion TableName], @"pioneeringUuid"];
    [db executeUpdate:strSql, _d_pioneering.uuid];
  }];
  //删除本地图片
  [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
    NSString *strSql = [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",
                                                  [ICRPostAttachment TableName],
                                                  @"pioneeringUuid"];
    [db executeUpdate:strSql, _d_pioneering.uuid];
  }];
}

- (void)bottomView:(GXFBottomView *)bottomView
RightButtonClicked:(UIButton *)rightBtn {
  if (!_titleItem.value || _titleItem.value.length <= 0) {
    [IBTLoadingView showTextOnly:@"请填写标题" inView:self.view];
    return;
  }
  if (!_templeteSelectItem.value || _templeteSelectItem.value.length <= 0) {
    [IBTLoadingView showTextOnly:@"请选择拓站模板" inView:self.view];
    return;
  }

  if (bottomView.tag == kbottomBackBtnsTag) {
    if (!_d_pioneering.uuid) {
      [self p_pioneeringWithatrolTemplate:_d_patrolTemplate];

    } else {
      // self.d_isNext = YES;
      [self p_addAlerInfoPioneeringView];
    }
    self.bottomV.tag = kbottomDelBtnsTag;
    [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_DELETE
                            forState:UIControlStateNormal];
    return;
  }

  if (bottomView.tag == kbottomDelBtnsTag) {
    [self p_addAlerInfoPioneeringView];
  }
}
#pragma GTOAlertInfoPioneeringViewControllerDelegate
- (void)alertInfoPioneeringViewController:
            (GTOAlertInfoPioneeringViewController *)alertInfoPioneering
                    closeClickedWithBtton:(UIButton *)btn {
  // self.d_isClosed = YES;
  [_alertInfoVC.view removeFromSuperview];
}
- (void)alertInfoPioneeringViewController:
            (GTOAlertInfoPioneeringViewController *)alertInfoPioneering
                seeResultClickedWithBtton:(UIButton *)btn {
  GTOQResultViewController *resultVC =
      [[GTOQResultViewController alloc] initWithPioneering:_d_pioneering];

  // self.d_isClosed = YES;
  [_alertInfoVC.view removeFromSuperview];
  [self PushViewController:resultVC animated:YES];
}
- (void)alertInfoPioneeringViewController:
            (GTOAlertInfoPioneeringViewController *)alertInfoPioneering
                     nextClickedWithBtton:(UIButton *)btn {
  BOOL isAllFinished = YES;
  for (NSDictionary *dict in _d_pioneering.arrDisplayResults) {
    GTODisplayResult *displayR = [GTODisplayResult DBObject];
    [displayR praseFromJsonDict:dict];
    if (displayR.arrAnswers.count < displayR.arrQuestions.count) {
      GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
      mgr.d_category = displayR.category;
      //           [mgr openQuestionVCFromViewControler:self
      //           withPioneering:_d_pioneering];
      BOOL notEdit = NO;
      if ([_d_pioneering.state
              isEqualToString:GTO_PIONEERING_STATE_SUBMITTED]) {
        notEdit = YES;
      } else {
        notEdit = NO;
      }
      [mgr openQuestionVCFromViewControler:self
                                   Licence:nil
                                Pioneering:_d_pioneering
                                 IsNotEdit:notEdit
                              ProblemIndex:0];
      [self alertInfoPioneeringViewController:alertInfoPioneering
                        closeClickedWithBtton:nil];
      isAllFinished = NO;
      break;
    }
  }

  if (isAllFinished) {
    NSDictionary *dictR = [_d_pioneering.arrDisplayResults lastObject];
    GTODisplayResult *displayR = [GTODisplayResult DBObject];
    [displayR praseFromJsonDict:dictR];
    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
    mgr.d_category = displayR.category;
    //        [mgr openQuestionVCFromViewControler:self
    //        withPioneering:_d_pioneering];
    BOOL notEdit = NO;
    if ([_d_pioneering.state isEqualToString:GTO_PIONEERING_STATE_SUBMITTED]) {
      notEdit = YES;
    } else {
      notEdit = NO;
    }
    [mgr openQuestionVCFromViewControler:self
                                 Licence:nil
                              Pioneering:_d_pioneering
                               IsNotEdit:notEdit
                            ProblemIndex:0];
    [self alertInfoPioneeringViewController:alertInfoPioneering
                      closeClickedWithBtton:nil];
  }
}
- (void)alertInfoPioneeringViewController:
            (GTOAlertInfoPioneeringViewController *)alertInfoPioneering
                  didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
  GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
  GTODisplayResult *displayR = [GTODisplayResult DBObject];
  [displayR praseFromJsonDict:_d_pioneering.arrDisplayResults[indexPath.row]];
  mgr.d_category =
      displayR.category; // alertInfoPioneering.d_arrCategorys[indexPath.row];
  //    [mgr openQuestionVCFromViewControler:self withPioneering:_d_pioneering];
  //    [self alertInfoPioneeringViewController:alertInfoPioneering
  //    closeClickedWithBtton:nil];

  BOOL notEdit = NO;
  if ([_d_pioneering.state isEqualToString:GTO_PIONEERING_STATE_SUBMITTED]) {
    notEdit = YES;
  } else {
    notEdit = NO;
  }
  [mgr openQuestionVCFromViewControler:self
                               Licence:nil
                            Pioneering:_d_pioneering
                             IsNotEdit:notEdit
                          ProblemIndex:0];

  [self alertInfoPioneeringViewController:alertInfoPioneering
                    closeClickedWithBtton:nil];
}
//签到
- (void)signClicked {
  GTOSignViewController *signVC = [[GTOSignViewController alloc] init];
  self.c_signVC = signVC;
  [self PushViewController:signVC animated:NO];
}

//- (void)tableView:(UITableView *)tableView willDisplayCell:(UITableViewCell
//*)cell forRowAtIndexPath:(NSIndexPath *)indexPath {
//    if (indexPath.row == 2) {
//        cell.backgroundColor = [UIColor redColor];
//        cell.userInteractionEnabled = NO;
//    }
//}

//- (void)textFieldDidEndEditing:(UITextField *)textField {
//    [self textFieldShouldReturn:textField];
//}
//- (BOOL)textFieldShouldReturn:(UITextField *)textField {
//
//    [textField resignFirstResponder];
//    switch (textField.tag) {
//        case 0:
//           self.d_pioneering.title = textField.text;
//            break;
//        case 1:
//            // self.d_processProduct.productName = textField.text;
//            break;
//        case 2:
//            self.d_pioneering.remark = textField.text;
//            break;
//        default:
//            break;
//    }
//    return YES;
//}

- (void)didReceiveMemoryWarning {
  [super didReceiveMemoryWarning];
  // Dispose of any resources that can be recreated.
}

@end
