//
//  GTOLicenceListCellContentView.m
//  total
//  报修单详情处显示的简单的许可证明细
//  Created by freecui on 15/10/30.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOLicenceListSimpleCellContentView.h"
#import "GTOLicence.h"
@interface GTOLicenceListSimpleCellContentView ()
//@property (strong, nonatomic) IBTUILabel *m_repairTitleLabel;
@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//油站
@property (strong, nonatomic) IBTUILabel *labelStation;//油站
@property (strong, nonatomic) IBTUILabel *m_stateLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_stateValueLabel;//完成状态
@property (nonatomic, strong) IBTUILabel *labelRejectReason;
@property (nonatomic, assign) CGFloat reasonHeight;

@property (strong, nonatomic) UIImageView *m_riskImgView;
@end
@implementation GTOLicenceListSimpleCellContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    self.reasonHeight = 0;
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    //self.m_repairTitleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.labelStation = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateValueLabel = [[IBTUILabel alloc] initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.labelRejectReason = [[IBTUILabel alloc] initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_riskImgView = [[UIImageView alloc]init];
    
    
    
    //[self addSubview:_m_repairTitleLabel];
    [self addSubview:_m_billNumberLabel];
    [self addSubview:_m_storeNameLabel];
    [self addSubview:self.labelStation];
    [self addSubview:_m_stateLabel];
    [self addSubview:_m_stateValueLabel];

    [self addSubview:self.labelRejectReason];
    [self addSubview:_m_riskImgView];
   // [self addSubview:_m_repairDateLabel];
    
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
//    _m_repairTitleLabel.frame = (CGRect){
//        .origin.x = GTO_LEFT_PADDING,
//        .origin.y = GTO_TOP_VERTICAL_PADDING,
//        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
//        .size.height = lblH + 10,
//    };
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    CGFloat leftX = _m_billNumberLabel.x;
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = _m_billNumberLabel.width,
        .size.height = lblH,
    };
    
    _labelStation.frame = CGRectMake(leftX,
                                     _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
                                     self.width,
                                     lblH);
    _m_stateLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _labelStation.bottom + GTO_VERTICAL_PADDING,
        .size.width = 80,
        .size.height = lblH,
    }; [_m_stateLabel sizeToFit];

    _m_stateValueLabel.frame = (CGRect){
        .origin.x = _m_stateLabel.right,
        .origin.y = _labelStation.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING - _m_stateLabel.width,
        .size.height = lblH,
    };
    _labelRejectReason.frame = CGRectMake(_m_billNumberLabel.x,
                                          _m_stateLabel.bottom + GTO_VERTICAL_PADDING,
                                          SCREEN_SIZE.width - GTO_LEFT_PADDING,
                                          self.reasonHeight);
    CGFloat imgW = 40;
    _m_riskImgView.frame = (CGRect){
        .origin.x = self.width - imgW,
        .origin.y = 0,
        .size.width = imgW,
        .size.height = imgW,
    };
//    _m_repairDateLabel.frame = (CGRect){
//        .origin.x = leftX,
//        .origin.y = _m_stateLabel.bottom + GTO_VERTICAL_PADDING,
//        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
//        .size.height = lblH,
//    };
    
}
@end


@implementation GTOLicenceListSimpleCellContentView (configure)

- (void)updateWithLicence:(GTOLicence *)licence {
   // self.m_repairTitleLabel.text = [NSString stringWithFormat:@"许可证类型：%@ ",licence.licenceType];
    self.m_billNumberLabel.text = [NSString stringWithFormat:@"许可证类型：%@ ",licence.licenceType];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"许可证单号：%@ ",licence.billnumber];
    self.labelStation.text = [NSString stringWithFormat:@"油站名称：%@",
                              licence.store_name];
    self.m_stateLabel.text = [NSString stringWithFormat:@"许可证状态: "];
    self.m_stateValueLabel.text = [GTOCommonTools licenceStateChineseWithEnglish:licence.state];
    self.m_stateValueLabel.textColor = [GTOCommonTools textColorWithState:licence.state];
    self.labelRejectReason.text = [NSString stringWithFormat:@"拒绝理由：%@",
                                   licence.rejectCause];
   // self.m_repairDateLabel.text = [NSString stringWithFormat:@"申请时间：%@",licence.requestDate ];
    if ([licence.riskGrade isEqualToString:@"高"]) {
        self.m_riskImgView.image = [UIImage imageNamed:@"licence_hight"];
    } else {
        self.m_riskImgView.image = [UIImage imageNamed:@"licence_middle"];
    }
    
    if ([licence.state isEqualToString:@"rejected"]) {
        self.reasonHeight = 17;
        self.labelRejectReason.height = 17;
        self.labelRejectReason.hidden = NO;
    }else{
        self.reasonHeight = 0;
        self.labelRejectReason.height = 0;
        self.labelRejectReason.hidden = YES;
    }
    [self layoutIfNeeded];
}
@end



