//
//  GTORepairListCellContentView.m
//  total
//
//  Created by freecui on 15/10/29.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTORepairListCellContentView.h"
#import "GTORepair.h"
@interface GTORepairListCellContentView ()
@property (strong, nonatomic) IBTUILabel *m_repairTitleLabel;
@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (nonatomic, strong) IBTUILabel *labelProposer;//报修申请人
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//油站
@property (strong, nonatomic) IBTUILabel *m_stateLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_stateValueLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_repairDateLabel;//开始时间
@property (nonatomic, strong) UIImageView *imgRight;

@end
@implementation GTORepairListCellContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_repairTitleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.labelProposer = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_repairDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.imgRight = [UIImageView new];
    self.imgRight.image = [UIImage imageNamed:@"23"];
    [self addSubview:_m_repairTitleLabel];
    [self addSubview:_m_billNumberLabel];
    [self addSubview:self.labelProposer];
    [self addSubview:_m_storeNameLabel];
//    [self addSubview:_m_stateLabel];
    [self addSubview:_m_stateValueLabel];
    [self addSubview:_m_repairDateLabel];
    [self addSubview:self.imgRight];
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_repairTitleLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - 100,
        .size.height = lblH + 10,
    };
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _m_repairTitleLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _labelProposer.frame = CGRectMake(_m_repairTitleLabel.x,
                                      _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
                                      _m_billNumberLabel.width,
                                      lblH);
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _labelProposer.bottom + GTO_VERTICAL_PADDING,
        .size.width = _labelProposer.width,
        .size.height = lblH,
    };
    _m_stateValueLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.right,
        .origin.y = _m_repairTitleLabel.y,
        .size.width = ScreenSize.width - _m_repairTitleLabel.right - 30,
        .size.height = lblH,
    };
    _imgRight.frame = CGRectMake(_m_stateValueLabel.right, _m_stateValueLabel.y, 10, _m_stateValueLabel.height);
    _m_repairDateLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };

}
@end


@implementation GTORepairListCellContentView (configure)

- (void)updateWithRepair: (GTORepair *)repair {
    self.m_repairTitleLabel.text = [NSString stringWithFormat:@"%@ ",repair.title];
    self.m_billNumberLabel.text = [NSString stringWithFormat:@"报修单号：%@ ",repair.billnumber];
    self.labelProposer.text = [NSString stringWithFormat:@"报修申请人：%@",
                               repair.requestor];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称：%@ ",repair.store_name];
    self.m_stateLabel.text = [NSString stringWithFormat:@"报修状态:  "];
    self.m_stateValueLabel.text = [GTOCommonTools repairStateChineseWithEnglish:repair.state];
    self.m_stateValueLabel.textColor = [GTOCommonTools textColorWithRepairState:repair.state];
    self.m_repairDateLabel.text = [NSString stringWithFormat:@"报修时间：%@",
                                   [repair.repairDate substringToIndex:11]];
    [self layoutSubviews];
}
@end
