//
//  SaveCommitView.m
//  total
//
//  Created by 曹云霄 on 16/6/21.
//  Copyright © 2016年 free. All rights reserved.
//

#import "SaveCommitView.h"

@implementation SaveCommitView

//初始化方法
+ (instancetype)initializeOne
{
    return [[[NSBundle mainBundle] loadNibNamed:@"SaveCommitView" owner:nil options:nil] firstObject];
}

+ (instancetype)initializeTwo
{
    return [[[NSBundle mainBundle] loadNibNamed:@"SaveCommitView" owner:nil options:nil] objectAtIndex:1];
}

+ (instancetype)initializeThird
{
    return [[[NSBundle mainBundle] loadNibNamed:@"SaveCommitView" owner:nil options:nil] lastObject];
}

- (void)awakeFromNib
{
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.saveButton.layer.masksToBounds = YES;
    self.saveButton.layer.cornerRadius = TCcornerRadius;
    self.commitButton.layer.masksToBounds = YES;
    self.commitButton.layer.cornerRadius = TCcornerRadius;
    self.delectButton.layer.masksToBounds = YES;
    self.delectButton.layer.cornerRadius = TCcornerRadius;
    self.invalidButton.layer.masksToBounds = YES;
    self.invalidButton.layer.cornerRadius = TCcornerRadius;
}

#pragma mark -保存、提交
- (IBAction)saveButtonClickAction:(UIButton *)sender {
    
    switch (sender.tag) {
        case 100:
        {
            if (self.saveButtonBlock) {
                self.saveButtonBlock();
            }
        }
            break;
        case 101:
        {
            if (self.commitButtonBlock) {
                self.commitButtonBlock();
            }
        }
            break;
        case 102:
        {
            if (self.delectButtonBlock) {
                self.delectButtonBlock();
            }
        }
            break;
        case 103:
        {
            if (self.invalidButtonBlock) {
                self.invalidButtonBlock();
            }
        }
            break;
            
        default:
            break;
    }
}

@end
