//
//  GTOHomeWeatherItem.m
//  total
//  天气展示
//  Created by freecui on 15/10/12.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOHomeWeatherItem.h"

@interface GTOHomeWeatherItem ()
@property(nonatomic, strong) IBTUILabel *dateLabel;
@property(nonatomic, strong) IBTUILabel *weatherLabel;
@end
@implementation GTOHomeWeatherItem


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
    [self initSubviews];
    return self;
}
- (void) initSubviews {
    UIFont *font = [UIFont systemFontOfSize:16];
    self.dateLabel = [[IBTUILabel alloc] initWithfont:font
                                            tintColor:[UIColor whiteColor]
                                      backgroundColor:[UIColor clearColor]
                                        textAlignment:NSTextAlignmentRight];
    self.weatherLabel = [[IBTUILabel alloc] initWithfont:font
                                            tintColor:[UIColor whiteColor]
                                      backgroundColor:[UIColor clearColor]
                                        textAlignment:NSTextAlignmentRight];

    [self addSubview:_dateLabel];
    [self addSubview:_weatherLabel];

}
- (void)layoutSubviews {
    CGFloat padding = 10;
    CGFloat lblH = 20;
    self.dateLabel.frame = ((CGRect){
            .origin.x = padding,
            .origin.y = 7,
            .size.width = self.width - 2 * padding,
            .size.height = lblH
    });
    self.weatherLabel.frame = ((CGRect){
        .origin.x = _dateLabel.x,
        .origin.y = _dateLabel.bottom + 7,
        .size.width = _dateLabel.width,
        .size.height = lblH
    });
}

- (UIButton *)p_buttonWithImageName: (NSString *)imgName {
    UIButton *btn = [[UIButton alloc] init];
    [btn setImage:[UIImage imageNamed:imgName] forState:UIControlStateNormal];
    [btn.titleLabel setFont:[UIFont systemFontOfSize:16]];
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    return btn;
}
@end
@implementation GTOHomeWeatherItem (configure)
- (void)updateWithCity: (NSString *)cityName
           temperature: (NSString *)tem
         windDirection: (NSString *)wd{
    NSDate *date = [NSDate date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc]init];
    [dateFormatter setDateFormat:@"yyyy年MM月dd日"];
    NSString *strDate = [dateFormatter stringFromDate:date];
    self.dateLabel.text = [NSString stringWithFormat:@"%@ %@",strDate,cityName];
    
    NSString *strWeather = [NSString stringWithFormat:@"%@   %@°C", wd,tem];
    self.weatherLabel.text = strWeather;
    [self layoutSubviews];
}
@end