//
//  ICRSystemViewController.m
//  XFFruit
//
//  Created by Xummer on 3/24/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "GTOMeViewController.h"
#import "ICRSystemHeaderView.h"
#import "ICRModifyPwdViewController.h"
#import "ICRConfigurationViewController.h"
#import "ICRHelpAndFeedBackViewController.h"
#import "ICRAboutViewController.h"

#if DEBUG
//#import "ICRHTTPApiTestViewController.h"
#endif

@interface GTOMeViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;
@property (weak, nonatomic) ICRSystemHeaderView *m_tableHeader;
@end

@implementation GTOMeViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initTableViewInfo];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)initTableViewInfo {
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    tableV.backgroundColor = [UIColor colorWithW:246 a:1];
    [self.view addSubview:tableV];
    
    // Header
    ICRSystemHeaderView *tableHeader = [[ICRSystemHeaderView alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = tableV.width,
        .size.height = 150
    }];
    tableV.tableHeaderView = tableHeader;
    self.m_tableHeader = tableHeader;
    
    [tableHeader updateWithUserUtil];
    
    // Footer
    UIButton *btn = nil;
    UIView *tableFooter =
    [tableV buttonViewWithTitle:@"退出登录"
                          color:ICR_ORANGE_BTN_COLOR
                         topGap:25
                        pointer:&btn
                         target:self
                         action:@selector(onLogout:)];
    tableV.tableFooterView = tableFooter;
    
    IBTTableViewSectionInfo *secInfo;
    IBTTableViewCellInfo *cellInfo;
    
    UIColor *titleColor = [UIColor colorWithW:109 a:1];
    CGFloat fCellHeight = IBT_DEFAULT_CELL_HEIGHT;
    
    secInfo = [IBTTableViewSectionInfo sectionInfoDefaut];
    // Change Password
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onChangePassword:) target:self
                                     title:@"修改密码"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryDisclosureIndicator];
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    
    // Setting
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onShowSettingView:) target:self
                                     title:@"配置"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryDisclosureIndicator];
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    
    // Help & Feedback
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onShowHelpAndFeedBackView:) target:self
                                     title:@"帮助与反馈"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryDisclosureIndicator];
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    
    // About
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onShowAboutView:) target:self
                                     title:@"关于我们"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryDisclosureIndicator];
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    
    [self.m_tableViewInfo addSection:secInfo];
    
    //#if DEBUG
    //    // HTTP API
    //    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"Test"];
    //    cellInfo =
    //    [IBTTableViewCellInfo normalCellForSel:@selector(onShowHTTPTestView:) target:self
    //                                     title:[IBTCommon localizableString:@"HTTP Restful API"]
    //                                rightValue:nil
    //                             accessoryType:UITableViewCellAccessoryDisclosureIndicator];
    //    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    //    cellInfo.fCellHeight = fCellHeight;
    //    [secInfo addCell:cellInfo];
    //    [self.m_tableViewInfo addSection:secInfo];
    //#endif
    
    
}

#pragma mark - Actions
- (void)onLogout:(__unused id)sender {
    ICRAppViewControllerManager *mgr =
    [ICRAppViewControllerManager getAppViewControllerManager];
    [mgr doLogout];
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    userUtil.f_isLogout = YES;
    [userUtil saveArchive];
}

- (void)onChangePassword:(__unused id)sender {
    ICRModifyPwdViewController *modifyPWDVC = [[ICRModifyPwdViewController alloc] init];
    [self PushViewController:modifyPWDVC animated:YES];
}

- (void)onShowSettingView:(__unused id)sender {
    ICRConfigurationViewController *configurationVC = [[ICRConfigurationViewController alloc] init];
    [self PushViewController:configurationVC animated:YES];
}


- (void)onShowHelpAndFeedBackView:(__unused id)sender {
    ICRHelpAndFeedBackViewController *helpAndFeedVC = [[ICRHelpAndFeedBackViewController alloc] init];
    [self PushViewController:helpAndFeedVC animated:YES];
}

- (void)onShowAboutView:(__unused id)sender {
    ICRAboutViewController *aboutVC = [[ICRAboutViewController alloc] init];
    [self PushViewController:aboutVC animated:YES];
}

//#if DEBUG
//- (void)onShowHTTPTestView:(__unused id)sender {
//    ICRHTTPApiTestViewController *apiTestCtrl = [[ICRHTTPApiTestViewController alloc] init];
//    [self PushViewController:apiTestCtrl animated:YES];
//}
//#endif

@end
