//
//  BaseModel.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/25.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "BaseModel.h"

@implementation BaseModel

+ (BOOL)propertyIsOptional:(NSString *)propertyName
{
    return YES;
}

/**
 字典转模型
 
 @param dic 字典
 @return 转换之后的模型类
 */
+ (instancetype)modelWithDic:(NSDictionary *)dic {
    id model = [[self alloc] initWithDictionary:dic error:nil];
    return model;
}

+ (JSONKeyMapper *)keyMapper {
    return [[JSONKeyMapper alloc] initWithModelToJSONDictionary:@{@"fid":@"id"}];
}

/**
 模型转模型
 
 @param model 要转换的模型类
 @return 转换之后的模型类
 */
- (instancetype)modelWithModel:(id)model {
    id destinationModel = [[self class] modelWithDic:[model toDictionary]];
    return destinationModel;
}

@end


@implementation InspectQuickLookQuery



@end















