//
//  BasePatrolExamTableViewCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BasePatrolExamTableViewCell.h"

@implementation BasePatrolExamTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];

    self.selectionStyle = UITableViewCellSelectionStyleNone;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(actionNotiAnswerChanged:) name:kNotiPatrolAnswerChange object:nil];
}

- (void)actionNotiAnswerChanged:(NSNotification *)noti {
    PatrolExamCellViewModel *cellModel = noti.object;
    if (![cellModel.question.uuid isEqualToString:self.cellModel.question.uuid]) {
        return;
    }
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    _cellModel = cellModel;
    if (cellModel.cellType == ExamCellTypeAttachment ||
        cellModel.cellType == ExamCellTypeCatogory ||
        cellModel.cellType == ExamCellTypeQuestion) {
        self.userInteractionEnabled = YES;
    }else{
        self.userInteractionEnabled = cellModel.viewModel.state.type == PatrolExamStateProcessing;
    }
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kNotiPatrolAnswerChange object:nil];
}

@end
