//
//  BaseViewModel.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "BaseViewModel.h"
#import "NetWorkRequestManager.h"
@implementation BaseViewModel



- (void)setBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock
{
    _returnBlock = successBlock;
    _failureBlock = failureBlock;
}

- (void)HTTPRequest:(NSString *)urlString type:(HTTP_TYPE)type parmeter:(NSDictionary *)parmeter successBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock
{
    switch (type) {
        case POST:
        {
            [self POSTRequest:urlString parmeter:parmeter successBlock:^(id returnValue) {
                successBlock(returnValue);
            } failureBlock:^(id errorValue) {
                failureBlock(errorValue);
            }];
        }
            break;
        case GET:
        {
            [self GETRequest:urlString parmeter:parmeter successBlock:^(id returnValue) {
                successBlock(returnValue);
            } failureBlock:^(id errorValue) {
                failureBlock(errorValue);
            }];
        }
            break;
            
        default:
            break;
    }
}

- (void)POSTRequest:(NSString *)urlString parmeter:(NSDictionary *)parmeter successBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock
{
    [[NetWorkRequestManager shareManager] POST:[NSString stringWithFormat:@"%@%@",HTTP_LOCAL_BASE_URL,urlString] withParmeter:parmeter success:^(id returnValue) {
        successBlock(returnValue);
    } failure:^(id errorValue) {
        failureBlock(errorValue);
    }];
}

- (void)GETRequest:(NSString *)urlString parmeter:(NSDictionary *)parmeter successBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock
{
    [[NetWorkRequestManager shareManager] GET:[NSString stringWithFormat:@"%@%@",HTTP_LOCAL_BASE_URL,urlString] withParmeter:parmeter success:^(id returnValue) {
        successBlock(returnValue);
    } failure:^(id errorValue) {
        failureBlock(errorValue);
    }];
}


+ (BOOL)verifyData:(id)object
{
    if ([object isKindOfClass:[NSDictionary class]]) {
        if ([object[@"success"] integerValue] == 1) {
            return YES;
        }
    }
    return NO;
}

+ (NSDictionary *)formatData:(id)object
{
    if ([[self class] verifyData:object]) {
        return object[@"data"];
    }
    return [NSMutableDictionary dictionary];
}


+ (NSString *)messageData:(id)object
{
    if (![[self class] verifyData:object]) {
        return object[@"message"];
    }
    return @"加载失败";
}

#pragma mark -获取服务器时间
- (void)getSystemTime:(SuccessBlock)success
{
    [RequestManager request_SystemTimeSuccess:^(id returnValue) {
        NSString *date = nil;
        if ([[self class] verifyData:returnValue]) {
            date = (NSString *)[[self class] formatData:returnValue];
            success(date);
        }else {
            date = [[NSDate date] httpParameterString];
            success(date);
        }
    } failure:^(id errorValue) {
        
    }];
}








@end
