//
//  BaseViewController.m
//  total
//
//  Created by 曹云霄 on 16/7/8.
//  Copyright © 2016年 Delevin. All rights reserved.
//

#import "BaseViewController.h"
#import "MZFormSheetPresentationController-Bridging-Header.h"
@interface BaseViewController ()

@end

@implementation BaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.navigationController.navigationBar.subviews[0].subviews[0].hidden = YES;
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    // 禁用 iOS7 返回手势
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
}

#pragma mark -UIAlertView
- (void)showAlertViewController:(NSString *)message withCompleted:(void(^)(void))completed
{
    UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
    [alertVc addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil]];
    [alertVc addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (completed) {
            completed();
        }
    }]];
    [self presentViewController:alertVc animated:YES completion:nil];
}

#pragma mark -弹出框
- (void)showController:(UIViewController *)controller size:(CGSize)size
{
    MZFormSheetPresentationViewController *formSheetController = [[MZFormSheetPresentationViewController alloc] initWithContentViewController:controller];
    formSheetController.contentViewControllerTransitionStyle = MZFormSheetPresentationTransitionStyleSlideFromTop;
    formSheetController.presentationController.shouldCenterVertically = YES;
    formSheetController.presentationController.shouldDismissOnBackgroundViewTap = MZFormSheetPresentationTransitionStyleSlideFromTop;
    formSheetController.presentationController.contentViewSize = size;
    [self presentViewController:formSheetController animated:YES completion:nil];
}

- (void)dealloc
{
    NSLog(@"释放%@",self.title);
}


@end
