//
//  FilterConfig.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterConfig.h"
#import "PatrolTaskViewController.h"
#import "InspectionTableViewController.h"

@implementation FilterModel



@end


@implementation FilterConfig


#pragma mark -通过类名区分不同的筛选条件
+ (NSArray *)filterItemByClassName:(NSString *)name
{
    BaseViewController *vc = (BaseViewController *)[[NSClassFromString(name) alloc] init];
    NSArray *filterArray = nil;
    if ([vc isKindOfClass:[InspectionTableViewController class]]) {
        filterArray = [[self class] patrolInpectResultFilter];
    }else if ([vc isKindOfClass:[PatrolTaskViewController class]]) {
        filterArray = [[self class] patrolInpectPlanFilter];
    }
    return filterArray;
}


/*
 FILTER_TIME = 0,                 //时间筛选
 FILTER_AREA,                     //区域筛选
 FILTER_STORE,                    //门店筛选
 FILTER_STORE_TYPE,               //门店类型
 FILTER_SUPERVISOR,               //督导人员
 FILTER_INSPECTTASK,              //自检任务项任务项
 FILTER_INSPECTTASK_STATE,        //自检任务状态
 FILTER_PATROL_INSPECTTASK,       //VI检查任务项任务项
 FILTER_PATROL_INSPECTTASK_STATE, //VI检查任务状态
 FILTER_CHECKITEM,                //自检检查项
 FILTER_SORT                      //排序方式
*/


#pragma mark -自检结果筛选项/值
+ (NSArray *)inpectDetailFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"时间",@"type":@(FILTER_TIME)},
                              @{@"name":@"区域",@"type":@(FILTER_AREA)},
                              @{@"name":@"门店",@"type":@(FILTER_STORE)},
                              @{@"name":@"门店类型",@"type":@(FILTER_STORE_TYPE)},
                              @{@"name":@"督导人员",@"type":@(FILTER_SUPERVISOR)},
                              @{@"name":@"任务",@"type":@(FILTER_INSPECTTASK)},
                              @{@"name":@"检查项",@"type":@(FILTER_CHECKITEM)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        if (model.type == FILTER_SUPERVISOR) {
            //督导人员选择权限判断
            if (![kUser.orgCode isEqualToString:HQCODE]) {
                continue;
            }
        }
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}


#pragma mark -VI检查任务筛选项/值
+ (NSArray *)patrolInpectPlanFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"时间",@"type":@(FILTER_TIME)},
                              @{@"name":@"门店",@"type":@(FILTER_STORE)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}

#pragma mark -VI检查结果筛选项/值
+ (NSArray *)patrolInpectResultFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"时间",@"type":@(FILTER_TIME)},
                              @{@"name":@"任务",@"type":@(FILTER_PATROL_INSPECTTASK)},
                              @{@"name":@"督导人员",@"type":@(FILTER_SUPERVISOR)},
                              @{@"name":@"门店",@"type":@(FILTER_STORE)},
                              @{@"name":@"任务状态",@"type":@(FILTER_PATROL_INSPECTTASK_STATE)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}


#pragma mark -整改列表筛选项/值
+ (NSArray *)rectificationListFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"时间",@"type":@(FILTER_TIME)},
                              @{@"name":@"状态",@"type":@(FILTER_PATROL_RECTIFICATIONSTATE)},
                              @{@"name":@"类型",@"type":@(FILTER_PATROL_RECTIFICATIONTYPE)},
                              @{@"name":@"优先级",@"type":@(FILTER_PATROL_RECTIFICATIONPRIORITY)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}

#pragma mark -设备报修列表筛选项/值
+ (NSArray *)repairsListFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"状态",@"type":@(FILTER_PATROL_REPAIRS_STATE)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}


#pragma mark -优秀案例筛选
+ (NSArray *)goodCaseListFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[@{@"name":@"内容类似于",@"type":@(FILTER_CONTENTLIKEINPUT)},
                              @{@"name":@"关键字类似于",@"type":@(FILTER_KEYWORDLIKEINPUT)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}

#pragma mark -签到历史筛选
+ (NSArray *)signHistoryListFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[
                              @{@"name":@"时间",@"type":@(FILTER_TIME)},
                              @{@"name":@"区域",@"type":@(FILTER_AREA)},
                              @{@"name":@"门店",@"type":@(FILTER_STORE)},
                              @{@"name":@"人员列表",@"type":@(FILTER_STOREUSERS)},
                              @{@"name":@"签到类型",@"type":@(FILTER_SIGNTYPE)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}


#pragma mark -工作汇报筛选
+ (NSArray *)workReportListFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[
                              @{@"name":@"关键字",@"type":@(FILTER_PATROL_WORKREPORT_LIKE)},
                              @{@"name":@"状态",@"type":@(FILTER_PATROL_WORKREPORT_STATE)},
                              @{@"name":@"排序方式",@"type":@(FILTER_SORT)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}


#pragma mark -签到统计筛选
+ (NSArray *)signInStatisticalFilter
{
    //筛选条件
    NSMutableArray *filters = [NSMutableArray array];
    //筛选条件详情选中下标
    NSMutableArray *conditionIndexPaths = [NSMutableArray array];
    
    NSArray *filterTitles = @[
                              @{@"name":@"日期",@"type":@(FILTER_SIGNSTATISTICALTIME)},
                              @{@"name":@"区域",@"type":@(FILTER_AREA)},
                              @{@"name":@"是否签到",@"type":@(FILTER_SIGNINSTATE)}];
    for (NSDictionary *dict in filterTitles) {
        FilterModel *model = [[FilterModel alloc] initWithDictionary:dict error:nil];
        [filters addObject:model];
        [conditionIndexPaths addObject:[NSNull null]];
    }
    return @[filters,conditionIndexPaths];
}

@end
