//
//  FilterListViewController.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterListViewController.h"
#import "FilterDefaultTableViewCell.h"
#import "FilterTimeChooseTableViewCell.h"
#import "FilterDetailViewController.h"
#import "FilterConfig.h"
#import "FilterInputTableViewController.h"


@interface FilterListViewController ()

@end

@implementation FilterListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addResetButtonItem];
}

#pragma mark -添加重置ButtonItem
- (void)addResetButtonItem
{
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"重置" style:UIBarButtonItemStyleDone target:self action:@selector(resetFilterChooseValue)];
    [self.beginQueryButton setTitle:@"开始查询" forState:UIControlStateNormal];
}

#pragma mark -重置
- (void)resetFilterChooseValue {
    [self.filterViewModel resetFilterCondition];
    [self.tableView reloadData];
}

#pragma mark -确认查询
- (IBAction)sureQueryButtonAction:(UIButton *)sender {
    if (self.subject) {
        [self.filterViewModel sureFilterCondition];
        [self.subject sendNext:self.filterViewModel];
    }
}

#pragma mark -<UITableViewDelegate,UITableDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *conditionCell = [self.filterViewModel conditionItemCell:indexPath tableView:tableView];
    return conditionCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.filterViewModel.fileterArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    FilterModel *itemModel = [self.filterViewModel.fileterArray yx_objectAtIndex:indexPath.row];
    if (itemModel.type == FILTER_TIME) {
        return 90;
    }
    return 50;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.01;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    FilterModel *itemModel = [self.filterViewModel.fileterArray yx_objectAtIndex:indexPath.row];
    @weakify(self);
    if (itemModel.type == FILTER_KEYWORDLIKEINPUT || itemModel.type == FILTER_CONTENTLIKEINPUT || itemModel.type == FILTER_PATROL_WORKREPORT_LIKE) {
        [self.filterViewModel gotoInputDetailVc:indexPath success:^(id returnValue) {
            FilterInputTableViewController *inputVc = [FilterInputTableViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_FILTER];
            inputVc.conditionIndexPath = indexPath;
            inputVc.inputModel = returnValue;
            inputVc.sureButtonBlock = ^(NSString *keywordString,FilterSearchModel *model, NSIndexPath *conditionIndexPath) {
                @strongify(self);
                [self.filterViewModel updateInputConditionModel:model conditionIndexPath:conditionIndexPath tableView:self.tableView];
            };
            [self pushViewController:inputVc animated:YES];
        }];
    }else {
        [self.filterViewModel gotoConditionDetailVc:indexPath success:^(id returnValue) {
            FilterDetailViewController *detailVc = [FilterDetailViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_FILTER];
            [detailVc setSureButtonBlock:^(NSIndexPath *indexPath,FilterSearchModel *model,NSIndexPath *conditionIndexPath) {
                @strongify(self);
                [self.filterViewModel updateSomeCondition:indexPath conditionModel:model conditionIndexPath:conditionIndexPath tableView:self.tableView];
            }];
            NSArray *senderArray = @[returnValue,indexPath];
            detailVc.conditionIndexPath = senderArray[1];
            detailVc.filterArray = senderArray[0];
            [self pushViewController:detailVc animated:YES];
        }];
    }
}

#pragma mark -lazy
- (FilterViewModel *)filterViewModel
{
    if (!_filterViewModel) {
        _filterViewModel = [[FilterViewModel alloc] init];
    }
    return _filterViewModel;
}

































@end
