//
//  FilterViewModel.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterViewModel.h"
#import "FilterDefaultTableViewCell.h"
#import "FilterTimeChooseTableViewCell.h"
#import "FilterAreaModel.h"
#import "FilterSearchModel.h"
#import "FilterStoreTypeModel.h"
#import "FilterSupervisorModel.h"
#import "FilterInspectItemsModel.h"
#import "PatrolTaskViewController.h"
#import "InspectionTableViewController.h"
#import "FilterPatrolInspectPlanModel.h"
#import "YXPickerManager.h"


@implementation FilterViewModel

#pragma mark -获取筛选项
- (void)setFileterArray:(NSArray<FilterModel *> *)fileterArray {
    _fileterArray = fileterArray;
    self.useQueryModel = [self.queryModel copy];
    [self queryDate];
    [self getLocalSort:nil];
}

#pragma mark -获取时间信息（开始时间、截止时间）
- (void)queryDate {
    for (FilterModel *model in self.fileterArray) {
        if (model.type == FILTER_TIME) {
            //VI检查任务、VI检查结果（开始时间-截止时间默认相差7天）
            if ([self.classVc isKindOfClass:[PatrolTaskViewController class]] || [self.classVc isKindOfClass:[InspectionTableViewController class]] ) {
                model.value = [ToolsManager getTimeby:-7];
                model.uuid = [[NSDate date] yearMonthDayString];
            }else {
                model.value = [[NSDate date] yearMonthDayString];
                model.uuid = [[NSDate date] yearMonthDayString];
            }
        }else if (model.type == FILTER_SIGNSTATISTICALTIME) {
            model.value = [[NSDate date] yearMonthDayString];
        }
    }
}

#pragma mark - 获取区域信息
- (void)queryArea:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_Area_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterAreaModel *model = [[FilterAreaModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterAreaModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:[record toDictionary] error:nil];
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark - 获取门店信息
- (void)queryStore:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_Store_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterAreaModel *model = [[FilterAreaModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterAreaModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:[record toDictionary] error:nil];
                searchModel.name = [NSString stringWithFormat:@"[%@]%@",searchModel.code,searchModel.name];
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark - 获取门店类型
- (void)queryStoreType:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_StoreType_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterStoreTypeModel *model = [[FilterStoreTypeModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterStoreTypeModel_data *record in model.data) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] init];
                searchModel.name = record.text;
                searchModel.uuid = record.value;
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark - 获取督导人员
- (void)querySupervisor:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_Supervisor_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterSupervisorModel *model = [[FilterSupervisorModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterSupervisorModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:[record toDictionary] error:nil];
                searchModel.code = record.login;
                searchModel.name = [NSString stringWithFormat:@"[%@]%@",searchModel.code,searchModel.name];
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark - 获取门店人员
- (void)queryStoreUsers:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_StoreUsers_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterSupervisorModel *model = [[FilterSupervisorModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterSupervisorModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:[record toDictionary] error:nil];
                searchModel.code = record.login;
                searchModel.name = [NSString stringWithFormat:@"[%@]%@",searchModel.code,searchModel.name];
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark -获取自检任务
- (void)queryInspectionTasks:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_InspectTask_Success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterAreaModel *model = [[FilterAreaModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterAreaModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:[record toDictionary] error:nil];
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}


#pragma mark - 获取自检检查项
- (void)queryInspectItems:(SuccessBlock)successBlock {
    //如果选择了自检任务，则查询此任务对应的检查项
    NSString *praiseUuid = nil;
    for (FilterModel *model in self.fileterArray) {
        if (model.type == FILTER_INSPECTTASK) {
            praiseUuid = model.uuid;
            break;
        }
    }
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_InspectCheckItemByPraiseUuid:praiseUuid success:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterInspectItemsModel *model = [[FilterInspectItemsModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterInspectItemsModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] init];
                searchModel.name = record.title;
                searchModel.uuid = record.title;
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark -获取VI检查任务列表
- (void)queryPatrolInspectPlanList:(SuccessBlock)successBlock {
    [IBTLoadingView showProgressLabel:@"加载中..."];;
    [RequestManager request_QueryPatrolInspectResultSuccess:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([[self class] verifyData:returnValue]) {
            NSMutableArray *searchArray = [NSMutableArray array];
            FilterPatrolInspectPlanModel *model = [[FilterPatrolInspectPlanModel alloc] initWithDictionary:returnValue error:nil];
            for (FilterPatrolInspectPlanModel_data_records *record in model.data.records) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] init];
                searchModel.name = record.planname;
                searchModel.uuid = record.planuuid;
                [searchArray addObject:searchModel];
            }
            [self conditionIsSelected:searchArray];
            successBlock(searchArray);
            return;
        }
        [IBTLoadingView showTextOnly:[[self class] messageData:returnValue]];
    } failure:^(id errorValue) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:errorValue];
    }];
}

#pragma mark -获取VI检查任务状态
- (void)queryPatrolInspectPlanState:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name":@"待执行",@"uuid":@"1"},
                            @{@"name":@"执行中",@"uuid":@"2"},
                            @{@"name":@"已结束",@"uuid":@"3"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -整改列表状态
- (void)queryRectificationState:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"全部",
                              @"uuid" : @""},
                            @{@"name" : @"待处理",
                              @"uuid" : @"submited"},
                            @{@"name" : @"处理中",
                              @"uuid" : @"processing"},
                            @{@"name" : @"待复查",
                              @"uuid" : @"processed"},
                            @{@"name" : @"复查不通过",
                              @"uuid" : @"rejected"},
                            @{@"name" : @"已完成",
                              @"uuid" : @"finished"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -整改列表类型
- (void)queryRectificationType:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"全部",
                              @"uuid" : @""},
                            @{@"name" : @"自检",
                              @"uuid" : @"inspection"},
                            @{@"name" : @"VI检查",
                              @"uuid" : @"inspection"},
                            @{@"name" : @"自定义",
                              @"uuid" : @"other"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -整改列表优先级
- (void)queryRectificationPriority:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"全部",
                              @"uuid" : @""},
                            @{@"name" : @"高",
                              @"uuid" : @"高"},
                            @{@"name" : @"中",
                              @"uuid" : @"中"},
                            @{@"name" : @"低",
                              @"uuid" : @"低"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -设备报修状态
- (void)reparesState:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"全部",
                              @"uuid" : @""},
                            @{@"name" : @"已提交",
                              @"uuid" : @"submit"},
                            @{@"name" : @"维修中",
                              @"uuid" : @"repairing"},
                            @{@"name" : @"已派单",
                              @"uuid" : @"dispatch"},
                            @{@"name" : @"已维修",
                              @"uuid" : @"repaired"},
                            @{@"name" : @"验收不通过",
                              @"uuid" : @"comfirmfailed"},
                            @{@"name" : @"已完成",
                              @"uuid" : @"comfirmed"},];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -签到状态
- (void)signInState:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"全部",
                              @"uuid" : @"全部"},
                            @{@"name" : @"已签到",
                              @"uuid" : @"是"},
                            @{@"name" : @"未签到",
                              @"uuid" : @"否"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -签到统计日期筛选
- (void)signInStatisticalDate {
    FilterDefaultTableViewCell *cell = [self.tableView cellForRowAtIndexPath:self.indexPath];
    FilterModel *itemModel = self.fileterArray[self.indexPath.row];
    [[YXPickerManager shareManager] showDatePickerView:ICR_TINTCOLOR datePickerModel:UIDatePickerModeDate minimumDate:nil maximumDate:[NSDate dateWithString:cell.filterValueLabel.text format:@"yyyy-MM-dd"] defaultDate:[NSString stringWithFormat:@"%@ 00:00:00",cell.filterValueLabel.text] commitBlock:^(NSString *date) {
        NSArray *dateArray = [date componentsSeparatedByString:@" "];
        cell.filterValueLabel.text = dateArray[0];
        itemModel.value = dateArray[0];
    } cancelBlock:^{
        NSLog(@"取消");
    }];
}

#pragma mark -签到类型
- (void)signType:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"进店签到",
                              @"uuid" : @"进店签到"},
                            @{@"name" : @"离店签到",
                              @"uuid" : @"离店签到"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark - 获取本地排序方式
- (void)getLocalSort:(SuccessBlock)successBlock {
    NSArray *titleArray = [self distinguishClassSorts];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    if (!successBlock) {
        for (int i=0; i<searchArray.count; i++) {
            FilterSearchModel *searchModel = searchArray[i];
            for (InspectQuickLookQuery *fieldModel in self.useQueryModel.queryOrders) {
                NSString *sortString = [NSString stringWithFormat:@"%@,%@",fieldModel.field,fieldModel.direction];
                if ([searchModel.uuid rangeOfString:sortString].location != NSNotFound) {
                    searchModel.isSelected = YES;
                    for (int j=0; j<self.fileterArray.count; j++) {
                        FilterModel *model = self.fileterArray[j];
                        if (model.type == FILTER_SORT) {
                            model.value = searchModel.name;
                            model.uuid = searchModel.uuid;
                            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:ZERO];
                            [self.conditionIndexPathArray replaceObjectAtIndex:j withObject:indexPath];
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }
    [self conditionIsSelected:searchArray];
    if (successBlock) {
        successBlock(searchArray);
    }
}

#pragma mark -工作汇报筛选状态
- (void)workReportState:(SuccessBlock)successBlock {
    NSArray *titleArray = @[@{@"name" : @"未读",
                              @"uuid" : @"0"},
                            @{@"name" : @"已读",
                              @"uuid" : @"1"},
                            @{@"name" : @"我提交的",
                              @"uuid" : @"2"}];
    NSMutableArray *searchArray = [NSMutableArray array];
    for (int i=0; i<titleArray.count; i++) {
        FilterSearchModel *searchModel = [[FilterSearchModel alloc] initWithDictionary:titleArray[i] error:nil];
        [searchArray addObject:searchModel];
    }
    [self conditionIsSelected:searchArray];
    successBlock(searchArray);
}

#pragma mark -不同的类调用筛选，排序字段不同（在此区分）
- (NSArray *)distinguishClassSorts {
    NSArray *sorts = nil;
    if ([self.classVc isKindOfClass:[PatrolTaskViewController class]] || [self.classVc isKindOfClass:[InspectionTableViewController class]]) {
        sorts = @[@{@"name":@"任务创建时间降序",@"uuid":@"beginDate,desc"},
                  @{@"name":@"任务创建时间升序",@"uuid":@"beginDate,asc"},
                  @{@"name":@"任务最后修改时间降序",@"uuid":@"lastModifyInfo,desc"},
                  @{@"name":@"任务最后修改时间升序",@"uuid":@"lastModifyInfo,asc"}];
    }
    /*
     else if ([self.classVc isKindOfClass:[InspectionTableViewController class]]) {
     sorts = @[@{@"name":@"任务创建时间降序",@"uuid":@"beginTime,desc"},
     @{@"name":@"任务创建时间升序",@"uuid":@"beginTime,asc"},
     @{@"name":@"按截止日期降序",@"uuid":@"endTime,desc"},
     @{@"name":@"按截止日期升序",@"uuid":@"endTime,asc"}];
     }
     */
    return sorts;
}

#pragma mark -判断此筛选是否已经选择过
- (void)conditionIsSelected:(NSArray *)array {
    if (array.count) {
        return;
    }
    id selected = self.conditionIndexPathArray[self.indexPath.row];
    if ([selected isKindOfClass:[NSIndexPath class]]) {
        NSIndexPath *indexPath = (NSIndexPath *)selected;
        FilterSearchModel *searchModel = [array yx_objectAtIndex:indexPath.row];
        searchModel.isSelected = YES;
    }
}


/**
 筛选条件 UITableViewCell
 
 @param indexPath NSIndexPath
 @return          UITableViewCell
 */
- (UITableViewCell *)conditionItemCell:(NSIndexPath *)indexPath tableView:(UITableView *)tableView
{
    self.tableView = tableView;
    FilterModel *itemModel = [self.fileterArray yx_objectAtIndex:indexPath.row];
    if (itemModel.type == FILTER_TIME) {
        FilterTimeChooseTableViewCell *dateChooseCell = [tableView dequeueReusableCellWithIdentifier:[FilterTimeChooseTableViewCell className] forIndexPath:indexPath];
        [dateChooseCell defaultDate:itemModel.value endDate:itemModel.uuid];
        @weakify(self);
        //开始时间选择后
        [dateChooseCell.beginSubject subscribeNext:^(NSString *beginDate) {
            @strongify(self);
            for (FilterModel *model in self.fileterArray) {
                if (model.type == FILTER_TIME) {
                    model.value = beginDate;
                    break;
                }
            }
        }];
        //截止时间选择后
        [dateChooseCell.endSubject subscribeNext:^(NSString *endDate) {
            @strongify(self);
            for (FilterModel *model in self.fileterArray) {
                if (model.type == FILTER_TIME) {
                    model.uuid = endDate;
                    break;
                }
            }
        }];
        return dateChooseCell;
    }
    FilterDefaultTableViewCell *defaultCell = [tableView dequeueReusableCellWithIdentifier:[FilterDefaultTableViewCell className] forIndexPath:indexPath];
    BOOL boolValue = [ToolsManager empty:itemModel.value];
    defaultCell.filterTitleLabel.text = itemModel.name;
    defaultCell.filterValueLabel.text = boolValue ? @"请选择" : itemModel.value;
    defaultCell.filterValueLabel.textColor = boolValue ? [UIColor lightGrayColor] : [UIColor blackColor];
    return defaultCell;
}


/**
 点击某一个筛选条件（输入）

 @param success   SuccessBlock
 */
- (void)gotoInputDetailVc:(NSIndexPath *)indexPath success:(SuccessBlock)success
{
    self.indexPath = indexPath;
    FilterSearchModel *model = [[FilterSearchModel alloc] init];
    model.isSelected = YES;
    id selected = self.conditionIndexPathArray[self.indexPath.row];
    if ([selected isKindOfClass:[NSString class]]) {
        NSString *string = (NSString *)selected;
        model.name = string;
        model.uuid = string;
    }
    success(model);
}


/**
 点击某一个筛选条件（判断是否需要请求网络或者从本地加载）
 
 @param indexPath         当前筛选项
 @param success           SuccessBlock
 */
- (void)gotoConditionDetailVc:(NSIndexPath *)indexPath success:(SuccessBlock)success
{
    self.indexPath = indexPath;
    FilterModel *itemModel = [self.fileterArray yx_objectAtIndex:indexPath.row];
    switch (itemModel.type) {
        case FILTER_AREA:
        {
            [self queryArea:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_STORE:
        {
            [self queryStore:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_STORE_TYPE:
        {
            [self queryStoreType:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_SUPERVISOR:
        {
            [self querySupervisor:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_STOREUSERS:
        {
            [self queryStoreUsers:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_INSPECTTASK:
        {
            [self queryInspectionTasks:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_CHECKITEM:
        {
            [self queryInspectItems:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_SORT:
        {
            [self getLocalSort:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_INSPECTTASK:
        {
            [self queryPatrolInspectPlanList:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_INSPECTTASK_STATE:
        {
            [self queryPatrolInspectPlanState:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_RECTIFICATIONSTATE:
        {
            [self queryRectificationState:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_RECTIFICATIONTYPE:
        {
            [self queryRectificationType:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_RECTIFICATIONPRIORITY:
        {
            [self queryRectificationPriority:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_REPAIRS_STATE:
        {
            [self reparesState:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_SIGNTYPE:
        {
            [self signType:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_PATROL_WORKREPORT_STATE:
        {
            [self workReportState:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
        case FILTER_SIGNSTATISTICALTIME:
        {
            [self signInStatisticalDate];
        }
            break;
        case FILTER_SIGNINSTATE:
        {
            [self signInState:^(id returnValue) {
                success(returnValue);
            }];
        }
            break;
            
        default:
            break;
    }
}


/**
 更新输入后的筛选条件 (输入)
 
 @param conditionIndexPath      筛选条件NSIndexPath
 @param conditionModel          自定义FilterSearchModel（本地搜索界面使用）
 */
- (void)updateInputConditionModel:(FilterSearchModel *)conditionModel conditionIndexPath:(NSIndexPath *)conditionIndexPath tableView:(UITableView *)tableView
{
    FilterModel *itemModel = self.fileterArray[conditionIndexPath.row];
    //判断确认项是否是选中状态（此判断是为提供可重置某一筛选项）
    BOOL boolValue = conditionModel.isSelected;
    itemModel.value = boolValue ? conditionModel.name : nil;
    itemModel.uuid = boolValue ? conditionModel.uuid : nil;
    [self.conditionIndexPathArray replaceObjectAtIndex:conditionIndexPath.row withObject:boolValue ? conditionModel.name : [NSNull null]];
    [tableView reloadRowAtIndexPath:conditionIndexPath withRowAnimation:UITableViewRowAnimationFade];
}

/**
 更新选择后的筛选条件
 
 @param indexPath               本地筛选NSIndexPath
 @param conditionIndexPath      筛选条件NSIndexPath
 @param conditionModel          自定义FilterSearchModel（本地搜索界面使用）
 */
- (void)updateSomeCondition:(NSIndexPath *)indexPath conditionModel:(FilterSearchModel *)conditionModel conditionIndexPath:(NSIndexPath *)conditionIndexPath tableView:(UITableView *)tableView
{
    FilterModel *itemModel = self.fileterArray[conditionIndexPath.row];
    //判断确认项是否是选中状态（此判断是为提供可重置某一筛选项）
    BOOL boolValue = conditionModel.isSelected;
    itemModel.value = boolValue ? conditionModel.name : nil;
    itemModel.uuid = boolValue ? conditionModel.uuid : nil;
    [self.conditionIndexPathArray replaceObjectAtIndex:conditionIndexPath.row withObject:boolValue ? indexPath : [NSNull null]];
    NSMutableArray *indexPaths = [NSMutableArray array];
    [indexPaths addObject:conditionIndexPath];
    [tableView reloadRowsAtIndexPaths:indexPaths withRowAnimation:UITableViewRowAnimationFade];
}

/**
 自检结果互斥处理

 @param model       FilterModel
 @param isSelected  筛选项详情选中状态
 @return            需要刷新NSIndexPath
 */
- (NSIndexPath *)inspectResultMutexDispose:(FilterModel *)model isSelected:(BOOL)isSelected
{
    if (model.type == FILTER_AREA || model.type == FILTER_STORE || model.type == FILTER_INSPECTTASK) {
        for (int i=0; i<self.fileterArray.count; i++) {
            FilterModel *obj = self.fileterArray[i];
            if ((obj.type == FILTER_STORE && model.type == FILTER_AREA) || (obj.type == FILTER_AREA && model.type == FILTER_STORE)) {
                if (!isSelected) {
                    return nil;
                }
                obj.value = nil;
                obj.uuid = nil;
                [self.conditionIndexPathArray replaceObjectAtIndex:i withObject:[NSNull null]];
                return [NSIndexPath indexPathForRow:i inSection:ZERO];
            }
            if (obj.type == FILTER_CHECKITEM &&  model.type == FILTER_INSPECTTASK) {
                obj.value = nil;
                obj.uuid = nil;
                [self.conditionIndexPathArray replaceObjectAtIndex:i withObject:[NSNull null]];
                return [NSIndexPath indexPathForRow:i inSection:ZERO];
            }
        }
    }
    return nil;
}


/**
 重置筛选条件
 */
- (void)resetFilterCondition
{
    for (int i=0; i<self.fileterArray.count; i++) {
        FilterModel *model = self.fileterArray[i];
        model.value = nil;
        model.uuid = nil;
        [self.conditionIndexPathArray replaceObjectAtIndex:i withObject:[NSNull null]];
    }
    self.useQueryModel = [self.queryModel copy];
    [self queryDate];
    [self getLocalSort:nil];
}


/**
 确认筛选条件
 */
- (void)sureFilterCondition
{
    //VI检查任务、VI检查结果
    if ([self.classVc isKindOfClass:[PatrolTaskViewController class]] || [self.classVc isKindOfClass:[InspectionTableViewController class]]) {
        ParametersModel *queryModel = (ParametersModel *)self.useQueryModel;
        [self.fileterArray enumerateObjectsUsingBlock:^(FilterModel *object, NSUInteger index, BOOL * _Nonnull stop) {
            id selectedIndexPath = self.conditionIndexPathArray[index];
            BOOL boolValue = [selectedIndexPath isKindOfClass:[NSNull class]];
            switch (object.type) {
                case FILTER_TIME:
                {
                    queryModel.beginDate = [NSString stringWithFormat:@"%@ 00:00:00", object.value];
                    queryModel.endDate = [NSString stringWithFormat:@"%@ 23:59:59", object.uuid];
                }
                    break;
                case FILTER_STORE:
                {
                    queryModel.storeUuid = object.uuid;
                }
                    break;
                case FILTER_SUPERVISOR:
                {
                    queryModel.userUuid = object.uuid;
                }
                    break;
                case FILTER_PATROL_INSPECTTASK_STATE:
                {
                    queryModel.planState = object.uuid;
                }
                    break;
                case FILTER_PATROL_INSPECTTASK:
                {
                    queryModel.planUuid = object.uuid;
                }
                    break;
                case FILTER_SORT:
                {
                    NSArray *sortArray = [object.uuid componentsSeparatedByString:@","];
                    InspectQuickLookQuery *conditions = [[InspectQuickLookQuery alloc]init];
                    conditions.field = sortArray[0];
                    conditions.direction = sortArray[1];
                    queryModel.queryOrders = boolValue ? nil : (NSArray<InspectQuickLookQuery> *)@[conditions];
                }
                    break;
                    
                default:
                    break;
            }
        }];
    }
}


@end
