//
//  ToolsManager.h
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>



@interface ToolsManager : NSObject


/**
 拼接完整请求地址
 */
+ (NSString *)completeUrl:(NSString *)url;
/**
 比较时间字符串大小

 @param date1 时间1
 @param date2 时间2
 */
// // -1 a<b  0 a==b  1 a>b
+ (NSInteger)compareTime:(NSString *)date1 date2:(NSString *)date2;

/**
 加密data
 */
+ (NSString *)md5Data:(NSData *)data;

/**
 拼接好签名的明文字符串 Original 后，用已经获取的 SecretKey 对明文串进行 HMAC-SHA1 加密，得到 SignTmp：
 SignTmp = HMAC-SHA1(SecretKey, Original)
 将密文串 SignTmp 放在明文串 Origin 前面，拼接后进行 Base64Encode 算法，得到最终的签名 Sign：
 Sign = Base64 (append(SignTmp, Original))
 注 1：此处使用的是标准的 Base64 编码，不是 urlsafe 的 Base64 编码。
 
 @param data 需要加密的字符串
 @param key 加密字段
 @return 加密后的字符串
 */
+(NSString *)Base_HmacSha1:(NSString *)key data:(NSString *)data;

/**
 获取时间戳(毫秒)
 */
+ (NSString *)getTheTimestamp;

/**
 判断字符串是否为空
 */
+ (BOOL)empty:(NSString *)string;

/**
 汉字转码
 */
+ (NSString *)returnUrlString:(NSString *)ChineseString;

/**
 计算字符串高度
 */
+ (CGFloat)heightWithFontSize:(CGFloat)fontSize width:(CGFloat)width text:(NSString *)string;

/**
 计算字符串宽度
 */
+ (CGFloat)witdhWithFontSize:(CGFloat)fontSize height:(CGFloat)height text:(NSString *)string;

/**
 相机权限判断
 */
+ (BOOL)getPhotoAuthorizationStatus;

/**
 定位权限判断
 */
+ (BOOL)getLocationAuthorizationStatus;

/**
 计算视频时长
 */
+ (NSString *)calculateVideoLength:(NSString *)fileUrl;

/**
 获取当前时间之前或之后的时间
 */
+ (NSString *)getTimeby:(NSInteger)day;

/**
 判断VI检查任务门店任务状态
 
 @param state 状态码
 @return 状态码图片
 */
+ (UIImage *)returnPatrolTaskStateImage:(NSInteger)state;

/**
 判断VI检查任务门店组坐标状态
 
 @param state 状态码
 @param taskState 门店状态
 @return 状态码图片
 */
+ (UIImage *)returnStoreCoordStateImage:(NSString *)state withTaskState:(NSInteger)taskState;

/**
 拼接附件地址（如果没有HTTP前缀）
 */
+ (NSString *)jointUrl:(NSString *)string;

/**
 计算数组中最长的最长的字符串长度
 */
+ (CGFloat)calculateStoreInformation:(NSArray *)storeArray;

/**
 * 比较版本号
 *
 * @param string1 第一个版本号
 * @param string2 第二个版本号
 *
 * @return 如果版本号相等，返回 0,
 *         如果第一个版本号低于第二个，返回 -1，否则返回 1.
 */
+ (NSInteger)compareVersion:(NSString *)string1 string:(NSString *)string2;

/*
 周边加阴影，并且同时圆角
 */
+ (void)addShadowToView:(UIView *)view
            withOpacity:(float)shadowOpacity
           shadowRadius:(CGFloat)shadowRadius
        andCornerRadius:(CGFloat)cornerRadius;
@end










