//
//  RequestManager.h
//  Patrol
//
//  Created by 曹云霄 on 2017/7/28.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ParametersModel.h"
#import "UrlConst.h"

@interface RequestManager : NSObject


/**
 获取服务器时间
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_SystemTimeSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 版本更新
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_UpdateVersionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 用户登录
 
 @param houseCode 企业验证码
 @param userName  用户名
 @param password  密码
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_Login:(NSString *)houseCode userName:(NSString *)userName password:(NSString *)password success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 修改密码
 
 @param newPassword  新密码
 @param oldPassword  旧密码
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_ChangePassword:(NSString *)newPassword oldPassword:(NSString *)oldPassword success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取第三方上传配置
 
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_OptionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取自检匹配门店坐标级别
 
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_StoreCoordinatesLevelSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取待办(首页)
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_TodoSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 自检以及VI检查的进度(首页)
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_PatrolAndInspectionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 督导的营运指数数据(首页)
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_SupervisorServiceSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取当日自检进度（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_InspectionProgress:(NSString *)date success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取当日自检任务、时间轴（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_Inspection:(NSString *)date success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取门店营运数据（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_StoreServiceSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 根据门店坐标获取门店名称、code

 @param longitude 经度
 @param latitude  纬度
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_StoreInformation:(NSString *)longitude latitude:(NSString *)latitude success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 根据自检任务详情
 
 @param questionUuid 自检问题Uuid
 @param answerUuid   自检答案Uuid
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectDetail:(NSString *)questionUuid answerUuid:(NSString *)answerUuid success:(SuccessBlock)success failure:(ErrorBlock)failure;



/**
 上传自检结果
 
 @param taskUuid     自检详情Uuid
 @param parmeter     参数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_UploadInspectResult:(NSString *)taskUuid parmeter:(NSDictionary *)parmeter success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 生成VI临时VI检查
 
 @param store_Uuid 油站ID
 @param success    成功回调
 @param failure    失败回调
 */
+ (void)request_CreatePatrolTempCheck:(NSString *)store_Uuid success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取VI检查任务图片
 
 @param attachmentId 附件Uuid
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolInspectAttachment:(NSString *)attachmentId success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 通过状态获取公告列表
 
 @param type         公告类型
 @param pageNumber   当前页
 @param pageSize     每页个数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_AnnouncementList:(NSInteger)type pageNumber:(NSInteger)pageNumber pageSize:(NSInteger)pageSize success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 通过id获取公告详情
 
 @param uuid         公告id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_AnnouncementDetail:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 通过id标记公告状态
 
 @param uuid         公告id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_ChangeAnnouncementState:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**********************************筛选条件***********************************/
/**
 获取区域信息
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Area_Success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取门店信息
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Store_Success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取门店类型
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_StoreType_Success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 获取督导人员
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Supervisor_Success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取门店人员
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_StoreUsers_Success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取自检任务
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectTask_Success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 获取自检检查项
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectCheckItemByPraiseUuid:(NSString *)praiseUuid success:(SuccessBlock)success failure:(ErrorBlock)failure;
/**********************************筛选条件***********************************/

/**
 获取VI检查任务
 @param queryModel   查询
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlan:(ParametersModel *)queryModel success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取VI检查任务详情
 @param planUuid     VI检查任务id
 @param storeUuid    门店id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlanDetail:(NSString *)planUuid storeUuid:(NSString *)storeUuid success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 获取VI检查任务结果详情
 @param planUuid     VI检查任务id
 @param storeUuid    门店id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlanResult:(NSString *)planUuid storeUuid:(NSString *)storeUuid success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 提交VI检查任务
 @param planUuid     VI检查任务id
 @param type          保存、提交
 @param parameter    参数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_SubmitPatrolPlan:(NSString *)planUuid type:(NSString *)type parameter:(NSDictionary *)parameter success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 VI检查任务开始答题

 @param planUuid            VI检查任务uuid
 @param storeUuid           门店uuid
 @param selectedStoreUuid   选择门店uuid
 @param longtitude          经度
 @param latitute            纬度
 @param success             成功回调
 @param failure             失败回调
 */
+ (void)request_BeginPatrolPlanAnswer:(NSString *)planUuid storeUuid:(NSString *)storeUuid selectedStoreUuid:(NSString *)selectedStoreUuid longtitude:(NSString *)longtitude latitute:(NSString *)latitute success:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 获取周围门店
 
 @param longtitude          经度
 @param latitute            纬度
 @param success             成功回调
 @param failure             失败回调
 */
+ (void)request_QueryRoundStoreLongtitude:(NSString *)longtitude latitute:(NSString *)latitute success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 VI检查结果查看
 
 @param model            ParametersModel
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolInspectResult:(ParametersModel *)model success:(SuccessBlock)success failure:(ErrorBlock)failure;

/**
 VI检查任务列表
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolInspectResultSuccess:(SuccessBlock)success failure:(ErrorBlock)failure;


/**
 VI检查任务附件查询
 
 @param entityUuid       附件id
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolPlanAttachments:(NSString *)entityUuid success:(SuccessBlock)success failure:(ErrorBlock)failure;



















@end
