//
//  YXProgressHUDView.m
//  Framework
//
//  Created by 曹云霄 on 2017/1/22.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

#import "YXProgressHUDView.h"
@implementation YXProgressHUDView

/**
 初始化
 */
MBProgressHUD* BaseHUDView(UIView *view){
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:view animated:YES];
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.margin = HUDContentMargin;
    hud.removeFromSuperViewOnHide = YES;
    hud.labelFont = [UIFont boldSystemFontOfSize:15];
    return hud;
}

/**
 初始化动画
 */
UIImageView* AnimationView(LOADING_TYPE type) {
    UIImageView *displayImageView = [[UIImageView alloc] init];
    if (type == LISTDATA) {
        displayImageView.image = LoadingAnimationImage();
    }else {
        displayImageView.image = WaitingAnimationImage();
    }
    return displayImageView;
}

/**
 动画图片
 */
UIImage *LoadingAnimationImage() {
    NSMutableArray *images = [NSMutableArray array];
    for (int i = 1; i <= 10; i++) {
        UIImage *tImage = [UIImage imageNamed:[NSString stringWithFormat:@"loadingAnimation%d",i]];
        if (tImage) {
            [images addObject:tImage];
        }
    }
    UIImage *animatedImage = [UIImage animatedImageWithImages:images duration:1.0];
    return animatedImage;
}

/**
 动画图片
 */
UIImage *WaitingAnimationImage() {
    NSMutableArray *images = [NSMutableArray array];
    for (int i = 1; i <= 8; i++) {
        UIImage *tImage = [UIImage imageNamed:[NSString stringWithFormat:@"waitingAnimation%d",i]];
        if (tImage) {
            [images addObject:tImage];
        }
    }
    UIImage *animatedImage = [UIImage animatedImageWithImages:images duration:1.0];
    return animatedImage;
}

/**
 文本提示框
 
 @param message message
 */
void ShowMessage(NSString *message) {
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [MBProgressHUD hideHUDForView:DefalutWindow() animated:YES];
            MBProgressHUD *hud = BaseHUDView(DefalutWindow());
            hud.userInteractionEnabled= NO;
            hud.mode = MBProgressHUDModeText;
            hud.labelText = message;
            [hud hide:YES afterDelay:HUDShowTime];
        });
    }else{
        [MBProgressHUD hideHUDForView:DefalutWindow() animated:YES];
        MBProgressHUD *hud = BaseHUDView(DefalutWindow());
        hud.userInteractionEnabled= NO;
        hud.labelText = message;
        hud.mode = MBProgressHUDModeText;
        [hud hide:YES afterDelay:HUDShowTime];
    }
}


/**
 持续加载框
 默认窗口
 */
void ShowDefaultLoadingView(LOADING_TYPE type) {
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(DefalutWindow());
            hud.mode = MBProgressHUDModeCustomView;
            UIImageView *imageView = AnimationView(type);
            hud.customView = imageView;
            hud.margin = 0;
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(DefalutWindow());
        hud.mode = MBProgressHUDModeCustomView;
        UIImageView *imageView = AnimationView(type);
        hud.customView = imageView;
        hud.margin = 0;
    }
}


/**
 持续加载框
 自定义窗口
 */
void ShowLoadingView(UIView *view, LOADING_TYPE type) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(view);
            hud.mode = MBProgressHUDModeCustomView;
            UIImageView *imageView = AnimationView(type);
            hud.customView = imageView;
            hud.margin = 0;
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(view);
        hud.mode = MBProgressHUDModeCustomView;
        UIImageView *imageView = AnimationView(type);
        hud.customView = imageView;
        hud.margin = 0;
    }
}


/**
 加载成功
 默认窗口
 
 @param message   提示信息
 @param completed 完成回调
 */
void ShowDefaultSuccessView(NSString *message,void(^completed)(void)) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(DefalutWindow());
            PerformCustomHUDMethod(hud,message,@"success",completed);
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(DefalutWindow());
        PerformCustomHUDMethod(hud,message,@"success",completed);
    }
}

/**
 加载成功
 自定义窗口
 
 @param view      自定义View
 @param message   提示信息
 @param completed 完成回调
 */
void ShowSuccessView(UIView *view,NSString *message,void(^completed)(void)) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(view);
            PerformCustomHUDMethod(hud,message,@"success",completed);
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(view);
        PerformCustomHUDMethod(hud,message,@"success",completed);
    }
}


/**
 加载失败
 默认窗口
 
 @param message   提示信息
 @param completed 完成回调
 */
void ShowDefaultErrorView(NSString *message,void(^completed)(void)) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(DefalutWindow());
            PerformCustomHUDMethod(hud,message,@"error",completed);
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(DefalutWindow());
        PerformCustomHUDMethod(hud,message,@"error",completed);
    }
}

/**
 加载失败
 自定义窗口
 
 @param view      自定义View
 @param message   提示信息
 @param completed 完成回调
 */
void ShowErrorView(UIView *view,NSString *message,void(^completed)(void)) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            MBProgressHUD *hud = BaseHUDView(view);
            PerformCustomHUDMethod(hud,message,@"error",completed);
        });
    }else{
        MBProgressHUD *hud = BaseHUDView(view);
        PerformCustomHUDMethod(hud,message,@"error",completed);
    }
}


/**
 执行自定义 HUD
 
 @param hud        MBProgressHUD
 @param message    提示信息
 @param imageName 自定义图片名称
 @param completed  完成回调
 */
void PerformCustomHUDMethod(MBProgressHUD *hud,NSString *message,NSString *imageName,void(^completed)(void)) {
    
    hud.labelText = message;
    hud.customView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:imageName]];
    hud.mode = MBProgressHUDModeCustomView;
    [hud hide:YES afterDelay:HUDShowTime];
    if (completed) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(HUDShowTime * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            completed();
        });
    }
}


/**
 进度条
 默认窗口
 
 @param message    提示信息
 @param mode       MBProgressHUDMode
 */
MBProgressHUD* ShowDefaultProgressView(NSString *message,MBProgressHUDMode mode) {
    
    __block MBProgressHUD *hud;
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            hud = BaseHUDView(DefalutWindow());
            hud.labelText = message;
            hud.mode = mode;
        });
    }else{
        hud = BaseHUDView(DefalutWindow());
        hud.labelText = message;
        hud.mode = mode;
    }
    return hud;
}


/**
 进度条
 自定义窗口
 
 @param view       自定义View
 @param message    提示信息
 @param mode       GomoreMBProgressHUDMode
 */
MBProgressHUD* ShowProgressView(UIView *view,NSString *message,MBProgressHUDMode mode) {
    
    __block MBProgressHUD *hud;
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            hud = BaseHUDView(view);
            hud.labelText = message;
            hud.mode = mode;
        });
    }else{
        hud = BaseHUDView(view);
        hud.labelText = message;
        hud.mode = mode;
    }
    return hud;
}

/**
 销毁指定View 所有HUD
 */
void DismissHud(UIView *view) {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            HideMBProgressHUDForView(view);
        });
    }else{
        HideMBProgressHUDForView(view);
    }
}


/**
 销毁默认窗口 所有HUD
 */
void DismissDefaultHud() {
    
    if (![NSThread isMainThread]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            HideMBProgressHUDForView(DefalutWindow());
        });
    }else{
        HideMBProgressHUDForView(DefalutWindow());
    }
}


/**
 执行销毁
 
 @param view UIView
 */
void HideMBProgressHUDForView(UIView *view) {
    
    NSArray *hudArray = AllIndicatorViewForView(view);
    for (MBProgressHUD *hudView in hudArray) {
        [hudView hide:YES];
    }
}


/**
 获取指定view的所有 HUD
 
 @param view UIView
 @return NSArray
 */
NSArray* AllIndicatorViewForView(UIView *view) {
    
    NSMutableArray *hudArray = [NSMutableArray array];
    NSArray *subviews = view.subviews;
    for (UIView *aView in subviews) {
        if ([aView isKindOfClass:[MBProgressHUD class]]) {
            [hudArray addObject:aView];
        }
    }
    return [NSArray arrayWithArray:hudArray];
}

/**
 默认窗口
 
 @return UIWindow
 */
UIView *DefalutWindow(void) {
    return  [[UIApplication sharedApplication].delegate window];
}

/**
 通过加载类型获取文件名
 */
NSString *LoadingType(NSInteger type)
{
    switch (type) {
        case 0:
            return @"loading";
        case 1:
            return @"waiting";
        default:
            break;
    }
    return @"waiting";
}






@end
