//
//  UIView+Helper.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/27.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "UIView+Helper.h"

@implementation UIView (Helper)

+ (NSString *)name
{
    return NSStringFromClass(self);
}


+ (instancetype)initializeXIBView
{
    return [[NSBundle mainBundle] loadNibNamed:[[self class] name] owner:nil options:nil].firstObject;
}

- (void)setCornerRadius:(CGFloat)cornerRadius {
    self.layer.cornerRadius = cornerRadius;
    self.layer.masksToBounds = YES;
}

- (CGFloat)cornerRadius {
    return self.layer.cornerRadius;
}
- (void)setBorderWidth:(CGFloat)borderWidth {
    self.layer.borderWidth = borderWidth;
}

- (CGFloat)borderWidth {
    return self.layer.borderWidth;
}

- (void)setBorderColor:(UIColor *)borderColor {
    self.layer.borderColor = borderColor.CGColor;
}
- (UIColor *)borderColor {
    return [UIColor colorWithCGColor:self.layer.borderColor];
}



@end
