//
//  UIViewController+StoryBoard.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "UIViewController+StoryBoard.h"

@implementation UIViewController (StoryBoard)


+ (instancetype)viewControllerWithStoryBoardType:(STORYBOARD_TYPE_)type {
    NSString *identifier = NSStringFromClass(self);
    UIStoryboard *storyboard;
    switch (type) {
        case STORYBOARD_TYPE_MAIN: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Main" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_HOME: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Home" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_BUSINESS: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Business" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_REPORT: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Report" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_ME: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Mine" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_PATROLINSPECTRESULT: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_PatrolInspectResult" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_MESSAGE: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Message" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_LEARN: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Learn" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_FILTER: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Filter" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_PATROLINSPECT: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_PatrolInspect" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_RECTIFICATION: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Rectification" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_INSPECTRESULT: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_InspectResult" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_STORE: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Store" bundle:nil];
            break;
        }
        case STORYBOARD_TYPE_EQUIPMENTREPAIRS: {
            storyboard = [UIStoryboard storyboardWithName:@"Patrol_Equipment" bundle:nil];
            break;
        }
    }
    return [storyboard instantiateViewControllerWithIdentifier:identifier];
}



@end
