//
//  GXFBottomView.m
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFBottomView.h"

#define LEFT_PADDING (15)
#define TOP_PADDING  (8)
#define BUTTON_WIDTH  (self.width - 3.0 * LEFT_PADDING ) / 2.0
#define BUTTON_HEIGHT (44)

#define LEFT_BUTTON_COLOR HexColor(@"50bd62")
#define RIGHT_BUTTON_COLOR HexColor(@"f69100")
@interface GXFBottomView ()

@end
@implementation GXFBottomView

- (instancetype)initWithFrame:(CGRect)frame LeftBtnTitle:(NSString *)leftTitle rightBtnTitle:(NSString *)rightTitle{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect leftRect = CGRectMake(LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *leftBtn = [IBTCustomButtom creatButtonWithFrame:leftRect target:self sel:@selector(leftBtnClicked) tag:leftTag image:nil title:leftTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:LEFT_BUTTON_COLOR];
    self.f_leftBtn = leftBtn;
    [self addSubview:_f_leftBtn];
    
    CGRect rightRect = CGRectMake(leftBtn.right +  LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *rightBtn = [IBTCustomButtom creatButtonWithFrame:rightRect target:self sel:@selector(rightBtnClicked) tag:rightTag image:nil title:rightTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:RIGHT_BUTTON_COLOR];
    self.f_rightBtn = rightBtn;
    [self addSubview:_f_rightBtn];
    
    return self;

}

- (instancetype)initWithFrame:(CGRect)frame
              leftButtonColor: (UIColor *)leftBtnColor
             rightButtonColor: (UIColor *)rightBtnColor
                 LeftBtnTitle: (NSString *)leftTitle
                rightBtnTitle: (NSString *)rightTitle {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect leftRect = CGRectMake(LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *leftBtn = [IBTCustomButtom creatButtonWithFrame:leftRect target:self sel:@selector(leftBtnClicked) tag:leftTag image:nil title:leftTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:leftBtnColor];
    self.f_leftBtn = leftBtn;
    [self addSubview:_f_leftBtn];
    
    CGRect rightRect = CGRectMake(leftBtn.right +  LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *rightBtn = [IBTCustomButtom creatButtonWithFrame:rightRect target:self sel:@selector(rightBtnClicked) tag:rightTag image:nil title:rightTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:rightBtnColor];
    self.f_rightBtn = rightBtn;
    [self addSubview:_f_rightBtn];
    
    return self;

}
- (void)leftBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomView:leftButtonClicked:)]) {
        [_delegate bottomView:self leftButtonClicked:_f_leftBtn];
    }
}
- (void)rightBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomView:RightButtonClicked:)]) {
        [_delegate bottomView:self RightButtonClicked:_f_rightBtn];
    }

}

- (void)addCloseButton {
    //获取到所有的按钮
    NSMutableArray *arrBtns = [NSMutableArray array];
    for (id obj in self.subviews) {
        if ([obj isKindOfClass:[UIButton class]]) {
            [arrBtns addObject:obj];
        }
    }
    
    //原有按钮数量 + 1（关闭按钮）
    NSInteger counts = arrBtns.count + 1;
    CGFloat width = (ScreenSize.width - (counts + 1) * LEFT_PADDING) / counts;
    
    for (NSInteger i = 0; i < arrBtns.count; i++) {
        UIButton *btn = arrBtns[i];
        btn.frame = CGRectMake(LEFT_PADDING + i * (LEFT_PADDING + width), TOP_PADDING, width, BUTTON_HEIGHT);
    }
    
    CGRect rect = CGRectMake(LEFT_PADDING + arrBtns.count * (LEFT_PADDING + width), TOP_PADDING, width, BUTTON_HEIGHT);
    UIButton *closeBtn = [IBTCustomButtom creatButtonWithFrame:rect target:self sel:@selector(actionClose:) tag:buttonTagCloseTag image:nil title:@"关闭" titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GTO_RED_COLOR];
    [self addSubview:closeBtn];
}

- (void)actionClose:(UIButton *)btn {
    if ([_delegate respondsToSelector:@selector(bottomView:closeClicked:)]) {
        [_delegate bottomView:self closeClicked:btn];
    }
}

- (instancetype)initOneButtonWithFrame:(CGRect)frame buttonColor:(UIColor *)btnColor buttonTitle:(NSString *)title {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect rect = CGRectMake(LEFT_PADDING, TOP_PADDING, frame.size.width - 2 * LEFT_PADDING, BUTTON_HEIGHT);
    UIButton *btn = [IBTCustomButtom creatButtonWithFrame:rect target:self sel:@selector(oneBtnClicked) tag:0 image:nil title:title titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:btnColor];
    self.f_oneBtn = btn;
    [self addSubview:_f_oneBtn];
    return self;
}
- (void)oneBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomView:oneButtonClicked:)]) {
        [_delegate bottomView:self oneButtonClicked:_f_oneBtn];
    }
}
@end
