//
//  ICRUIAppearance.m
//  Cruiser
//
//  Created by Xummer on 3/31/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRUIAppearance.h"

@interface UILabel (Appearance)

@property (assign, nonatomic) UIColor *labelBackgroundColor UI_APPEARANCE_SELECTOR;

@end

@implementation UILabel (Appearance)
@dynamic labelBackgroundColor;

- (void)setLabelBackgroundColor:(UIColor *)labelBackgroundColor {
    [super setBackgroundColor:labelBackgroundColor];
}

@end

@implementation ICRUIAppearance

+ (void)CustomAppearance {
    if (IBT_IOS7_OR_LATER) {
        UIApplication.sharedApplication.delegate.window.tintColor = GTO_RED_COLOR;//ICR_TINTCOLOR;
    }
    
    [[self class] customNavigationbarAppearance];
    [[self class] customTabbarAppearance];
    [[self class] customLableAppearance];
}

+ (void)customNavigationbarAppearance {
    [UINavigationBar appearance].barTintColor = GTO_BLUE_DEEP_COLOR;//ICR_TINTCOLOR;
    [UINavigationBar appearance].tintColor = ICR_NAVIBAR_ITEM_COLOR;
    [[UINavigationBar appearance] setTranslucent:NO];
    //Universal
    NSShadow *shadow = [[NSShadow alloc] init];
    shadow.shadowOffset = CGSizeZero;
    
    [[UINavigationBar appearance] setTitleTextAttributes:
     @{ NSForegroundColorAttributeName: ICR_NAVIBAR_TITLE_COLOR,
        NSFontAttributeName: [UIFont boldSystemFontOfSize:20],
        NSShadowAttributeName: shadow}];

}

+ (void)customTabbarAppearance {
    if (IBT_IOS7_OR_LATER) {
        [[UITabBar appearance] setBarTintColor:XXFBgColor];
       // [[UITabBar appearance] setBarTintColor:ICR_TABBAR_TINT_COLOR];
    }
    else {
        [[UITabBar appearance] setBarTintColor:XXFBgColor];
//        [[UITabBar appearance] setTintColor:ICR_TABBAR_TINT_COLOR];
    }
    
    UIImage *selTab = [[UIImage imageNamed:@"TabbarSelectedBG"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    CGSize tabSize = CGSizeMake(IBT_MAIN_SCREEN_WIDTH/3, 49);
    UIGraphicsBeginImageContext(tabSize);
    [selTab drawInRect:CGRectMake(0, 0, tabSize.width, tabSize.height)];
    UIImage *reSizeImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    [[UITabBar appearance] setSelectionIndicatorImage:reSizeImage];
}

+ (void)customLableAppearance {
    
    if (IBT_IOS7_OR_LATER) {
        
    }
    else {
        [[UILabel appearance] setLabelBackgroundColor:[UIColor clearColor]];
    }
}


@end
