//
//  GTOBusinessViewController.m
//  total
//
//  Created by freecui on 15/9/10.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOBusinessViewController.h"
//#import "GTOFunctionEntity.h"
//#import "GTOBusinessItem.h"
#import "GTOPatrolPlanListViewController.h"
#import "ICRFunctionEntity.h"
#import "ICRFunctionBaseView.h"
#import "GTOPatrolPlanListViewController.h"
#import "GTOPioneeringListViewController.h"
#import "GTORepairListViewController.h"
#import "GTOLicenceListViewController.h"
#import "GTOLicenceCheckListViewController.h"
#import "GTOBusinessSignInViewController.h"
#import "GTOPermission.h"
#import "ICRAnnouncementViewController.h"




#define CATEGORY_COUNT 4;
typedef NS_ENUM (NSUInteger, ICRFunctionID) {
    kFunctionProjectPatrol = 0,
    kFunctionHSEPatrol,
    kFunctionSeeModify,
    kFunctionSeeLicence,
    kFunctionLicenExam,
    kFunctionPioneering,//拓站
    kFunctionAnnouncement,
    kFunctionRegister,
};
@interface GTOBusinessViewController ()<ICRFunctionBaseViewDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic, copy) NSArray *d_functions;
@property(nonatomic,copy) NSArray *generalFunctions;
@property(nonatomic,copy) NSArray *repairFunctions;
@property(nonatomic,copy) NSArray *patrolFunctions;
@property(nonatomic,copy) NSArray *projectFunctions;
@property(nonatomic,copy) NSArray *categoryTitle;

@end

@implementation GTOBusinessViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.tableView.delegate =self;
    self.tableView.dataSource =self;
    self.tableView.tableHeaderView.height=40;
    [self initViews];

//    [self initSubViews];
//    [self permissionInfo];
}
-(void)initViews{
    
    CGFloat rowHeight= ([[UIScreen mainScreen] bounds].size.width)/4;
    CGFloat screenWidth =CGRectGetWidth(self.view.frame);
    CGFloat labelH=20;
    UIColor  *color =[UIColor colorWithRed:52/255.0 green:149/255.0 blue:227/255.0 alpha:1];
    UIColor  *textColor =[UIColor whiteColor];
    CGFloat padding =0;
    int     font = 12;
    
    UIImageView *imgV = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height - 64)];
    imgV.image = [UIImage imageNamed:@"home_bg"];
    imgV.userInteractionEnabled = YES;
    [self.view addSubview:imgV];
 

    UIView * conentView =[[UIView alloc]initWithFrame:CGRectMake(0, 0,screenWidth, CGRectGetHeight(self.view.frame))];
    
    UILabel *generalLabel =[[UILabel alloc]init];
    generalLabel.frame=CGRectMake(0, 0, screenWidth, labelH);
    [generalLabel setText:self.categoryTitle[0]];
    UIEdgeInsets inset =UIEdgeInsetsMake(0, padding, 0, 0);
    [generalLabel  setFont:[UIFont systemFontOfSize:font]];
    [generalLabel drawTextInRect:UIEdgeInsetsInsetRect(generalLabel.frame, inset)];
    generalLabel.backgroundColor =color;
    generalLabel.textColor = textColor;
    
    
    ICRFunctionBaseView *firstCategory = [ICRFunctionBaseView initWithFunctionData:self.generalFunctions];
    firstCategory.frame=CGRectMake(0, labelH, screenWidth, rowHeight);
    firstCategory.m_delegate =self;
    [generalLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [firstCategory setTranslatesAutoresizingMaskIntoConstraints:NO];
    [conentView addSubview:generalLabel];
    [conentView addSubview:firstCategory];
 
    
    UILabel *repariLabel =[[UILabel alloc]init];
    repariLabel.frame=CGRectMake(0, labelH+rowHeight, screenWidth, labelH);
    [repariLabel setText:self.categoryTitle[1]];
    [repariLabel drawTextInRect:UIEdgeInsetsInsetRect(repariLabel.frame, inset)];
    [repariLabel  setFont:[UIFont systemFontOfSize:font]];
    repariLabel.backgroundColor =color;
    repariLabel.textColor = textColor;
    
    ICRFunctionBaseView *thirdCategory = [ICRFunctionBaseView initWithFunctionData:self.repairFunctions];
    thirdCategory.frame=  CGRectMake(0, labelH *2 +rowHeight, screenWidth, rowHeight);
    [repariLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [thirdCategory setTranslatesAutoresizingMaskIntoConstraints:NO];
    thirdCategory.m_delegate =self;
    [conentView addSubview:repariLabel];
    [conentView addSubview:thirdCategory];
    
    
    
    UILabel *poinnerLabel =[[UILabel alloc]init];
    poinnerLabel.frame=CGRectMake(0, 2*(labelH+rowHeight), screenWidth, labelH);
    [poinnerLabel setText:self.categoryTitle[2]];
    [poinnerLabel  setFont:[UIFont systemFontOfSize:font]];
    [poinnerLabel drawTextInRect:UIEdgeInsetsInsetRect(poinnerLabel.frame, inset)];
    poinnerLabel.backgroundColor =color;
    poinnerLabel.textColor = textColor;
    
    
    ICRFunctionBaseView *forthCategory = [ICRFunctionBaseView initWithFunctionData:self.projectFunctions];
    forthCategory.frame= CGRectMake(0, 3*labelH + 2*rowHeight, screenWidth, rowHeight);
    

    forthCategory.m_delegate =self;
    [poinnerLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [forthCategory setTranslatesAutoresizingMaskIntoConstraints:NO];
    [conentView addSubview:poinnerLabel];
    [conentView addSubview:forthCategory];

    
    UILabel *signLabel =[[UILabel alloc]init];
    signLabel.frame=CGRectMake(0, 3*(labelH+rowHeight), screenWidth, labelH);
    [signLabel setText:self.categoryTitle[3]];
    [signLabel drawTextInRect:UIEdgeInsetsInsetRect(signLabel.frame, inset)];
    [signLabel  setFont:[UIFont systemFontOfSize:font]];
    signLabel.backgroundColor =color;
    signLabel.textColor = textColor;
    
    ICRFunctionBaseView *secondCategory = [ICRFunctionBaseView initWithFunctionData:self.patrolFunctions];
    secondCategory.frame=    CGRectMake(0, 4*labelH +3*rowHeight, screenWidth, rowHeight);
    [signLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [secondCategory setTranslatesAutoresizingMaskIntoConstraints:NO];
    secondCategory.m_delegate =self;
    [conentView addSubview:signLabel];
    [conentView addSubview:secondCategory];
    
    

  //

    NSLog(@"-------------%f",firstCategory.frame.size.height);
    self.tableView.tableHeaderView = conentView;
    
    
    
    
    

    
    
//    [tempConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-30-[rightButton(==leftButton)]" options:0 metrics:nil views:NSDictionaryOfVariableBindings(rightButton,leftButton)]];
    
    


}

- (NSArray *)getArrayPermission {
    NSMutableArray *muArr = [@[]mutableCopy];
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
    if (!userU.f_permissions || userU.f_permissions.count < 1) return nil;
//    for(NSString *strNumber in userU.f_permissions){
//        NSUInteger intNumber = [strNumber integerValue];
//        GTOPermission *permission = [GTOPermission DBObject];
//        if (intNumber <= 500103 && intNumber > 500100) {
//            permission.fuctionName = @"工程巡检";
//            permission.functionImageName = @"";
//            permission.functionTag = kFunctionProjectPatrol;
//        }
//        [muArr addObject:permission];
//        break;
//    }
    GTOPermission *permission = [self permissionWithMaxNumber:500103
                                                    minNumber:500100 functionName:@"工程巡检"
                                            functionImageName:@"function_ProjectPatrol_icon"
                                                   funtionTag:kFunctionProjectPatrol];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500203
                                     minNumber:500200 functionName:@"HSE巡检"
                             functionImageName:@"function_HSEPatrol_icon"
                                    funtionTag:kFunctionHSEPatrol];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500303
                                     minNumber:500300 functionName:@"查看报修"
                             functionImageName:@"function_repairSee_icon"
                                    funtionTag:kFunctionSeeModify];
    if (permission) {
        [muArr addObject:permission];
    }
    
    permission = [self permissionWithMaxNumber:500402
                                     minNumber:500400 functionName:@"查看许可证"
                             functionImageName:@"function_licenceSee_icon"
                                    funtionTag:kFunctionSeeLicence];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500404
                                     minNumber:500402 functionName:@"许可证审批"
                             functionImageName:@"function_licenceExam_icon"
                                    funtionTag:kFunctionLicenExam];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500503
                                     minNumber:500500 functionName:@"拓站"
                             functionImageName:@"function_pioneering_icon"
                                    funtionTag:kFunctionPioneering];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500602
                                     minNumber:500600 functionName:@"公告"
                             functionImageName:@"function_announcement_icon"
                                    funtionTag:kFunctionAnnouncement];
    if (permission) {
        [muArr addObject:permission];
    }
    permission = [self permissionWithMaxNumber:500702
                                     minNumber:500700 functionName:@"签到"
                             functionImageName:@"function_register_icon"
                                    funtionTag:kFunctionRegister];
    if (permission) {
        [muArr addObject:permission];
    }
    

    return muArr;
}

- (GTOPermission *)permissionWithMaxNumber: (NSUInteger)maxNumber
                                 minNumber: (NSUInteger)minNumber
                              functionName: (NSString *)functionName
                         functionImageName: (NSString *)functionImgName
                                funtionTag: (NSUInteger)functionTag {
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
    GTOPermission *permission = [GTOPermission DBObject];
    for(NSString *strNumber in userU.f_permissions){
        NSUInteger intNumber = [strNumber integerValue];
        
        if (intNumber <= maxNumber && intNumber > minNumber) {
            permission.fuctionName = functionName;
            permission.functionImageName = functionImgName;
            permission.functionTag = functionTag;
             break;
        }
    }
    if(!permission.fuctionName)
        return  nil;
    return permission;
}
//根据个人查看权和本人查看权的范围确定是否有菜单权限
- (BOOL)permissionWithMaxNumber: (NSUInteger)maxNumber
                        minNumber: (NSUInteger)minNumber{
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
    for(NSString *strNumber in userU.f_permissions){
        NSUInteger intNumber = [strNumber integerValue];
        
        if (intNumber <= maxNumber && intNumber > minNumber) {
            return YES;
        }
    }
        return NO;
}



- (void)initSubViews {
    UIImageView *imgV = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height - 64)];
    imgV.image = [UIImage imageNamed:@"home_bg"];
    imgV.userInteractionEnabled = YES;
    [self.view addSubview:imgV];
    NSMutableArray *arrFunctionEntities = [NSMutableArray array];
    
//    NSArray *functionImageNames = @[ @"AnnouncementIcon",@"TaskManageIcon",@"PatrolPlanIcon",@"MyStoreIcon",@"PatrolPlanIcon",@"MyStoreIcon",@"PatrolPlanIcon",@"MyStoreIcon" ];
//    NSArray *fuctionNames = @[@"工程巡检",@"HSE巡检",@"查看报修",@"查看许可证",
//                              @"许可证审批",@"拓站",@"公告",@"签到"];
//    NSArray *functionTags =  @[@(kFunctionProjectPatrol),
//                               @(kFunctionHSEPatrol),
//                               @(kFunctionSeeModify),
//                               @(kFunctionSeeLicence),
//                               @(kFunctionLicenExam),
//                               @(kFunctionPioneering),
//                               @(kFunctionAnnouncement),
//                               @(kFunctionRegister)];
    NSMutableArray *functionImageNames = [@[]mutableCopy];
    NSMutableArray *functionNames = [@[]mutableCopy];
    NSMutableArray *functionTags = [@[]mutableCopy];
    for(GTOPermission *permission in [self getArrayPermission]) {
        [functionImageNames addObject:permission.functionImageName];
        [functionNames addObject:permission.fuctionName];
        [functionTags addObject:@(permission.functionTag)];
    }
    int i = 0;
    for (NSString *functionName in functionNames) {
        ICRFunctionEntity *funtionEntity = [[ICRFunctionEntity alloc] init];
        funtionEntity.functionName = functionName;
        funtionEntity.iconName = [functionImageNames objectAtIndex:i];
        funtionEntity.functionItemTag = [[functionTags objectAtIndex:i] integerValue];
        [arrFunctionEntities addObject:funtionEntity];
        i ++;
    }
    
    ICRFunctionBaseView *baseView = [ICRFunctionBaseView initWithFunctionData:arrFunctionEntities];
    
    baseView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = CGRectGetWidth(self.view.frame),
        .size.height = CGRectGetHeight(self.view.frame)
    };
    baseView.backgroundColor = [UIColor clearColor];
    baseView.m_delegate = self;
    [imgV addSubview:baseView];
    
}
//#pragma mark  UITableViewDelegate
//-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
//    return CATEGORY_COUNT;
//}
//-(NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section{
//    return self.categoryTitle[section];
//}
//-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
//
//    static NSString *ID =@"ID";
//    UITableViewCell *cell =[self.tableView dequeueReusableCellWithIdentifier:@"ID"];
//    cell =[[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:ID];
//    
//    
//    NSMutableArray *dataArr=[NSMutableArray array];
// 
//        switch (indexPath.section) {
//            case 0:{
//                [dataArr addObjectsFromArray:self.generalFunctions];
//                break;
//            }
//            case 1:
//                 [dataArr addObjectsFromArray:self.patrolFunctions];
//                break;
//            case 2:
//                 [dataArr addObjectsFromArray:self.repairFunctions];
//                break;
//            case 3:
//                 [dataArr addObjectsFromArray:self.projectFunctions];
//                break;
//                
//            default:
//                break;
//        }
//     
//    ICRFunctionBaseView *baseView = [ICRFunctionBaseView initWithFunctionData:dataArr];
//    [baseView setBackgroundColor:[UIColor greenColor]];
////    baseView.frame = (CGRect){
////        .origin.x = 0,
////        .origin.y = 0,
////        .size.width = CGRectGetWidth(self.view.frame),
////        .size.height = IBT_MAIN_SCREEN_HEIGHT/4-30
////    };
//    [cell.contentView addSubview:baseView];
//    NSLog(@"--------%f",baseView.frame.size.height);
//    return cell;
//}
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return 0;

}
//-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
//
//
//    return IBT_MAIN_SCREEN_WIDTH/4+50;
//
//}
//-(NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath{
//
//    return nil;
//
//}

#pragma mark - ICRFunctionBaseViewDelegate
- (void)ICRFunctionBaseView:(ICRFunctionItemControl *)imageView {
    
    
    if(!imageView.hasPermission){
            [IBTLoadingView hideHUDWithText:@"抱歉，您没有权限!!!"];
        return;
    }
  
    switch (imageView.tag) {
        case kFunctionProjectPatrol://工程巡检
        {
            GTOPatrolPlanListViewController *pVC = [[GTOPatrolPlanListViewController alloc]initWithTitle:@"project"];//[[GTOPatrolPlanListViewController alloc]init];//[[ICRPatrolPlanViewController alloc] initWithStore:nil isHomeShow:YES];
            [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionHSEPatrol://HSE巡检
        {
            GTOPatrolPlanListViewController *pVC =  [[GTOPatrolPlanListViewController alloc]initWithTitle:@"HSE"];//[[GTOPatrolPlanListViewController alloc]init];//[[ICRPatrolPlanViewController alloc] initWithStore:nil isHomeShow:YES];
            [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionSeeModify://查看保修
        {
            GTORepairListViewController *pVC = [[GTORepairListViewController alloc]init];
            [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionSeeLicence://查看许可证
        {
            GTOLicenceListViewController *pioneeringVC = [[GTOLicenceListViewController alloc]init];
            [self PushViewController:pioneeringVC animated:YES];
        }
            break;
        case kFunctionLicenExam://许可证审批
        {
            GTOLicenceCheckListViewController *pVC = [[GTOLicenceCheckListViewController alloc]init];
         [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionPioneering://拓站
        {
            GTOPioneeringListViewController *pioneeringVC = [[GTOPioneeringListViewController alloc]init];
            [self PushViewController:pioneeringVC animated:YES];
        }
            break;
        case kFunctionAnnouncement://公告
        {
                ICRAnnouncementViewController *aVC = [[ICRAnnouncementViewController alloc] init];
                [self PushViewController:aVC animated:YES];
        }
            break;
        case kFunctionRegister://签到
        {
            GTOBusinessSignInViewController *pVC = [[GTOBusinessSignInViewController alloc]init];
            [self PushViewController:pVC animated:YES];
        }
            break;
        default:
            break;
    }

}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
#pragma mark  load lazy
-(NSArray *)generalFunctions{
    //通用模块的数据源
    if(_generalFunctions==nil){
        
        NSMutableArray *generalArr = [NSMutableArray array];
        BOOL noticePermission = [self permissionWithMaxNumber:500602 minNumber:500600];
        NSString *noticeIcon =[NSString string];
        if(noticePermission){
            noticeIcon = @"function_announcement_icon";
        } else{
            noticeIcon =@"function_announcement_icon_no_premission";
        
        }
        NSDictionary *noticeDict =@{@"functionImageName":noticeIcon,
                                    @"fuctionName":@"公告",
                                    @"functionTag":@(kFunctionAnnouncement),
                                    @"hasPermission":@(noticePermission) };
       [generalArr addObject:[[GTOPermission alloc] initWithDict:noticeDict]];
        
        
        //签到菜单
        BOOL signPermission = [self permissionWithMaxNumber:500702 minNumber:500700];
        NSString *signIcon =[NSString string];
        if(noticePermission){
            signIcon = @"function_register_icon";
        } else{
            signIcon =@"function_register_icon_no_premission";
            
        }
        NSDictionary *signDict =@{@"functionImageName":signIcon,
                                    @"fuctionName":@"签到",
                                    @"functionTag":@(kFunctionRegister),
                                    @"hasPermission":@(signPermission) };
        [generalArr addObject:[[GTOPermission alloc] initWithDict:signDict]];
        _generalFunctions = generalArr;
    
    }
    return _generalFunctions;
}
-(NSArray *)repairFunctions{
    //报修模块数据源
    if(_repairFunctions==nil){
        
        NSMutableArray *repariArr = [NSMutableArray array];
        //公告菜单
        BOOL repariPermission = [self permissionWithMaxNumber:500303 minNumber:500300];
    
        NSString *repairIcon =repariPermission==YES?@"function_repairSee_icon":@"function_repairSee_icon_no_premission";
        NSDictionary *repairDict =@{@"functionImageName":repairIcon,
                                    @"fuctionName":@"查看报修",
                                    @"functionTag":@(kFunctionSeeModify),
                                    @"hasPermission":@(repariPermission) };
        [repariArr addObject:[[GTOPermission alloc] initWithDict:repairDict]];
        
        
        //许可证查看
        BOOL licencePermission = [self permissionWithMaxNumber:500402 minNumber:500400];
        NSString *licenceIcon =licencePermission==YES?@"function_licenceSee_icon":@"function_licenceSee_icon_no_premission";
        NSDictionary *licenceDict =@{@"functionImageName":licenceIcon,
                                  @"fuctionName":@"查看许可证",
                                  @"functionTag":@(kFunctionSeeLicence),
                                  @"hasPermission":@(licencePermission) };
        [repariArr addObject:[[GTOPermission alloc] initWithDict:licenceDict]];
       
        
        
        
        //许可证审批
        BOOL  judgePermission =[self permissionWithMaxNumber:500404 minNumber:500402];
        NSString *judgeIcon =judgePermission==YES?@"function_licenceSee_icon":@"function_licenceSee_icon_no_premission";
        NSDictionary *judgeDict =@{@"functionImageName":judgeIcon,
                                   @"fuctionName":@"许可证审批",
                                   @"functionTag":@(kFunctionLicenExam),
                                   @"hasPermission":@(judgePermission) };
        [repariArr addObject:[[GTOPermission alloc] initWithDict:judgeDict]];
        //工程巡检
        BOOL patrolPermission = [self permissionWithMaxNumber:500103 minNumber:500100];
        NSString *patrolIcon =patrolPermission==YES?@"function_ProjectPatrol_icon":@"function_ProjectPatrol_icon_no_premission";
        NSDictionary *noticeDict =@{@"functionImageName":patrolIcon,
                                    @"fuctionName":@"工程巡检",
                                    @"functionTag":@(kFunctionProjectPatrol),
                                    @"hasPermission":@(patrolPermission) };
        [repariArr addObject:[[GTOPermission alloc] initWithDict:noticeDict]];
         _repairFunctions = repariArr;
        
    }
    return _repairFunctions;
}
-(NSArray *)patrolFunctions{

    if(_patrolFunctions==nil){
        NSMutableArray *patrolArr = [NSMutableArray array];
      
        
        
        //HSE巡检
        BOOL hsePermission = [self permissionWithMaxNumber:500203 minNumber:500200];
        NSString *hseIcon =hsePermission==YES?@"function_HSEPatrol_icon":@"function_HSEPatrol_icon_no_premission";
        NSDictionary *hseDict =@{@"functionImageName":hseIcon,
                                  @"fuctionName":@"HSE巡检",
                                  @"functionTag":@(kFunctionHSEPatrol),
                                  @"hasPermission":@(hsePermission) };
        [patrolArr addObject:[[GTOPermission alloc] initWithDict:hseDict]];
        _patrolFunctions = patrolArr;
    }
    
    return _patrolFunctions;
}

-(NSArray *)projectFunctions{
    
    if(_projectFunctions==nil){
        NSMutableArray *projectArr = [NSMutableArray array];
        //拓站z
        BOOL projectPermission = [self permissionWithMaxNumber:500503 minNumber:500500];
        NSString *projectIcon =projectPermission==YES?@"function_pioneering_icon":@"function_pioneering_icon_no_icon";
        NSDictionary *dict =@{@"functionImageName":projectIcon,
                                    @"fuctionName":@"拓站",
                                    @"functionTag":@(kFunctionPioneering),
                                    @"hasPermission":@(projectPermission) };
        [projectArr addObject:[[GTOPermission alloc] initWithDict:dict]];
        //定油
        BOOL bookingPermission = [self permissionWithMaxNumber:500503 minNumber:500500];
        NSString *booking =projectPermission==YES?@"function_pioneering_icon":@"function_pioneering_icon_no_icon";
        NSDictionary *bookingdict =@{@"functionImageName":booking,
                              @"fuctionName":@"定油",
                              @"functionTag":@(kFunctionPioneering),
                              @"hasPermission":@(bookingPermission) };
        [projectArr addObject:[[GTOPermission alloc] initWithDict:bookingdict]];
        _projectFunctions = projectArr;
    }
    return _projectFunctions;
}

-(NSArray *)categoryTitle{
    if(_categoryTitle==nil){
            NSArray *arr =@[@"    通用",@"    工程",@"    开发",@"    HSE"];
        _categoryTitle = arr;
    }
    return _categoryTitle;
}



@end
