//
//  ICRQStoreStudyViewController.m
//  Cruiser
//  库存调查类
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQStoreStudyViewController.h"
#import "IBTTableViewInfo.h"
#import "ICRQuestionManager.h"

@interface ICRQStoreStudyViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;

@end

@implementation ICRQStoreStudyViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(setAnswerDetail) name:KNOTIFICATION_QUESTION_KEYBOARD_HIDE object:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initScrollViewWithRect:(CGRect)rect {
    
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:rect style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    tableV.bHandleKeyboard = YES;
    tableV.backgroundColor = [UIColor clearColor];
    self.m_contentScrollView = tableV;
    IBTTableViewSectionInfo *secInfo;
    IBTTableViewCellInfo *cellInfo;
    
    CGFloat fCellHeight = IBT_DEFAULT_CELL_HEIGHT;
    
    secInfo = [IBTTableViewSectionInfo sectionInfoDefaut];
    // Change Password
//    cellInfo =
//    [IBTTableViewCellInfo normalCellForSel:nil target:nil
//                                     title:@"商品"
//                                rightValue: @"当前库存"
//                             accessoryType:UITableViewCellAccessoryNone];
//    cellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
//    cellInfo.fCellHeight = fCellHeight;
    

    [secInfo addCell:cellInfo];
    
//    NSSortDescriptor *sort = [NSSortDescriptor sortDescriptorWithKey:@"lineNo" ascending:YES];
//    NSArray* sortedArray=[self.m_question.details sortedArrayUsingDescriptors:@[sort]];
    
    NSSortDescriptor *sort = [NSSortDescriptor sortDescriptorWithKey:@"index" ascending:YES];
    NSArray *arrAnswers = [self.m_answer.details sortedArrayUsingDescriptors:@[sort]];
    
    NSUInteger i = 0;
    for (NSDictionary *dictItem in self.m_arrOptions) {
        
        NSDictionary *dictAnsw = [arrAnswers safeObjectAtIndex:i];
        id answResult = dictAnsw[ @"numberValue" ];//比如说库存数
        NSString *text = answResult ? [NSString stringWithFormat:@"%@", answResult] : nil;
        
        cellInfo = [IBTTableViewCellInfo editorCellForSel:nil
                                                   target:nil
                                                    title:dictItem[ @"productName" ]//[ @"content" ]
                                                   margin:0
                                                      tip:@"请输入"
                                              autoCorrect:NO
                                                    focus:NO
                                                     text:text];
        [cellInfo addUserInfoValue:@( NSTextAlignmentRight )
                            forKey:CInfoEditorAlignKey];
        [cellInfo addUserInfoValue:@( UIKeyboardTypeNumberPad )
                            forKey:CInfoEditorKeyboardTypeKey];
        [secInfo addCell:cellInfo];
        i ++;
    }
    
    [self.m_tableViewInfo addSection:secInfo];
    if (self.d_notEdit) {
        tableV.userInteractionEnabled = NO;
    }
}

#pragma  notification
- (void)setAnswerDetail {
    IBTTableViewSectionInfo *secInfo = [self.m_tableViewInfo getSectionAt:0];
    
    NSMutableArray *mArrAnswers = [NSMutableArray array];
    
    BOOL bIsAllAnswered = YES;
    for (NSUInteger i = 1; i < [secInfo getCellCount]; i ++) {
        IBTTableViewCellInfo *cellInfo = [secInfo getCellAt:i];
        NSString *nsText = [cellInfo getUserInfoValueForKey:CInfoEditorTextKey];
        if (nsText.length > 0) {
            
            ICRAnswerDetail *dE = [ICRAnswerDetail DBObject];
            dE.uuid = [[ICRUserUtil sharedInstance] mobileID];
            dE.index = i+1;
            dE.numberValue = [nsText integerValue];
            [mArrAnswers addObject:[dE dictForCommit]];
        }
        else {
            bIsAllAnswered = NO;
            break;
        }
    }
    
    
    
    self.m_answer.details = mArrAnswers;

}
#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    IBTTableViewSectionInfo *secInfo = [self.m_tableViewInfo getSectionAt:0];
    
    NSMutableArray *mArrAnswers = [NSMutableArray array];
    
    BOOL bIsAllAnswered = YES;
    for (NSUInteger i = 1; i < [secInfo getCellCount]; i ++) {
        IBTTableViewCellInfo *cellInfo = [secInfo getCellAt:i];
        NSString *nsText = [cellInfo getUserInfoValueForKey:CInfoEditorTextKey];
        if (nsText.length > 0) {
            
            ICRAnswerDetail *dE = [ICRAnswerDetail DBObject];
            dE.uuid = [[ICRUserUtil sharedInstance] mobileID];
            dE.index = i+1;
            dE.numberValue = [nsText integerValue];
            [mArrAnswers addObject:[dE dictForCommit]];
        }
        else {
            bIsAllAnswered = NO;
            break;
        }
    }
    

    
    self.m_answer.details = mArrAnswers;
    
    self.m_answer.bIsAnswered = YES;
    self.m_answer.remark = self.m_helperView.m_inputTxtF.text;
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
//        [self openResultView];
    }
    [self.m_answer saveToDBWithHandleData:NULL complete:NULL fail:NULL];
}

@end
