
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  拓站任务列表的cell的内容
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPioneeringListCellContent.h"
#import "GTOPioneering.h"
#import "GTOInspector.h"

@interface GTOPioneeringListCellContent ()
@property (strong, nonatomic) IBTUILabel *m_planNameLabel;

@property (strong, nonatomic) IBTUILabel *m_operNameLabel;
@property (strong, nonatomic) IBTUILabel *m_planBeginDateLabel;//开始时间
//@property (strong, nonatomic) IBTUILabel *m_planLastModifyDateLabel;//开始时间
@property (strong, nonatomic) IBTUILabel *m_stateLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_stateValueLabel;//完成状态
//@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
//@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
//@property (strong, nonatomic) IBTUIView *m_processBarView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOPioneeringListCellContent


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_planNameLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_operNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_planBeginDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
//    self.m_planLastModifyDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
  //  self.m_processValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
   // self.m_processFractionLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    
    [self addSubview:_m_planNameLabel];
    [self addSubview:_m_operNameLabel];
    [self addSubview:_m_planBeginDateLabel];
    //[self addSubview:_m_planLastModifyDateLabel];
    [self addSubview:_m_stateLabel];
    [self addSubview:_m_stateValueLabel];
   // [self addSubview:_m_processValueLabel];
   // [self addSubview:_m_processFractionLabel];
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_planNameLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH + 10,
    };
    _m_operNameLabel.frame = (CGRect){
        .origin.x = _m_planNameLabel.x,
        .origin.y = _m_planNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };

    _m_stateLabel.frame = (CGRect){
        .origin.x = _m_planBeginDateLabel.x,
        .origin.y = _m_operNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 90,
        .size.height = lblH,
    }; [_m_stateLabel sizeToFit];
    _m_stateValueLabel.frame = (CGRect){
        .origin.x =_m_stateLabel.right,
        .origin.y = _m_operNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING - _m_stateLabel.width,
        .size.height = lblH,
    }; [_m_stateLabel sizeToFit];
    _m_planBeginDateLabel.frame = (CGRect){
        .origin.x = _m_planNameLabel.x,
        .origin.y = _m_stateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
//    _m_planLastModifyDateLabel.frame = (CGRect){
//        .origin.x = _m_planNameLabel.x,
//        .origin.y = _m_planBeginDateLabel.bottom + GTO_VERTICAL_PADDING,
//        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
//        .size.height = lblH,
//    };
//    _m_processValueLabel.frame = (CGRect){
//        .origin.x = _m_stateLabel.right,
//        .origin.y = _m_stateLabel.y,
//        .size.width = 120,
//        .size.height = lblH,
//    };
//    _m_processFractionLabel.frame = (CGRect){
//        .origin.x = SCREEN_SIZE.width - 100 - GTO_LEFT_PADDING,
//        .origin.y = _m_stateLabel.y,
//        .size.width = 100,
//        .size.height = lblH,
//    };
//    
//    CGRect rect = (CGRect){
//        .origin.x = _m_stateLabel.x,
//        .origin.y = _m_stateLabel.bottom + GTO_VERTICAL_PADDING ,
//        .size.width = SCREEN_SIZE.width - _m_stateLabel.x - GTO_LEFT_PADDING,
//        .size.height = 20,
//    };
//    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
//    [self addSubview:_m_processBarView];
}

@end

@implementation GTOPioneeringListCellContent (configure)
- (void)updateWithPioneering: (GTOPioneering *)pioneering
{
   self.m_planNameLabel.text = [NSString stringWithFormat:@"标题：%@ ",pioneering.title];
    self.m_operNameLabel.text = [NSString stringWithFormat:@"拓站人员：%@ ",pioneering.pioneer_name];
    NSString *beginStr = [GTOCommonTools dateSubstringDeleteZeroWithDateString:pioneering.beginDate]; //lastModify_time];//
    self.m_planBeginDateLabel.text = [NSString stringWithFormat:@"开始时间：%@",beginStr ];
//    self.m_planLastModifyDateLabel.text = [NSString stringWithFormat:@"最后修改时间：%@",pioneering.lastModify_time ];
    self.m_stateLabel.text = [NSString stringWithFormat:@"拓站状态: %@", [GTOCommonTools pioneeringStateWithString:pioneering.state]];
    self.m_stateLabel.text = @"拓站状态:  ";
    self.m_stateValueLabel.text = [GTOCommonTools pioneeringStateChineseWithEnglish:pioneering.state];
    self.m_stateValueLabel.textColor = [GTOCommonTools textColorWithState:pioneering.state];
    
//    NSUInteger totalNumber = pioneering.arrDisplayResults.count;
//    NSUInteger finishNumber = 0;
//    for(NSDictionary *dictDisplayR in pioneering.arrDisplayResults){
//        GTODisplayResult *displayR = [GTODisplayResult DBObject];
//        [displayR praseFromJsonDict:dictDisplayR];
//        if (displayR.arrAnswers.count == displayR.arrQuestions.count) {
//            finishNumber ++;
//        }
//    }
//    self.d_processLength = 1.0 * finishNumber / totalNumber;
//    int percent = self.d_processLength *100;
//    self.m_processValueLabel.text = [NSString stringWithFormat:@"%@ %d%%",[GTOCommonTools pioneeringStateWithString:pioneering.state],percent];
    
    [self layoutSubviews];


}
@end
