//
//  SeeDistributionViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/21.
//  Copyright © 2016年 free. All rights reserved.
//

#import "SeeDistributionViewController.h"
#import "DistributionTableViewCell.h"
#import "DistributionHeaderView.h"

@interface SeeDistributionViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 *  数据源
 */
@property (nonatomic,strong) PickingBill *orderBill;

@end

@implementation SeeDistributionViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createBackBtn];
    [self uiConfigAction];
    [self getDistributionOrderDatas];
}

- (void)createBackBtn{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"back"] forState:UIControlStateNormal];
    btn.frame  = CGRectMake(0, 0, 12, 20);
    [btn addTarget:self action:@selector(backClicked) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *back = [[UIBarButtonItem alloc]initWithCustomView:btn];
    self.navigationItem.leftBarButtonItem = back;
}

- (void)backClicked {
    [self PopViewControllerAnimated:YES];
}

#pragma mark -获取配油单详情信息
- (void)getDistributionOrderDatas
{
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [HttpRequestManager requestNetworkwithURL:[NSString stringWithFormat:@"%@/pickingBill/get/%@",HTTP_REST_API_BASE_URL,self.orderDict[@"uuid"]] withRequestType:ONE withParameter:nil withSuccess:^(id returnValue) {
        
        [IBTLoadingView hideHUDWithText:nil];
        if ([returnValue[@"success"] isEqualToNumber:@1]) {
            self.orderBill = [[PickingBill alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [self setupHeaderView];
            [self.distributionTableView reloadData];
        }
        
    } withFailed:^(NSError *failed) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:failed.localizedDescription];
    }];
}



#pragma mark -UI
- (void)uiConfigAction
{
    self.distributionTableView.dataSource = self;
    self.distributionTableView.delegate = self;
    self.distributionTableView.tableFooterView = [UIView new];
}

#pragma mark -Headerview
- (void)setupHeaderView
{
    //header
    DistributionHeaderView *headerView = [DistributionHeaderView initialize];
    headerView.frame = CGRectMake(0, 0, ScreenSize.width, 220);
    UIView *loadHeaderView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 220)];
    [loadHeaderView addSubview:headerView];
    headerView.model = self.orderBill;
    self.distributionTableView.tableHeaderView = loadHeaderView;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    DistributionTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"DistributionTableViewCell" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = self.orderBill;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}









@end
