//
//  SeeOrderViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/21.
//  Copyright © 2016年 free. All rights reserved.
//

#import "SeeOrderViewController.h"
#import "IBTCustomButtom.h"
#import "SortMaskView.h"
#import "GTOLicenceBoltView.h"
#import "OilOrderTableViewCell.h"
#import "SeeDistributionViewController.h"
#import "NewOrderViewController.h"
#import "GTORepairBoltView.h"
#import "NewObtainViewController.h"
#import "SeeRequestViewController.h"
#import "SeeObtainViewController.h"
#import "OrderDetailsViewController.h"
#import "NewRequestViewController.h"
#import "SubTableViewCell.h"


@interface SeeOrderViewController ()<UITableViewDelegate,UITableViewDataSource,SortMaskViewDelegate,GTORepairBoltViewDelegate,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>
{
    SortMaskView *_sortView;
    GTORepairBoltView  *_boltView;
    UIButton *currentBtn;
}


/**
 *  确定
 */
@property (nonatomic,strong) UIBarButtonItem *sureBtn;

/**
 *  排序
 */
@property (nonatomic,strong) UIButton *sortBtn;

/**
 *  筛选
 */
@property (nonatomic,strong) UIButton *boltBtn;

/**
 *  遮罩
 */
@property (nonatomic,strong) UIView *maskView;

/**
 *  数据源数组
 */
@property (nonatomic,strong) NSMutableArray *orderResultArray;

/**
 * 返回对象
 */
@property (nonatomic,strong) QueryResult *orderResult;

/**
 *  请求模型
 */
@property (nonatomic,strong) QueryDefinition2 *queryOrder;

/**
 *  当前页数
 */
@property (nonatomic,assign) NSInteger indexPage;

@property (nonatomic,strong) SortMaskView *sortView;
@property (nonatomic,strong) GTORepairBoltView  *boltView;
@property (nonatomic,strong)NSString *billLike;
@property (nonatomic,strong)NSString *titleLike;
@property (nonatomic,strong)NSString *orderDirection;//asc(升序)，desc(降序)
@property (nonatomic,strong)NSString *state;


@end


#define TopMargin 44
#define TableHeight 150
#define LeftMargin 20
#define BtnWidth 60
#define BtnHeight 24
#define BtnSize 16



#define DINGYOUDAN @"查看订油单"
#define JIANCHANGDAN @"查看建仓申请"
#define SHOUYOUDAN @"查看收油单"
#define PEIYOUDAN @"查看配油单"

typedef enum : NSUInteger {
    SortTag = 3000,
    BoltTag
    
} BtnTag;

@implementation SeeOrderViewController


- (QueryDefinition2 *)queryOrder
{
    if (!_queryOrder) {
        
        ICRUserUtil *user = [ICRUserUtil sharedInstance];
        _queryOrder = [[QueryDefinition2 alloc]init];
        _queryOrder.pageSize = 10;
        _queryOrder.pageNumber = self.indexPage;
        //排序
        QueryOrder *queryOrder = [[QueryOrder alloc]init];
        queryOrder.field = @"createTime";
        queryOrder.direction = @"desc";
        //状态
        QueryCondition *Condition = [[QueryCondition alloc]init];
        Condition.parameters = nil;
        Condition.operation = nil;
        //单号
        QueryCondition *Conditiontwo = [[QueryCondition alloc]init];
        Conditiontwo.parameters = nil;
        Conditiontwo.operation = nil;
        //标题
        QueryCondition *Conditionthree = [[QueryCondition alloc]init];
        Conditionthree.parameters = nil;
        Conditionthree.operation = nil;
        //组织条件
        QueryCondition *userCondition = [[QueryCondition alloc]init];
        if ([self.title isEqualToString:JIANCHANGDAN]) {
            userCondition.parameters = @[user.orguuid];
            userCondition.operation = @"orguuidequals";
        }else {
            
            NSMutableArray *storeuuidArray = [NSMutableArray array];
            for (NSDictionary *dict in user.storeArray) {//登陆用户的油站列表
                [storeuuidArray addObject:dict[@"uuid"]];
            }
            userCondition.parameters = storeuuidArray;
            userCondition.operation = @"storeUuidIn";
        }
        //职位
        QueryCondition *position = [[QueryCondition alloc]init];
        position.parameters = [self.title isEqualToString:JIANCHANGDAN]?nil:@[user.f_user_uuid];
        position.operation = [self.title isEqualToString:JIANCHANGDAN]?nil:([user.position isKindOfClass:[NSNull class]]?nil:@"isStorer");
        if (![user.position isKindOfClass:[NSNull class]] || [self.title isEqualToString:JIANCHANGDAN]) {//user.position有值时忽略组织条件
            _queryOrder.conditions = (NSArray<QueryCondition> *)@[Condition,Conditiontwo,Conditionthree,position,userCondition];
        }else {
            _queryOrder.conditions = (NSArray<QueryCondition> *)@[Condition,Conditiontwo,Conditionthree,position];
        }
        _queryOrder.orders = (NSArray<QueryOrder> *)@[queryOrder];
    }
    return _queryOrder;
}


- (NSMutableArray *)orderResultArray
{
    if (!_orderResultArray) {
        _orderResultArray = [NSMutableArray array];
    }
    return _orderResultArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createBackBtn];
    [self setupUiConfigAction];
    [self setupMJRefresh];
}

- (void)createBackBtn{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"back"] forState:UIControlStateNormal];
    btn.frame  = CGRectMake(0, 0, 12, 20);
    [btn addTarget:self action:@selector(backClicked) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *back = [[UIBarButtonItem alloc]initWithCustomView:btn];
    self.navigationItem.leftBarButtonItem = back;
}

- (void)backClicked {
    [self PopViewControllerAnimated:YES];
}

#pragma mark 获取订单列表数据
- (void)getOilOrderDatas:(BOOL)isRemoveall
{
    __weak typeof(self) weakSelf = self;
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    NSLog(@"%@",[self.queryOrder toDictionary]);
    [HttpRequestManager requestNetworkwithURL:[self returnURLString] withRequestType:ZERO withParameter:[self.queryOrder toDictionary] withSuccess:^(id returnValue) {
        
        weakSelf.oilOrderTableview.emptyDataSetSource = weakSelf;
        weakSelf.oilOrderTableview.emptyDataSetDelegate = weakSelf;
        [GTOCommonTools cancelMJRefreshState:weakSelf.oilOrderTableview];
        [IBTLoadingView hideHUDWithText:nil];
        if ([returnValue[@"success"] isEqualToNumber:@1]) {
            weakSelf.orderResult = [[QueryResult alloc]initWithDictionary:returnValue[@"data"] error:nil];
            isRemoveall?[weakSelf.orderResultArray removeAllObjects]:nil;
            for (NSDictionary *dict in weakSelf.orderResult.records) {
                NSMutableDictionary *mutbleDict = [NSMutableDictionary dictionaryWithDictionary:dict];
                [weakSelf.orderResultArray addObject:mutbleDict];
            }
        } else {
            isRemoveall?[weakSelf.orderResultArray removeAllObjects]:nil;
        }
        [weakSelf.oilOrderTableview reloadData];
    } withFailed:^(NSError *failed) {
        [GTOCommonTools cancelMJRefreshState:self.oilOrderTableview];
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:failed.localizedDescription];
    }];
}

#pragma mark  拼接订单地址
- (NSString *)returnURLString
{
    if ([self.title isEqualToString:DINGYOUDAN]) {
        return  [NSString stringWithFormat:@"%@/orderBill/query?fetchParts=%@",HTTP_REST_API_BASE_URL,[ICRUserUtil sharedInstance].f_user_uuid];
    } else if ([self.title isEqualToString:PEIYOUDAN]) {
        return [NSString stringWithFormat:@"%@/pickingBill/query?fetchParts=%@",HTTP_REST_API_BASE_URL,[ICRUserUtil sharedInstance].f_user_uuid];
    } else if ([self.title isEqualToString:SHOUYOUDAN]) {
        return [NSString stringWithFormat:@"%@/receiveBill/query?fetchParts=%@",HTTP_REST_API_BASE_URL,[ICRUserUtil sharedInstance].f_user_uuid];
    } else if ([self.title isEqualToString:JIANCHANGDAN]) {
        return [NSString stringWithFormat:@"%@/depotRequest/query",HTTP_REST_API_BASE_URL];
    }
    return nil;
}

#pragma mark -添加MJRefresh刷新
- (void)setupMJRefresh
{
    __weak typeof(self) weakSelf = self;
    MJRefreshNormalHeader *header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        
        [weakSelf.oilOrderTableview.mj_footer resetNoMoreData];
        weakSelf.indexPage = ZERO;
        weakSelf.queryOrder.pageNumber = weakSelf.indexPage;
        [weakSelf getOilOrderDatas:YES];
    }];
    header.lastUpdatedTimeLabel.hidden = YES;
    self.oilOrderTableview.mj_header = header;
    [self.oilOrderTableview.mj_header beginRefreshing];
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if ( ++weakSelf.indexPage >= weakSelf.orderResult.paging.pageCount) {
            [weakSelf.oilOrderTableview.mj_footer endRefreshingWithNoMoreData];return;
        }
        weakSelf.queryOrder.pageNumber = weakSelf.indexPage;
        [weakSelf getOilOrderDatas:NO];
    }];
    footer.automaticallyHidden = YES;
    self.oilOrderTableview.mj_footer = footer;
}


#pragma mark -UI
- (void)setupUiConfigAction
{
    self.view.backgroundColor = RGBA(246, 246, 246, 1);
    self.oilOrderTableview.delegate = self;
    self.oilOrderTableview.dataSource = self;
    self.oilOrderTableview.tableFooterView = [UIView new];
    self.sureBtn = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = self.sureBtn;
    self.sortBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:SortTag image:@"black_arrow_down_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    self.sortBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_sortBtn];
    self.boltBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width-BtnWidth - LeftMargin,10,BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:BoltTag image:@"black_filter_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    self.boltBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_boltBtn];
    self.maskView = [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, ScreenSize.height - 64- TopMargin)];
    self.maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    self.maskView.hidden = YES;
    [self.view addSubview:self.maskView];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self.title isEqualToString:DINGYOUDAN] || [self.title isEqualToString:PEIYOUDAN]) {
        SubTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"SubTableViewCell" forIndexPath:indexPath];
        NSDictionary *dict = self.orderResultArray[indexPath.row];
        if ([self.title isEqualToString:DINGYOUDAN]) {
           cell.model = dict;
        }else
        {
            cell.peiModel = dict;
        }
        if ([self.title isEqualToString:PEIYOUDAN] && [dict[@"state"] isEqualToString:GTO_REPAIR_STATE_INITIAL]) {
            cell.stateImageView.image = TCImage(@"组-9-副本-2");
        }
        return cell;
    }
    OilOrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"OilOrderTableViewCell" forIndexPath:indexPath];
    NSDictionary *dict = self.orderResultArray[indexPath.row];
    cell.model = dict;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.orderResultArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self.title isEqualToString:DINGYOUDAN] || [self.title isEqualToString:PEIYOUDAN]) {
        return 200;
    }
    return 150;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    __weak typeof(self) weakSelf = self;
    if ([self.title isEqualToString:JIANCHANGDAN]) {
        //未提交建仓单
        NSDictionary *dict = self.orderResultArray[indexPath.row];
        if ([dict[@"state"] isEqualToString:@"initial"]) {
            NewRequestViewController *details = [self.storyboard instantiateViewControllerWithIdentifier:@"NewRequestViewController"];
            details.orderUUID = dict[@"uuid"];
            details.isSaveDetails = YES;
            details.title = @"建仓申请单明细";
            details.oilTypeDict = dict[@"item"];
            details.distributionDict = dict[@"deliveryArea"];
            [self PushViewController:details animated:YES];
        } else {
            SeeRequestViewController *warehouse = [self.storyboard instantiateViewControllerWithIdentifier:@"SeeRequestViewController"];
            warehouse.title = @"建仓申请单明细";
            //删除建仓单回调
            [warehouse setDeleteAndCancelOrderBillblock:^(NSString *uuidString, BOOL boolValue) {
                
                [weakSelf.orderResultArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                    if ([obj[@"uuid"] isEqualToString:uuidString]) {
                        *stop = YES;
                        if (boolValue) {
                            [weakSelf.oilOrderTableview beginUpdates];
                            [weakSelf.orderResultArray removeObjectAtIndex:idx];//删除
                            [weakSelf.oilOrderTableview deleteRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:idx inSection:0]] withRowAnimation:UITableViewRowAnimationFade];
                            [weakSelf.oilOrderTableview reloadEmptyDataSet];
                            [weakSelf.oilOrderTableview endUpdates];
                        } else {
                            [weakSelf.oilOrderTableview beginUpdates];
                            [weakSelf.orderResultArray[idx] setValue:@"canceled" forKey:@"state"];//作废
                            [weakSelf.oilOrderTableview reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:idx inSection:0]] withRowAnimation:UITableViewRowAnimationFade];
                            [weakSelf.oilOrderTableview endUpdates];
                        }
                    }
                }];
            }];
            warehouse.boolValue = NO;
            warehouse.orderUUID = self.orderResultArray[indexPath.row][@"uuid"];
            [self PushViewController:warehouse animated:YES];
        }
    } else if ([self.title isEqualToString:DINGYOUDAN]) {
        OrderDetailsViewController *orderDetail = [self.storyboard instantiateViewControllerWithIdentifier:@"OrderDetailsViewController"];
        //删除订油单回调
        [orderDetail setDeleteAndCancelOrderBillblock:^(NSString *uuidString, BOOL boolValue) {
            
            [weakSelf.orderResultArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                if ([obj[@"uuid"] isEqualToString:uuidString]) {
                    *stop = YES;
                    if (boolValue) {
                        [weakSelf.oilOrderTableview beginUpdates];
                        [weakSelf.orderResultArray removeObjectAtIndex:idx];//删除
                        [weakSelf.oilOrderTableview deleteRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:idx inSection:0]] withRowAnimation:UITableViewRowAnimationFade];
                        [weakSelf.oilOrderTableview reloadEmptyDataSet];
                        [weakSelf.oilOrderTableview endUpdates];
                        
                    } else {
                        [weakSelf.oilOrderTableview beginUpdates];
                        [weakSelf.orderResultArray[idx] setValue:@"canceled" forKey:@"state"];//作废
                        [weakSelf.oilOrderTableview reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:idx inSection:0]] withRowAnimation:UITableViewRowAnimationFade];
                        [weakSelf.oilOrderTableview endUpdates];
                    }
                }
            }];
        }];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:self.orderResultArray[indexPath.row][@"uuid"],@"uuid",self.orderResultArray[indexPath.row][@"version"],@"version", nil];
        orderDetail.orderUUIDString = dict[@"uuid"];
        orderDetail.boolValue = NO;;
        orderDetail.title = @"订油单明细";
        [self PushViewController:orderDetail animated:YES];
    } else if ([self.title isEqualToString:PEIYOUDAN]) {
        SeeDistributionViewController *distributionView = [self.storyboard instantiateViewControllerWithIdentifier:@"SeeDistributionViewController"];
        distributionView.orderDict = [NSDictionary dictionaryWithObjectsAndKeys:self.orderResultArray[indexPath.row][@"uuid"],@"uuid",self.orderResultArray[indexPath.row][@"version"],@"version", nil];
        distributionView.title = @"配油单明细";
        [self PushViewController:distributionView animated:YES];
    } else if ([self.title isEqualToString:SHOUYOUDAN]) {
        SeeObtainViewController *seeOrder = [self.storyboard instantiateViewControllerWithIdentifier:@"SeeObtainViewController"];
        seeOrder.title = @"收油单单明细";
        //删除收油单回调
        [seeOrder setDeleteAndCancelOrderBillblock:^(NSString *UUIDString, BOOL boolValue) {
            [weakSelf.orderResultArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                if ([obj[@"uuid"] isEqualToString:UUIDString]) {
                    *stop = YES;
                    [weakSelf.oilOrderTableview beginUpdates];
                    [weakSelf.orderResultArray removeObjectAtIndex:idx];
                    [weakSelf.oilOrderTableview deleteRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:idx inSection:0]] withRowAnimation:UITableViewRowAnimationFade];
                    [weakSelf.oilOrderTableview endUpdates];
                    
                }
            }];
        }];
        seeOrder.orderUUIDString = self.orderResultArray[indexPath.row][@"uuid"];
        seeOrder.storeDict = self.orderResultArray[indexPath.row][@"store"];
        [self PushViewController:seeOrder animated:YES];
    }
}

#pragma mark - 确定
- (void)sureClick{
    
     [_boltView.billFiled resignFirstResponder];
    [_boltView.titleFiled resignFirstResponder];
    //还原数据
    if (_sortView) {
        [self hiddenSortMaskView:YES];
    }
    if (_boltView) {
        [self hiddenBoltMaskView:YES];
    }
}

#pragma mark -排序
- (void)sortClick:(UIButton *)btn
{
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = NO;
    if (btn.tag == SortTag) {
        if(_boltView){
            [self hiddenBoltMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
            [self hiddenSortMaskView:YES];
            currentBtn = nil;
        }else{
            [btn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
            if (_sortView == nil) {
                _sortView = [[SortMaskView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 150) withOrderDirection:self.orderDirection];
                _sortView.dataArr = [[NSMutableArray alloc]initWithObjects:@"默认排序",@"按时间逆序",@"按时间顺序",nil];
                _sortView.delegate = self;
                [_maskView addSubview:_sortView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _sortView.frame;
                    sortFrame.origin.y = 0;
                    _sortView.frame = sortFrame;
                }];
            }
            currentBtn = btn;
        }
    }else if(btn.tag == BoltTag){
        if (_sortView) {
            [self hiddenSortMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
            [self hiddenBoltMaskView:YES];
            currentBtn = nil;
            
        }else{
            [btn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
            if (_boltView == nil) {
                CGRect rect = CGRectMake(0, -274, ScreenSize.width, 274) ;
                _boltView = [[GTORepairBoltView alloc]initWithFrame:rect state:self.state title:@"创建人" bill:self.billLike];
                _boltView.backgroundColor = XXFBgColor;
                _boltView.delegate = self;
                //initial(未提交)submitted(已提交)rejected(已拒绝)approved(已审批)shipping(发运中)finished(已完成)
                NSMutableArray *array = [[NSMutableArray alloc]initWithObjects:@"全部",@"未提交",@"已提交",@"已作废",@"配送中",@"已完成",@"已生效",@"已配送",@"已删除",nil];
                if (![self.title isEqualToString:SHOUYOUDAN]) {
                    [array removeLastObject];
                }
                _boltView.dataArr = array;
                [_maskView addSubview:_boltView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _boltView.frame;
                    sortFrame.origin.y = 0;
                    _boltView.frame = sortFrame;
                }];
                currentBtn = btn;
            }
        }
    }
}

- (void)hiddenSortMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkSortBtnColor];
    if (isHide == NO) {
        [_sortView removeFromSuperview];
        _sortView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _sortView.frame;
            sortFrame.origin.y = -105;
            _sortView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_sortView removeFromSuperview];
            _sortView = nil;
            _maskView.hidden = YES;
        }];
    }
}
- (void)hiddenBoltMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkBoltBtnColor];
    if (isHide == NO) {
        [_boltView removeFromSuperview];
        _boltView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _boltView.frame;
            sortFrame.origin.y = -274;
            _boltView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_boltView removeFromSuperview];
            _boltView = nil;
            _maskView.hidden = YES;
        }];
    }
}



//检测排序的颜色
- (void)checkSortBtnColor{
    if (self.orderDirection.length > 0) {
        [self.sortBtn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
    }else{
        [self.sortBtn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
        
    }
}
- (void)checkBoltBtnColor{
    if (self.state.length > 0 || self.billLike.length > 0 || self.billLike.length > 0 || self.titleLike.length > 0) {
        
        [self.boltBtn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
    }else{
        [self.boltBtn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
        
    }
}

#pragma mark-选择排序
- (void)getSortValueSelectRow:(NSString *)state
{
    //还原数据
    if (_sortView) {
        [self hiddenSortMaskView:YES];
    }
    if (_boltView) {
        [self hiddenBoltMaskView:YES];
    }
    if ([state isEqualToString:@"none"]) {
        state = nil;
    }
    NSMutableArray *array = [NSMutableArray arrayWithArray:[self.queryOrder toDictionary][@"orders"]];
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    [dict setValue:state forKey:@"direction"];
    [dict setValue:@"createTime" forKey:@"field"];
    array[0] = dict;
    self.queryOrder.orders = (NSArray<QueryOrder> *)array;
    NSLog(@"%@",[self.queryOrder toDictionary]);
    [self.oilOrderTableview.mj_header beginRefreshing];
}

#pragma mark -订单状态
- (void)getBoltValueSelectRow:(NSString *)state
{
    //现在的状态标示和以前的不一样，以下代码做适配
    if ([state isEqualToString:GTO_REPAIR_STATE_SUBMITTED]) {
        state = @"submit";
    } else if ([state isEqualToString:@"processing"]) {
        //收油单区分
        state = [self.title isEqualToString:SHOUYOUDAN]?@"cancel":@"canceled";
    } else if ([state isEqualToString:@"application"]) {
        state = @"shipping";
    } else if ([state isEqualToString:GTO_REPAIR_STATE_FINISHED]) {
        state = @"accomplished";
    }
    if ([self.title isEqualToString:PEIYOUDAN] && [state isEqualToString:GTO_REPAIR_STATE_INITIAL]) {
        //取消未提交状态
        state = @"zhanwei";
    }
    if ([self.title isEqualToString:PEIYOUDAN] && [state isEqualToString:@"canceled"]) {
        state = GTO_REPAIR_STATE_INITIAL;
    }
    NSMutableArray *array = [NSMutableArray arrayWithArray:[self.queryOrder toDictionary][@"conditions"]];
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    [dict setValue:@"stateIn" forKey:@"operation"];
    [dict setValue:@[state] forKey:@"parameters"];
    array[0] = [state isEqualToString:@"none"]?[NSDictionary dictionary]:dict;
    self.queryOrder.conditions = (NSArray<QueryCondition> *)array;
    NSLog(@"%@",[self.queryOrder toDictionary]);
    [self.oilOrderTableview.mj_header beginRefreshing];
}

#pragma mark -标题类似于
- (void)getTitleLike:(NSString *)titleLike
{
    NSMutableArray *array = [NSMutableArray arrayWithArray:[self.queryOrder toDictionary][@"conditions"]];
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    [dict setValue:@"createNameLike" forKey:@"operation"];
    [dict setValue:@[titleLike] forKey:@"parameters"];
    array[1] = dict;
    self.queryOrder.conditions = (NSArray<QueryCondition> *)array;
    NSLog(@"%@",[self.queryOrder toDictionary]);
    [self.oilOrderTableview.mj_header beginRefreshing];
}

#pragma mark -单号类似于
- (void)getBillNumber:(NSString *)billNumber
{
    NSMutableArray *array = [NSMutableArray arrayWithArray:[self.queryOrder toDictionary][@"conditions"]];
    if ([billNumber isEqualToString:@""]) {
        array[2] = [NSDictionary dictionary];
    }else {
        NSMutableDictionary *dict = [NSMutableDictionary dictionary];
        [dict setValue:@"billNumberEquals" forKey:@"operation"];
        [dict setValue:@[billNumber] forKey:@"parameters"];
        array[2] = dict;
        self.queryOrder.conditions = (NSArray<QueryCondition> *)array;
    }
    NSLog(@"%@",[self.queryOrder toDictionary]);
    [self.oilOrderTableview.mj_header beginRefreshing];
}

#pragma mark -清空所有条件
- (void)clearBoltInformation
{
    self.queryOrder = nil;
    [self.oilOrderTableview.mj_header beginRefreshing];
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return KNODATAIMAGE;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *attributes = @{NSFontAttributeName: [UIFont boldSystemFontOfSize:15.0f], NSForegroundColorAttributeName: [UIColor darkGrayColor]};
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:attributes];
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}



@end
