//
//  BusinessViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/20.
//  Copyright © 2016年 free. All rights reserved.
//

#import "BusinessViewController.h"
#import "BusinessCollectionViewCell.h"
#import "BusinessCollectionReusableView.h"
#import "ICRAnnouncementViewController.h"
#import "GTOBusinessSignInViewController.h"
#import "SeePriceViewController.h"
#import "GTORepairListViewController.h"
#import "GTOLicenceListViewController.h"
#import "GTOLicenceCheckListViewController.h"
#import "GTOPatrolPlanListViewController.h"
#import "NewRequestViewController.h"
#import "SeeRequestViewController.h"
#import "NewOrderViewController.h"
#import "SeeOrderViewController.h"
#import "SeeDistributionViewController.h"
#import "NewObtainViewController.h"
#import "SeeObtainViewController.h"
#import "GTOPioneeringListViewController.h"
#import "GTOPatrolPlanListViewController.h"
#import "PatrolTaskViewController.h"
#import "InspectionTableViewController.h"
#import "PatrolTempCheckViewController.h"
@interface BusinessViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 *  sectionTitle
 */
@property (nonatomic,strong) NSArray *sectionTitleArray;

/**
 *  控制器
 */
@property (nonatomic,strong) NSMutableArray*controllerArray;

/**
 *  控制器title
 */
@property (nonatomic,strong) NSMutableArray *controllerTitleArray;

/**
 *  权限数组
 */
@property (nonatomic,strong) NSMutableArray *permissionsArray;

@end

@implementation BusinessViewController


- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
        for (int i=0; i<5; i++) {
            NSMutableArray *array = [NSMutableArray array];
            [_datasArray addObject:array];
        }
        //通用
        for (int i=0; i<3; i++) {
            NSArray *imageArray = [NSArray arrayWithObjects:
                                   @"function_announcement_icon"
                                   ,@"function_register_icon"
                                   ,@"组-2", nil];
            NSArray *titleArray = [NSArray arrayWithObjects:
                                   @"公告"
                                   ,@"签到"
                                   ,@"查看油品价格"
                                   , nil];
            NSDictionary *dict = @{@"image":[imageArray objectAtIndex:i],@"title":[titleArray objectAtIndex:i]};
            [_datasArray[0] addObject:dict];
        }
        //工程
        for (int i=0; i<4; i++) {
            NSArray *imageArray = [NSArray arrayWithObjects:
                                   @"function_repairSee_icon"
                                   ,@"function_licenceSee_icon"
                                   ,@"function_licenceExam_icon"
                                   ,@"function_ProjectPatrol_icon"
                                   , nil];
            NSArray *titleArray = [NSArray arrayWithObjects:
                                   @"查看报修"
                                   ,@"查看许可证"
                                   ,@"许可证审批"
                                   ,@"工程VI检查", nil];
            NSDictionary *dict = @{@"image":[imageArray objectAtIndex:i],@"title":[titleArray objectAtIndex:i]};
            [_datasArray[1] addObject:dict];
        }
        //建仓、订油、配油、收油
        for (int i=0; i<7; i++) {
            NSArray *imageArray = [NSArray arrayWithObjects:
                                   @"house89"
                                   ,@"组-7"
                                   ,@"-3"
                                   ,@"组-5"
                                   ,@"组-4"
                                   ,@"组-3-副本"
                                   ,@"组-5-副本",nil];
            NSArray *titleArray = [NSArray arrayWithObjects:
                                   @"新建建仓申请"
                                   ,@"查看建仓申请"
                                   ,@"新建订油单"
                                   ,@"查看订油单"
                                   ,@"查看配油单"
                                   ,@"新建收油单"
                                   ,@"查看收油单",nil];
            NSDictionary *dict = @{@"image":[imageArray objectAtIndex:i],@"title":[titleArray objectAtIndex:i]};
            [_datasArray[2] addObject:dict];
        }
        //VI检查
        for (int i=0; i<3; i++) {
            NSArray *imageArray = [NSArray arrayWithObjects:
                                   @"function_vicheck_temp"
                                   ,@"function_vicheck"
                                   ,@"function_vicheckresult",nil];
            NSArray *titleArray = [NSArray arrayWithObjects:
                                   @"VI抽查"
                                   ,@"VI检查任务"
                                   ,@"VI检查结果",nil];
            NSDictionary *dict = @{@"image":[imageArray objectAtIndex:i],@"title":[titleArray objectAtIndex:i]};
            [_datasArray[3] addObject:dict];
        }
        //开发、HSE
        for (int i=0; i<2; i++) {
            NSArray *imageArray = [NSArray arrayWithObjects:
                                   @"function_repairSee_icon"
                                   ,@"function_licenceSee_icon"
                                   ,nil];
            NSArray *titleArray = [NSArray arrayWithObjects:
                                   @"拓站"
                                   ,@"HSEVI检查",nil];
            NSDictionary *dict = @{@"image":[imageArray objectAtIndex:i],@"title":[titleArray objectAtIndex:i]};
            [_datasArray[4] addObject:dict];
        }
    }
    return _datasArray;
}

- (NSArray *)sectionTitleArray
{
    if (!_sectionTitleArray) {
        _sectionTitleArray = [NSArray arrayWithObjects:
                              @"通用"
                              ,@"工程"
                              ,@"建仓、订油、配油、收油"
                              ,@"VI检查"
                              ,@"开发、HSE", nil];
    }
    return _sectionTitleArray;
}

- (NSMutableArray *)controllerArray
{
    if (!_controllerArray) {
        _controllerArray = [NSMutableArray array];
        //通用
        NSArray *general = [NSArray arrayWithObjects:
                            @"ICRAnnouncementViewController"
                            ,@"GTOBusinessSignInViewController"
                            ,@"SeePriceViewController", nil];
        //工程
        NSArray *project = [NSArray arrayWithObjects:
                            @"GTORepairListViewController"
                            ,@"GTOLicenceListViewController"
                            ,@"GTOLicenceCheckListViewController"
                            ,@"GTOPatrolPlanListViewController",nil];
        //建仓、订油、配油、收油
        NSArray *oil = [NSArray arrayWithObjects:
                        @"NewRequestViewController"
                        ,@"SeeOrderViewController"
                        ,@"NewOrderViewController"
                        ,@"SeeOrderViewController"
                        ,@"SeeOrderViewController"
                        ,@"NewObtainViewController"
                        ,@"SeeOrderViewController", nil];
        //VI检查
        NSArray *viExamine = [NSArray arrayWithObjects:
                                @"PatrolTaskViewController"
                                ,@"PatrolTaskViewController"
                                ,@"PatrolTaskViewController", nil];
        //开发、HSE
        NSArray *development = [NSArray arrayWithObjects:
                                @"GTOPioneeringListViewController"
                                ,@"GTOPatrolPlanListViewController", nil];
        //统一管理
        [_controllerArray addObject:general];
        [_controllerArray addObject:project];
        [_controllerArray addObject:oil];
        [_controllerArray addObject:viExamine];
        [_controllerArray addObject:development];
    }
    return _controllerArray;
}

- (NSMutableArray *)controllerTitleArray
{
    if (!_controllerTitleArray) {
        _controllerTitleArray = [NSMutableArray array];
        //通用
        NSArray *array = [NSArray arrayWithObjects:@"",@"",@"查看又品价格", nil];
        //建仓、订油、配油、收油
        NSArray *warehouse = [NSArray arrayWithObjects:
                              @"新建建仓申请"
                              ,@"查看建仓申请"
                              ,@"新建订油单"
                              ,@"查看订油单"
                              ,@"查看配油单"
                              ,@"新建收油单"
                              ,@"查看收油单", nil];
        [_controllerTitleArray addObject:array];
        [_controllerTitleArray addObject:@"占位"];
        [_controllerTitleArray addObject:warehouse];
    }
    return _controllerTitleArray;
}


- (NSMutableArray *)permissionsArray
{
    if (!_permissionsArray) {
        
        //通用
        NSArray *general = [NSArray arrayWithObjects:
                            @"500602,500601"
                            ,@"500702,500700"
                            ,@"501201", nil];
        //工程
        NSArray *project = [NSArray arrayWithObjects:
                            @"500303,500300"
                            ,@"500402,500401"
                            ,@"500404,500403"
                            ,@"500101,500102,500103", nil];
        //建仓、订油、配油、收油
        NSArray *order = [NSArray arrayWithObjects:
                          @"500802"
                          ,@"500801"
                          ,@"500902"
                          ,@"500901"
                          ,@"501001"
                          ,@"501102"
                          ,@"501101", nil];
        
        //VI检查
        NSArray *viExamine = [NSArray arrayWithObjects:
                                @"501601,501602"
                                ,@"501401,501402"
                                ,@"501501",nil];
        //开发、HSE
        NSArray *development = [NSArray arrayWithObjects:
                                @"500501,500502,500503"
                                ,@"500201,500202,500203",nil];
        _permissionsArray = [NSMutableArray arrayWithObjects:general,project,order,viExamine,development, nil];
    }
    return _permissionsArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self getStoreArray];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.businessCollectionLayout.itemSize = CGSizeMake(ScreenSize.width/4, (ScreenSize.width)/4);
    self.businessCollectionLayout.minimumLineSpacing = 0;
    self.businessCollectionLayout.headerReferenceSize = CGSizeMake(ScreenSize.width, 30);
    self.businessCollectionLayout.minimumInteritemSpacing = 0;
    self.businessCollectionView.alwaysBounceVertical = YES;
    self.businessCollectionView.delegate = self;
    self.businessCollectionView.dataSource = self;
    UIImageView *backgrundView = [[UIImageView alloc]initWithFrame:self.businessCollectionView.frame];
    backgrundView.image = TCImage(@"home_bg");
    self.businessCollectionView.backgroundView = backgrundView;
    [self.businessCollectionView registerNib:[UINib nibWithNibName:@"BusinessCollectionReusableView" bundle:nil] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"BusinessCollectionReusableView"];
}

#pragma mark -获取登录人的所有的油站
- (void)getStoreArray
{
    [IBTLoadingView showProgressLabel:@"获取门店中"];
    [HttpRequestManager requestNetworkwithURL:[NSString stringWithFormat:@"%@/mdata/store/getsByUser2/%@",VIHTTP_REST_API_BASE_URL,[ICRUserUtil sharedInstance].f_user_uuid] withRequestType:ONE withParameter:nil withSuccess:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([returnValue[@"success"] isEqualToNumber:@1]) {
            [ICRUserUtil sharedInstance].storeArray = returnValue[@"data"];
        }
    } withFailed:^(NSError *failed) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:failed.localizedDescription];
    }];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    BusinessCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"BusinessCollectionViewCell" forIndexPath:indexPath];
    UIImage *image = TCImage([[self.datasArray[indexPath.section] objectAtIndex:indexPath.row] objectForKey:@"image"]);
    //判断权限
    NSArray *permission = [self.permissionsArray[indexPath.section][indexPath.row] componentsSeparatedByString:@","];
    for (int i=0; i<permission.count; i++) {
        if ([self permissionWithMaxNumber:permission[i]]) {
            cell.functionImageView.image = image;
            cell.userInteractionEnabled = YES;
            break;
        }
        if (i == permission.count-1) {
            cell.functionImageView.image = [image rt_tintedImageWithColor:[UIColor grayColor] level:0.7];
            cell.userInteractionEnabled = NO;
        }
    }
    cell.functionName.text = [[self.datasArray[indexPath.section] objectAtIndex:indexPath.row] objectForKey:@"title"];
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return [self.datasArray[section] count];
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return self.datasArray.count;
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]) {
        BusinessCollectionReusableView *sectionView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"BusinessCollectionReusableView" forIndexPath:indexPath];
        
        switch (indexPath.section) {
            case 0://通用
            {
                UIImage *image = [UIImage imageNamed:@"形状-1-副本-3"];
                sectionView.backgrundImageView.image = [image resizableImageWithCapInsets:UIEdgeInsetsMake(10, 10, 30, 30) resizingMode:UIImageResizingModeStretch];
            }
                break;
            case 1://工程
            {
                UIImage *image = [UIImage imageNamed:@"形状-1-副本-3"];
                sectionView.backgrundImageView.image = [image resizableImageWithCapInsets:UIEdgeInsetsMake(10, 10, 30, 30) resizingMode:UIImageResizingModeStretch];
            }
                break;
            case 2://建仓、订油、配油、收油
            {
                UIImage *image = [UIImage imageNamed:@"89"];
                sectionView.backgrundImageView.image = [image resizableImageWithCapInsets:UIEdgeInsetsMake(10, 10, 30, 30)resizingMode:UIImageResizingModeStretch];
            }
                break;
            case 3://VI检查
            {
                UIImage *image = [UIImage imageNamed:@"形状-1-副本-3"];
                sectionView.backgrundImageView.image = [image resizableImageWithCapInsets:UIEdgeInsetsMake(10, 10, 30, 30) resizingMode:UIImageResizingModeStretch];
            }
                break;
            case 4://开发、HSE
            {
                UIImage *image = [UIImage imageNamed:@"形状-1-副本-3"];
                sectionView.backgrundImageView.image = [image resizableImageWithCapInsets:UIEdgeInsetsMake(10, 10, 30, 30) resizingMode:UIImageResizingModeStretch];
            }
                break;
                
            default:
                break;
        }
        sectionView.sectionTitle.text = [self.sectionTitleArray objectAtIndex:indexPath.section];
        return sectionView;
    }
    return nil;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
        case 0:
        {
            if (indexPath.row == 2) {
                [self storyBoardPush:indexPath];
            }else
            {
                [self ordinaryPush:indexPath];
            }
        }
            break;
        case 1:
        {
            [self ordinaryPush:indexPath];
        }
            break;
        case 2:
        {
            [self storyBoardPush:indexPath];
        }
            break;
        case 3:
        {
            [self patrol_StoryboardPush:indexPath];
        }
            break;
        case 4:
        {
            [self ordinaryPush:indexPath];
        }
            break;
            
        default:
            break;
    }
}

#pragma mark -普通跳转
- (void)ordinaryPush:(NSIndexPath *)indexPath
{
    if (indexPath.row == 3 && indexPath.section == 1) {
        GTOPatrolPlanListViewController *controller = (GTOPatrolPlanListViewController *)[[NSClassFromString(self.controllerArray[indexPath.section][indexPath.row])alloc]initWithTitle:@"project"];
        [self PushViewController:controller animated:YES];return;
    }else if(indexPath.row == 1 && indexPath.section == 3) {
        GTOPatrolPlanListViewController *controller = (GTOPatrolPlanListViewController *)[[NSClassFromString(self.controllerArray[indexPath.section][indexPath.row])alloc]initWithTitle:@"HSE"];
        [self PushViewController:controller animated:YES];return;
    }
    UIViewController *controller = [[NSClassFromString(self.controllerArray[indexPath.section][indexPath.row])alloc]init];
    [self PushViewController:controller animated:YES];
}

#pragma mark -storyboard跳转
- (void)storyBoardPush:(NSIndexPath *)indexPath
{
    BaseViewController *controller = [self.storyboard instantiateViewControllerWithIdentifier:(self.controllerArray[indexPath.section][indexPath.row])];
    controller.title = [self.controllerTitleArray[indexPath.section] objectAtIndex:indexPath.row];
    [self PushViewController:controller animated:YES];
}

#pragma mark -VI检查storyboard跳转
- (void)patrol_StoryboardPush:(NSIndexPath *)indexPath
{
    if (indexPath.item == 2) {
        InspectionTableViewController *patrolResultVc = [InspectionTableViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECTRESULT];
        [self PushViewController:patrolResultVc animated:YES];
    }else if (indexPath.item == 1) {
        PatrolTaskViewController *patrolTask = [PatrolTaskViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
        patrolTask.isTempTask = NO;
        [self PushViewController:patrolTask animated:YES];
    }else {
        PatrolTempCheckViewController *tempChecKVc = [PatrolTempCheckViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
        [self PushViewController:tempChecKVc animated:YES];
    }
}

//根据个人查看权和本人查看权的范围确定是否有菜单权限
- (BOOL)permissionWithMaxNumber: (NSString *)maxNumber{
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
  return [userU.f_permissions containsObject:maxNumber];
}



@end
