//
//  InspectionPlanTableViewCell.m
//  patrol
//
//  Created by 曹云霄 on 16/9/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionPlanTableViewCell.h"
#import "SupervisionTableViewCell.h"
#import "SupervisionHeaderTableViewCell.h"
#import "InspectionDetailTableViewController.h"

#define CELL_HEIGHT 50

@implementation InspectionPlanTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    [self setupTableView];
}

#pragma mark - 数据源
- (void)setPlanResultModel:(Records *)planResultModel
{
    _planResultModel = planResultModel;
    dispatch_async(dispatch_get_main_queue(), ^{
        [self.supervisionTableView reloadData];
    });
}

#pragma mark - 代理
- (void)setupTableView
{
    self.supervisionTableView.delegate = self;
    self.supervisionTableView.dataSource = self;
}

#pragma mark -<UITableViewDataSource..>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    SupervisionTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:[SupervisionTableViewCell className] forIndexPath:indexPath];
    cell.storesModel = [[self.planResultModel.inspectors[indexPath.section] results] yx_objectAtIndex:indexPath.row];
    return cell;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SupervisionHeaderTableViewCell *header = [tableView dequeueReusableCellWithIdentifier:[SupervisionHeaderTableViewCell className]];
    header.model = self.planResultModel.inspectors[section];
    return header.contentView;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [[self.planResultModel.inspectors[section] results] count];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.planResultModel.inspectors.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CELL_HEIGHT;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return CELL_HEIGHT;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    //VI检查员model
    Inspectors *inspectorsModel = self.planResultModel.inspectors[indexPath.section];
    //门店VI检查结果model
    Results *storeResultsModel = [[self.planResultModel.inspectors[indexPath.section] results] yx_objectAtIndex:indexPath.row];
    if ([self.delegate respondsToSelector:@selector(storesClickEvent:inspectionPerson:planResults:planUuid:)]) {
        [self.delegate storesClickEvent:indexPath inspectionPerson:inspectorsModel planResults:storeResultsModel planUuid:self.planResultModel.uuid];
    }
}


@end
