//
//  InspectionAnswerTableViewCell.m
//  patrol
//
//  Created by 曹云霄 on 2016/12/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionAnswerTableViewCell.h"
#import "KWFormViewQuickBuilder.h"

@implementation InspectionAnswerTableViewCell


#pragma mark - 初始化
- (void)awakeFromNib {
    [super awakeFromNib];

    [self addPhotoManager];
    [self addSatrView];
}

#pragma mark -设置尺寸
- (void)layoutSubviews
{
    if (!self.answerModel.resultAttachments.count) {
        return;
    }
//    if (self.answerModel.remarkHeight) {
//        [self.photoManager.view mas_makeConstraints:^(MASConstraintMaker *make) {
//            make.left.right.equalTo(self.remarkContentLabel);
//            make.top.equalTo(self.remarkContentLabel.mas_bottom).offset(10);
//            make.bottom.equalTo(self).offset(-10);
//        }];
//    }else {
        [self.photoManager.view mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentLabel);
            make.top.equalTo(self.contentLabel.mas_bottom).offset(10);
            make.bottom.equalTo(self).offset(-10);
        }];
//    }
}

#pragma mark - 添加星星
- (void)addSatrView
{
    self.tggStarEvaView = [[WQLStarView alloc]initWithFrame:CGRectMake(72, 10, ScreenSize.width-30-72, 17) withTotalStar:5 withTotalPoint:10 starSpace:10];
    [self.contentView addSubview:self.tggStarEvaView];
}

#pragma mark - 图片管理
- (void)addPhotoManager
{
    self.photoManager = [InspectionPhotoViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECTRESULT];
    self.photoManager.view.backgroundColor = [UIColor clearColor];
    [self.contentView addSubview:self.photoManager.view];
}

#pragma mark - 赋值
- (void)setAnswerModel:(NewAnswers *)answerModel
{
    _answerModel = answerModel;
    //星星
    self.tggStarEvaView.hidden = !(_answerModel.questionType == kICRQestionTypeStarNum);
    //表格
    self.formScrollView.hidden = !(_answerModel.questionType == kICRQestionTypeSpeciesInv || _answerModel.questionType == kICRQestionTypeStoreInv);
    switch (_answerModel.questionType) {
        case kICRQestionTypeSingleSel://0单选
            [self setupSingleControls];
            break;
        case kICRQestionTypeMultipleSel://1多选
            [self setupMultiSelectControls];
            break;
        case kICRQestionTypeReply://2回复类
            [self setupRemarkControls];
            break;
        case kICRQestionTypeScore://3评分类
            [self setupScoreControls];
            break;
        case kICRQestionTypeStoreInv://4库存调查类
            [self setupFormQuestionControls];
            break;
        case kICRQestionTypeSpeciesInv://5品类调查类
            [self setupFormQuestionControls];
            break;
        case kICRQestionTypeStarNum://6星数类
            [self setupStarQuestionControls];
            break;
        case kICRQestionTypeSingleScore://7单选打分
            [self setupSingleScoreControls];
            break;
        case kICRQestionTypeYesOrNO://8是非题
            [self rightAndWrongControls];
            break;
        default:
            break;
    }
}

#pragma mark - 单选题
- (void)setupSingleControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    NewDetails *detail = [self.answerModel.details firstObject];
    self.contentLabel.text = [NSString stringWithFormat:@"%@",detail.questionValue];
    [self addImageAttachment];
}

#pragma mark - 回复题
- (void)setupRemarkControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    NewDetails *detail = self.answerModel.details.firstObject;
    self.contentLabel.text = [NSString stringWithFormat:@"%@",detail.questionValue];
    [self addImageAttachment];
}

#pragma mark - 单选打分题
- (void)setupSingleScoreControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    NewDetails *detail = [self.answerModel.details firstObject];
    NSString *scoreString = [NSString stringWithFormat:@"%@   %@分",detail.questionValue,self.answerModel.score];
    self.contentLabel.text = scoreString;
    [self addImageAttachment];
}

#pragma mark - 多选题
- (void)setupMultiSelectControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    NSMutableString *mutableString = [NSMutableString string];
    for (NewDetails *detail in self.answerModel.details) {
        [mutableString appendString:[NSString stringWithFormat:@"%@   ",detail.questionValue]];
    }
    self.contentLabel.text = mutableString;
    [self addImageAttachment];
}

#pragma mark - 是非题
- (void)rightAndWrongControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    NewDetails *detail = [self.answerModel.details firstObject];
    NSString *string;
    switch (detail.index) {
        case 1:
            string = @"是";
            break;
        case 2:
            string = @"否";
            break;
        case 3:
            string = @"无此项";
            break;
            
        default:
            break;
    }
    self.contentLabel.text = string;
    [self addImageAttachment];
}

#pragma mark - 评分题
- (void)setupScoreControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    self.contentLabel.text = [NSString stringWithFormat:@"%@%@",self.answerModel.score,@"分"];
    [self addImageAttachment];
}

#pragma mark - 表格题
- (void)setupFormQuestionControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    self.contentLabel.text = [NSString stringWithFormat:@"%@",self.answerModel.content];
    [self processingFormData:self.answerModel];
    [self addImageAttachment];
}

#pragma mark - 处理表格数据
- (void)processingFormData:(NewAnswers *)model
{
    _formDatasArray = [NSMutableArray array];
    _formWidths = [NSMutableArray array];
    _titles = [NSMutableArray array];
    if (self.boolValue) {
        if (model.details.count) {
            for (NewDetails *detail in model.details) {
                NSMutableArray *tempArray = [NSMutableArray array];
                [tempArray addObject:detail.productName];
                [tempArray addObject:[NSString stringWithFormat:@"%ld",detail.numberValue]];
                [self.formDatasArray addObject:tempArray];
                [self.formWidths addObject:@(100)];
                [self.titles addObject:@"库存"];
            }
        }
    }else
    {
        if (model.details.count) {
            NSMutableArray *tempArray = [NSMutableArray array];
            for (NewDetails *detail in model.details) {
                [tempArray addObject:@(detail.numberValue)];
                
                NSString *string = detail.questionValue?detail.questionValue:@"空";
                if (![self.titles containsObject:string]) {
                    [self.titles addObject:string];
                }
            }
            //去重
            NSSet *set = [NSSet setWithArray:tempArray];
            NSArray *setArray = [set allObjects];
            for (int i=0; i<setArray.count; i++) {
                NSMutableArray *array = [NSMutableArray array];
                [self.formDatasArray addObject:array];
            }
            for (int j=0; j<setArray.count; j++) {
                for (int i=0; i<model.details.count; i++) {
                    NewDetails *detail = model.details[i];
                    if ([setArray[j] integerValue] == detail.numberValue) {
                        
                        [self.formDatasArray[j] addObject:detail.stringValue?detail.stringValue:@"空"];
                    }
                }
            }
            for (int i=0; i<[[self.formDatasArray firstObject] count]; i++) {
                [self.formWidths addObject:@100];
            }
        }
    }
    [self setUpFormView];
}

#pragma mark - 设置表格View
- (void)setUpFormView
{
    NSInteger columnsNumber = self.boolValue?self.formDatasArray.count:[[self.formDatasArray firstObject] count];//列数
    //计算表格所需高度
    CGFloat scrollViewHeight = 0;
    NSMutableArray *tempArray = [NSMutableArray array];
    for (NewDetails *detail in self.answerModel.details) {
        [tempArray addObject:@(detail.numberValue)];
    }
    NSSet *set = [NSSet setWithArray:tempArray];
    //40表格高度
    scrollViewHeight = ([set allObjects].count+1) * 40 + 20;
    self.formScrollView.frame = CGRectMake(72, 8, ScreenSize.width-72-15, scrollViewHeight);
    [self.contentView addSubview:self.formScrollView];
    KWFormViewQuickBuilder *builder = [[KWFormViewQuickBuilder alloc] init];
    [builder addRecord: self.titles];
    
    for (int i=0; i<self.formDatasArray.count; i++) {
        NSArray *array = self.formDatasArray[i];
        [builder addRecord:array];
    }
    KWFormView *formView = [builder startCreatWithWidths:self.formWidths startPoint:CGPointMake(10, 10)];
    self.formScrollView.contentSize = CGSizeMake(columnsNumber * 100 + 20, 0);
    self.contentLabel.text = nil;
    [self.formScrollView addSubview:formView];
}

#pragma mark - 星数题
- (void)setupStarQuestionControls
{
    //未回答
    if (!self.answerModel.answered) {
        [self noAnswersCondition];return;
    }
    self.tggStarEvaView.commentPoint = [self.answerModel.score floatValue];
    self.contentLabel.text = @" ";
    [self addImageAttachment];
}

#pragma mark - 添加图片附件、添加备注
- (void)addImageAttachment
{
    if (!self.answerModel.remark.empty) {
        self.remarkContentLabel.hidden = NO;
        self.remarkContentLabel.text = self.answerModel.remark;
    }else {
        self.remarkContentLabel.hidden = YES;
        self.remarkContentLabel.text = nil;
    }
    if (self.answerModel.resultAttachments.count) {
        self.photoManager.view.hidden = NO;
        self.photoManager.attachmentArray = self.answerModel.resultAttachments;
        self.photoManager.indexPath = self.indexPath;
    }else {
        self.photoManager.view.hidden = YES;
    }
    self.contentLabel.textColor = GTO_BLUE_DEEP_COLOR;
}

#pragma mark - 未填写情况
- (void)noAnswersCondition
{
    self.contentLabel.textColor = [UIColor redColor];
    self.contentLabel.text = @"未填写";
    self.photoManager.view.hidden = YES;
    self.formScrollView.hidden = YES;
    self.tggStarEvaView.hidden = YES;
}

#pragma mark - lazy
- (UIScrollView *)formScrollView
{
    if (!_formScrollView) {
        _formScrollView = [[UIScrollView alloc]init];
    }
    return _formScrollView;
}

@end
