//
//  GTOPositionMapViewController.m
//  total
//  查看记录的位置
//  Created by freecui on 15/12/9.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOPositionMapViewController.h"
#import "ICRStoreResult.h"
#import "GXFBottomView.h"
@interface GTOPositionMapViewController ()<BMKMapViewDelegate,GXFBottomViewDelegate,BMKLocationServiceDelegate>
@property (strong, nonatomic) BMKMapView* mapView;
@property (strong, nonatomic) BMKLocationService *locService;

@property (strong, nonatomic) IBTUILabel *coordinateLbl;
@property (strong, nonatomic)  IBTUILabel *timeLbl;
@property (strong, nonatomic)  IBTUILabel *storeLbl;
@property (strong, nonatomic)  ICRStoreResult *m_storeResult;
@end

@implementation GTOPositionMapViewController
- (instancetype)initWithStoreResult: (ICRStoreResult *)storeResult {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.m_storeResult = storeResult;
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"记录位置";
    [self p_initWithSubViews];
}
- (void)p_initWithSubViews {
    
    CGFloat totalH = self.view.height - 64;
    self.mapView = [[BMKMapView alloc]initWithFrame:CGRectMake(0, 0,self.view.width , totalH * 0.6)];
    [self.view addSubview:_mapView];
    [self displayAnnotationWithLatitude:[_m_storeResult.latitude floatValue] andLongitude:[_m_storeResult.longitude floatValue]];
    
    
    UIView *currentV = [[UIView alloc]initWithFrame:CGRectMake(0, _mapView.bottom, self.view.width, 44)];
    currentV.backgroundColor = XXFBgColor;
    IBTUILabel *addressLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(10, 0, currentV.width * 0.5 - 10, currentV.height) text:@"定位位置" font:[UIFont systemFontOfSize:19] tintColor:[UIColor blackColor] backgroundColor:XXFBgColor textAlignment:NSTextAlignmentLeft];
    CGFloat btnW = 44;
//    IBTUILabel *locationLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(addressLbl.right, 0, currentV.width * 0.5 - 10 - btnW, currentV.height) text:@"重新定位" font:[UIFont systemFontOfSize:16] tintColor:[UIColor blackColor] backgroundColor:XXFBgColor textAlignment:NSTextAlignmentRight];
//    UIButton *locationBtn = [[UIButton alloc]initWithFrame:CGRectMake(locationLbl.right, locationLbl.y, btnW, locationLbl.height)];
//    [locationBtn setBackgroundImage:[UIImage imageNamed:@""] forState:UIControlStateNormal];//icon_nav_start
   // [locationBtn addTarget:self action:@selector(relocationClicked) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:currentV];
    [currentV addSubview:addressLbl];
//    [currentV addSubview:locationLbl];
//    [currentV addSubview:locationBtn];
    
    
    CGFloat addressValueVH = totalH - currentV.bottom - BottomViewHeight - 20;
    UIView *addressValueV = [[UIView alloc]initWithFrame:CGRectMake(10, currentV.bottom, self.view.width - 20,addressValueVH)];
    
    CGFloat lblH = (addressValueVH - 12.0 ) / 3.0;
    IBTUILabel *coordinateLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(0, 6,addressValueV.width, lblH) text:[NSString stringWithFormat:@"定位坐标： %@,%@",[GTOCommonTools nullChangedWithId:_m_storeResult.latitude],[GTOCommonTools nullChangedWithId:_m_storeResult.longitude]] font:[UIFont systemFontOfSize:17] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    IBTUILabel *timeLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(0, coordinateLbl.bottom,addressValueV.width, lblH) text:[NSString stringWithFormat:@"定位时间： %@",[GTOCommonTools nullChangedWithId:_m_storeResult.locatedTime]] font:[UIFont systemFontOfSize:17] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    IBTUILabel *storeLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(0, timeLbl.bottom,addressValueV.width, lblH) text:[NSString stringWithFormat:@"附近油站： %@",_m_storeResult.realStore_name] font:[UIFont systemFontOfSize:17] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    if (_m_storeResult.realStore_name.length == 0) {
         storeLbl.text = [NSString stringWithFormat:@"附近门店： %@",@"无"];
    }
    self.coordinateLbl = coordinateLbl;
    self.timeLbl = timeLbl;
    self.storeLbl = storeLbl;
    [addressValueV addSubview:_coordinateLbl];
    [addressValueV addSubview:_timeLbl];
    [addressValueV addSubview:_storeLbl];
    [self.view addSubview:addressValueV];

    CGRect rectBottom = CGRectMake(0, addressValueV.bottom  +20, self.view.width, BottomViewHeight);
    GXFBottomView *bottomV;
    if (!(_m_storeResult.state == kPatrolStoreStateSubmitted)) {
        bottomV = [[GXFBottomView alloc]initWithFrame:rectBottom leftButtonColor:GTO_BLUE_DEEP_COLOR rightButtonColor:GTO_RED_COLOR LeftBtnTitle:@"返回" rightBtnTitle:@"重新定位"];

    } else {
        bottomV = [[GXFBottomView alloc]initOneButtonWithFrame:rectBottom buttonColor:GTO_BLUE_DEEP_COLOR buttonTitle:@"返回"];
    }
    bottomV.delegate = self;
    [self.view addSubview:bottomV];
}

#pragma bottomViewDelegate
- (void)bottomView:(GXFBottomView *)bottomView leftButtonClicked:(UIButton *)leftBtn {
    [self PopViewControllerAnimated:YES];
}
- (void)bottomView:(GXFBottomView *)bottomView RightButtonClicked:(UIButton *)rightBtn {
    if (!_locService) {
        self.locService = [[BMKLocationService alloc]init];
        self.locService.delegate = self;
        [self.locService startUserLocationService];
    }
}
- (void)bottomView:(GXFBottomView *)bottomView oneButtonClicked:(UIButton *)oneBtn {
     [self PopViewControllerAnimated:YES];
}
#pragma BMKLocationServiceDelegate
- (void)willStartLocatingUser {
    NSLog(@"start locate");
}

- (void)didFailToLocateUserWithError:(NSError *)error
{
    [_locService stopUserLocationService];
    UIAlertView *alertV = [[UIAlertView alloc]initWithTitle:@"目前无法定位" message:@"是否放弃重新定位" delegate:self cancelButtonTitle:@"放弃定位" otherButtonTitles:@"再次尝试", nil];
    [alertV show];
    NSLog(@"location error");
}
- (void)didUpdateBMKUserLocation:(BMKUserLocation *)userLocation {
    NSLog(@"didUpdateUserLocation lat %f,long %f",userLocation.location.coordinate.latitude,userLocation.location.coordinate.longitude);
    NSString *latitude = [NSString stringWithFormat:@"%.6f",userLocation.location.coordinate.latitude];
    NSString *longitude = [NSString stringWithFormat:@"%.6f",userLocation.location.coordinate.longitude];
    _m_storeResult.latitude = latitude;
    _m_storeResult.longitude = longitude;
    _m_storeResult.locatedTime = [[NSDate date] httpParameterString];
    [_m_storeResult saveToDBWithHandleData:NULL complete:^{
        self.coordinateLbl.text = [NSString stringWithFormat:@"定位坐标： %@,%@",[GTOCommonTools nullChangedWithId:_m_storeResult.latitude],[GTOCommonTools nullChangedWithId:_m_storeResult.longitude]];
        self.timeLbl.text = [NSString stringWithFormat:@"定位时间： %@",_m_storeResult.locatedTime];
        self.storeLbl.text = [NSString stringWithFormat:@"附近油站： "];
        [self displayAnnotationWithLatitude:userLocation.location.coordinate.latitude andLongitude:userLocation.location.coordinate.longitude];
        [_mapView updateLocationData:userLocation];
        [_locService stopUserLocationService];
        [IBTLoadingView showTextOnly:@"重新定位成功"];
    } fail:NULL];
}
- (void)displayAnnotationWithLatitude: (CGFloat)latitude
                         andLongitude: (CGFloat)longitude {
    _mapView.userTrackingMode = BMKUserTrackingModeNone;//设置定位的状态
    _mapView.showsUserLocation = YES;//显示定位图层
    _mapView.centerCoordinate = CLLocationCoordinate2DMake(latitude,longitude);
    //增加大头针
    BMKPointAnnotation *pointAnnotation = [[BMKPointAnnotation alloc]init];
    CLLocationCoordinate2D coor;
    coor.latitude = latitude;
    coor.longitude = longitude;
    pointAnnotation.coordinate = coor;
    [_mapView addAnnotation:pointAnnotation];
    _mapView.zoomLevel = 17;
    
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    switch (buttonIndex) {
        case 0:
        {
            [_locService stopUserLocationService];
        }
            break;
        case 1:
        {
            [self.locService startUserLocationService];
        }
            break;
        default:
            break;
    }
}
- (void)didStopLocatingUser
{
    NSLog(@"stop locate");
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
