//
//  ICRQScoreViewController.m
//  Cruiser
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQScoreViewController.h"
#import "ASValueTrackingSlider.h"
#import "ICRQuestionManager.h"

#define LABLE_WIDTH   (40)
#define LABLE_HEIAGHT (20)
#define LEFT_MARGIN   (15)

@interface ICRQScoreViewController ()

@property (strong, nonatomic) ASValueTrackingSlider *m_scoreSlider;

@end

@implementation ICRQScoreViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    if (self.m_answer.score > 0) {
        _m_scoreSlider.value = self.m_answer.score;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)initScrollViewWithRect:(CGRect)rect {
    
    [super initScrollViewWithRect:rect];
    
    UILabel *minValuelabel = [[UILabel alloc] initWithFrame:((CGRect){
        .origin.x = LEFT_MARGIN,
        .origin.y = 60,
        .size.width = LABLE_WIDTH,
        .size.height = LABLE_HEIAGHT
    })];
    minValuelabel.font = [UIFont systemFontOfSize:17];
    minValuelabel.textColor = [UIColor grayColor];
    minValuelabel.textAlignment = NSTextAlignmentCenter;
    minValuelabel.text = [NSString stringWithFormat:@"%@", @( self.m_question.scoreFrom )];
    
    self.m_scoreSlider = [[ASValueTrackingSlider alloc] initWithFrame:((CGRect){
        .origin.x = minValuelabel.right,
        .origin.y = minValuelabel.top,
        .size.width = self.view.width - LABLE_WIDTH * 2 - LEFT_MARGIN * 2,
        .size.height = LABLE_HEIAGHT
    })];
    self.m_scoreSlider.popUpViewCornerRadius = 0.0;
    [self.m_scoreSlider setMaxFractionDigitsDisplayed:0];
    self.m_scoreSlider.popUpViewColor = [UIColor colorWithHue:0.55 saturation:0.8 brightness:0.9 alpha:0.7];
    self.m_scoreSlider.font = [UIFont systemFontOfSize:20];
    self.m_scoreSlider.textColor = [UIColor colorWithHue:0.55 saturation:1.0 brightness:0.5 alpha:1];
    self.m_scoreSlider.popUpViewWidthPaddingFactor = 1.7;
    [_m_scoreSlider showPopUpViewAnimated:YES];
    _m_scoreSlider.minimumValue = self.m_question.scoreFrom;
    _m_scoreSlider.maximumValue = self.m_question.scoreTo;
    [self.m_scoreSlider addTarget:self action:@selector(slidedScore) forControlEvents:UIControlEventValueChanged];
    UILabel *maxValuelabel = [[UILabel alloc] initWithFrame:((CGRect){
        .origin.x = _m_scoreSlider.right,
        .origin.y = _m_scoreSlider.top,
        .size.width = LABLE_WIDTH,
        .size.height = LABLE_HEIAGHT
    })];
    maxValuelabel.textAlignment = NSTextAlignmentCenter;
    maxValuelabel.font = [UIFont systemFontOfSize:17];
    maxValuelabel.textColor = [UIColor grayColor];
    maxValuelabel.text = [NSString stringWithFormat:@"%@", @( self.m_question.scoreTo )];
    

    [self.m_contentScrollView addSubview:minValuelabel];
    [self.m_contentScrollView addSubview:maxValuelabel];
    [self.m_contentScrollView addSubview:_m_scoreSlider];
    if (self.d_notEdit) {
        _m_scoreSlider.userInteractionEnabled = NO;
    }
    
}
- (void)slidedScore {
    self.m_answer.score = _m_scoreSlider.value;
}
#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    self.m_answer.score = _m_scoreSlider.value;
    
    self.m_answer.bIsAnswered = YES;
    self.m_answer.remark = self.m_helperView.m_inputTxtF.text;
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
//        [self openResultView];
    }
    
    [self.m_answer saveToDBWithHandleData:NULL complete:NULL fail:NULL];
}

@end
