
//
//  GTOCategoryItemView.m
//  total
//  cell根据问题的区域分类的Item
//  Created by freecui on 15/9/16.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOCategoryItemView.h"
#import "GTOLicence.h"
#import "GTOPatrolPlan.h"
#import "GTOPioneeingProcess.h";
#import "GTOPioneering.h"
#import "ICRStoreResult.h"
@interface GTOCategoryItemView ()
//@property (strong, nonatomic) UIButton *m_categoryButton;//门店代码
@property (strong, nonatomic) UIImageView *m_categoryImgView;
@property (strong, nonatomic) IBTUILabel *m_categoryLabel;
@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel *m_processLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;//进度条

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOCategoryItemView
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    [self _init];
    return self;
}

- (void)_init
{

    self.m_categoryImgView = [[UIImageView alloc] init];
    self.m_categoryImgView.layer.cornerRadius = 4;
    self.m_categoryImgView.layer.masksToBounds = YES;

    self.m_categoryLabel = [[IBTUILabel alloc] initWithfont:[UIFont systemFontOfSize:16] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processLabel = [[IBTUILabel alloc] initWithfont:[UIFont systemFontOfSize:16]
                                                 tintColor:GTO_GRAY_TINT_COLOR
                                           backgroundColor:nil
                                             textAlignment:NSTextAlignmentLeft];//[[self class] p_customLabelWithTextColor:[UIColor blackColor]];
    self.m_processValueLabel = [[IBTUILabel alloc] initWithfont:[UIFont systemFontOfSize:16] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];

    [self addSubview:_m_categoryImgView];
    [self addSubview:_m_categoryLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processLabel];
}
- (void)layoutSubviews
{
    CGFloat leftPadding = 10;
    CGFloat gap = 7;

    // CGFloat btnCategoryW = (self.width - 2*leftPadding - 2*gap ) *0.3;
    // CGFloat btnProcessW = (self.width - 2*leftPadding - 2*gap ) *0.2;
    // CGFloat lblH = 16;

    CGFloat imgVY = (self.height - 44) * 0.5;
    CGFloat lblH = 18;
    self.m_categoryImgView.frame = ((CGRect){.origin.x = leftPadding,
                                             .origin.y = imgVY,
                                             .size.width = 44,// btnCategoryW,
                                             .size.height = 44 });

    self.m_categoryLabel.frame = ((CGRect){.origin.x = _m_categoryImgView.right + gap, .origin.y = imgVY, .size.width = 120, .size.height = lblH });

    CGRect rect = ((CGRect){.origin.x = _m_categoryLabel.x, .origin.y = _m_categoryLabel.bottom + 7, .size.width = IBT_MAIN_SCREEN_WIDTH - _m_categoryLabel.x - leftPadding, .size.height = 18 });
    self.m_processBarView =
        [[IBTUIView alloc] initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    [self addSubview:_m_processBarView];

    self.m_processValueLabel.frame = ((CGRect){.origin.x = _m_processBarView.right - 70, .origin.y = _m_categoryLabel.y, .size.width = 72, .size.height = lblH });

    self.m_processLabel.frame = ((CGRect){.origin.x = _m_categoryLabel.right + gap, .origin.y = imgVY, .size.width = _m_processValueLabel.left - _m_categoryLabel.right - gap, .size.height = lblH });
}

+ (IBTUILabel *)p_customLabelWithTextColor:(UIColor *)textColor
{

    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentLeft;
    label.textColor = textColor;
    label.font = [UIFont systemFontOfSize:15];

    return label;
}
//- (void)p_modifyButtonWithButton: (UIButton *)btn
//                       BackColor: (UIColor *)bgColor
//                       titleColor: (UIColor *)titleColorr
//                        titleFont: (UIFont *)font
//                            title: (NSString *)title {
//
//
//    [btn setTitle:title forState:UIControlStateNormal];
//    [btn setTitleColor:titleColorr forState:UIControlStateNormal];
//    btn.titleLabel.font = font;
//    btn.backgroundColor = bgColor;
//}
- (void)p_imageViewWithImgView:(UIImageView *)imgV andCategory:(NSString *)category
{
    if ([category isEqualToString:@"公共区"]) {
        imgV.image = [UIImage imageNamed:@"public_area"];
    } else if ([category isEqualToString:@"储罐区"]) {
        imgV.image = [UIImage imageNamed:@"storage_area"];
    } else if ([category isEqualToString:@"加油区"]) {
        imgV.image = [UIImage imageNamed:@"addOil_area"];
    } else if ([category isEqualToString:@"辅助区"]) {
        imgV.image = [UIImage imageNamed:@"assist_area"];
    } else {
        imgV.image = [UIImage imageNamed:@"addOil_area"];
    }
}
- (void)p_processWithFinishCategorysNumber:(NSInteger)finishNumber
                            totalCategorys:(NSInteger)totalNumber
                              processLabel:(IBTUILabel *)processLbl
                         processValueLabel:(IBTUILabel *)processValueLbl
{
    NSString *stateStr = [NSString string];
    if (finishNumber == 0) {
        stateStr = @"未填完";
        processLbl.textColor = GTO_RED_COLOR;
        processValueLbl.textColor = GTO_RED_COLOR;

    } else if (finishNumber < totalNumber) {
        stateStr = @"进行中";
        processLbl.textColor = GTO_BLUE_TINT_COLOR;
        processValueLbl.textColor = GTO_BLUE_TINT_COLOR;
    } else {
        stateStr = @"已完成";
        processLbl.textColor = GTO_GRAY_TINT_COLOR;
        processValueLbl.textColor = GTO_GRAY_TINT_COLOR;
    }
    if (totalNumber == 0) {
        totalNumber = -1.0;
    }
    self.d_processLength = 1.0 * finishNumber / totalNumber;
    int percent = self.d_processLength * 100;
    processLbl.text = [NSString stringWithFormat:@"%@ %d%%", stateStr, percent];
    processValueLbl.text = [NSString stringWithFormat:@" %ld/%ld(题)", finishNumber, totalNumber];
}
@end

@implementation GTOCategoryItemView (configure)

- (void)updateWithPatrolPlan:(GTOPatrolPlan *)patrolPlan storeCategory:(NSString *)category finishCategorysNumber:(NSInteger)finishNumber totalCategorys:(NSInteger)totalNumber
{
    [self p_imageViewWithImgView:self.m_categoryImgView andCategory:nil];
    self.m_categoryLabel.text = [NSString stringWithFormat:@"%@:", category];

    [self p_processWithFinishCategorysNumber:finishNumber totalCategorys:totalNumber processLabel:self.m_processLabel processValueLabel:self.m_processValueLabel];

    [self layoutSubviews];
}

- (void)updateWithPioneering:(GTOPioneering *)pioneering pioneeringProcess:(GTOPioneeingProcess *)process
{
    [self p_imageViewWithImgView:self.m_categoryImgView andCategory:nil];
    self.m_categoryLabel.text = [NSString stringWithFormat:@"%@:", process.category];

    [self p_processWithFinishCategorysNumber:(int)process.finishNumber
                              totalCategorys:(int)process.totalNumber
                                processLabel:self.m_processLabel
                           processValueLabel:self.m_processValueLabel];

    [self layoutSubviews];
}

- (void)updateWithPioneering:(GTOPioneering *)pioneering pioneeringDisplayResults:(GTODisplayResult *)displayR
{
    [self p_imageViewWithImgView:self.m_categoryImgView andCategory:nil];
    self.m_categoryLabel.text = [NSString stringWithFormat:@"%@:", displayR.category];

    [self p_processWithFinishCategorysNumber:(int)displayR.arrAnswers.count
                              totalCategorys:(int)displayR.arrQuestions.count
                                processLabel:self.m_processLabel
                           processValueLabel:self.m_processValueLabel];

    [self layoutSubviews];
}

- (void)updateWithLicence:(GTOLicence *)licence licenceDisplayResults:(GTODisplayResult *)displayR
{
    [self p_imageViewWithImgView:self.m_categoryImgView andCategory:nil];
    self.m_categoryLabel.text = [NSString stringWithFormat:@"%@:", displayR.category];

    [self p_processWithFinishCategorysNumber:(int)displayR.arrAnswers.count
                              totalCategorys:(int)displayR.arrQuestions.count
                                processLabel:self.m_processLabel
                           processValueLabel:self.m_processValueLabel];

    [self layoutSubviews];
}

- (void)updateWithStoreResult:(ICRStoreResult *)storeResult storeResultDisplayResults:(GTODisplayResult *)displayR
{
    [self p_imageViewWithImgView:self.m_categoryImgView andCategory:nil];
    self.m_categoryLabel.text = [NSString stringWithFormat:@"%@:", displayR.category];

    [self p_processWithFinishCategorysNumber:(int)displayR.arrAnswers.count
                              totalCategorys:(int)displayR.arrQuestions.count
                                processLabel:self.m_processLabel
                           processValueLabel:self.m_processValueLabel];

    [self layoutSubviews];
}

@end