//
//  PatrolTaskCollectionReusableView.m
//  patrol
//
//  Created by 曹云霄 on 2017/2/23.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolTaskCollectionReusableView.h"

@implementation PatrolTaskCollectionReusableView

- (void)awakeFromNib {
    [super awakeFromNib];
    
    [self setProgressView];
}

#pragma mark -设置进度条风格
- (void)setProgressView
{
    [self.taskProgressView performAction:M13ProgressViewActionNone animated:YES];
    self.taskProgressView.animateStripes = YES;
    self.taskProgressView.cornerType = M13ProgressViewStripedBarCornerTypeRounded;
}

- (void)setTaskModel:(PatrolTaskCustomModel *)taskModel
{
    _taskModel = taskModel;
    self.taskNameLabel.text = taskModel.name;
    self.taskTimeLabel.text = [NSString stringWithFormat:@"%@ ~ %@",taskModel.beginDate, taskModel.endDate];
    CGFloat finishStore = taskModel.storeCount - taskModel.remainStoreCount;
    CGFloat storeCount = taskModel.storeCount;
    [self.taskProgressView setProgress:finishStore/storeCount animated:YES];
    NSString *rate = [NSString stringWithFormat:@"%@%0.f%%",@"进度：",finishStore/storeCount * 100];
    self.labelProgress.text = rate;
    self.labelRemark.text = [NSString stringWithFormat:@"%@：%@",@"备注",taskModel.remark ? taskModel.remark : @"暂无"];
}

@end
