//
//  PatrolExamAttachmentCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamAttachmentCell.h"
#import "UIView+Category.h"
#import "PatrolAttachmentViewController.h"
#import "PatrolStandardViewController.h"
#import "PicViewModel.h"
#import "UploadManager.h"
@interface PatrolExamAttachmentCell ()
@property (strong, nonatomic) PatrolStandardViewController *standardVC;
@property (weak, nonatomic) IBOutlet UIButton *btnReference;

/**
 图片附件
 */
@property (weak, nonatomic) IBOutlet UIButton *btnAtt;

@end
@implementation PatrolExamAttachmentCell

- (void)awakeFromNib {
    [super awakeFromNib];
    self.attachmentBtnLayout.constant = [@"附件" widthWithHeight:35 andFont:14].width + 50;
    self.referenceBtnLayout.constant = [@"参考标准" widthWithHeight:35 andFont:14].width + 50;
    [self.btnReference horizontalCenterImageAndTitle:5];
    [self.btnAtt horizontalCenterImageAndTitle:5];
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    if (cellModel.question.reference.length > 0) {
        self.btnReference.hidden = NO;
    }else{
        if ([UploadManager getUploadType] == UPLOAD_COMMON) {
            self.btnReference.hidden = cellModel.question.attachmentId.length == 0;
        }else{
            self.btnReference.hidden = cellModel.question.attachmentUrls.count == 0;
        }
    }
//    if (cellModel.viewModel.detail.temp) {
//        [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_btn_bg_red") forState:UIControlStateNormal];
//        [self.btnAtt setImage:TCImage(@"patrol_exam_camera_red") forState:UIControlStateNormal];
//        if (self.cellModel.answer.resultAttachments.count > 0) {
//            NSString *title = [NSString stringWithFormat:@"附件(%lu)",self.cellModel.answer.resultAttachments.count];
//            [self.btnAtt setTitle:title forState:UIControlStateNormal];
//            [self.btnAtt setTitleColor:ICR_TINTCOLOR forState:UIControlStateNormal];
//            [self.btnAtt setImage:TCImage(@"patrol_exam_camera") forState:UIControlStateNormal];
//            [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_btn_bg") forState:UIControlStateNormal];
//        }else {
//            [self.btnAtt setTitle:@"附件" forState:UIControlStateNormal];
//            [self.btnAtt setTitleColor:RGBA(227, 12, 53, 1) forState:UIControlStateNormal];
//        }
//    }else {
        if (photoType(cellModel.question.photoType) != PHOTO_TYPE_NO) {
            [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_btn_bg_red") forState:UIControlStateNormal];
            [self.btnAtt setImage:TCImage(@"patrol_exam_camera_red") forState:UIControlStateNormal];
            if (self.cellModel.answer.resultAttachments.count > 0) {
                NSString *title = [NSString stringWithFormat:@"附件(%lu)",self.cellModel.answer.resultAttachments.count];
                [self.btnAtt setTitle:title forState:UIControlStateNormal];
                [self.btnAtt setTitleColor:ICR_TINTCOLOR forState:UIControlStateNormal];
                [self.btnAtt setImage:TCImage(@"patrol_exam_camera") forState:UIControlStateNormal];
                [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_btn_bg") forState:UIControlStateNormal];
            }else {
                [self.btnAtt setTitle:@"附件" forState:UIControlStateNormal];
                [self.btnAtt setTitleColor:RGBA(227, 12, 53, 1) forState:UIControlStateNormal];
            }
        }else {
            if (self.cellModel.answer.resultAttachments.count > 0) {
                NSString *title = [NSString stringWithFormat:@"附件(%lu)",self.cellModel.answer.resultAttachments.count];
                [self.btnAtt setTitle:title forState:UIControlStateNormal];
                [self.btnAtt setImage:TCImage(@"patrol_exam_camera") forState:UIControlStateNormal];
                [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_btn_bg") forState:UIControlStateNormal];
                [self.btnAtt setTitleColor:ICR_TINTCOLOR forState:UIControlStateNormal];
            }else{
                [self.btnAtt setTitle:@"附件" forState:UIControlStateNormal];
                [self.btnAtt setImage:TCImage(@"patrol_exam_camera_gray") forState:UIControlStateNormal];
                [self.btnAtt setBackgroundImage:TCImage(@"patrol_exam_gray_btn_bg") forState:UIControlStateNormal];
                [self.btnAtt setTitleColor:RGBA(128, 128, 128, 1) forState:UIControlStateNormal];
            }
        }
//    }
}

- (IBAction)actionStandard:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if (sender.isSelected) {
        [self.standardVC show];
    }else{
        [self.standardVC hide];
    }
}
- (IBAction)actionAttachment:(UIButton *)sender {
    if (sender.isSelected && self.cellModel.viewModel.state.type != PatrolExamStateProcessing) {
        return;
    }
    PatrolAttachmentViewController *attVC = [PatrolAttachmentViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
    attVC.cellModel = self.cellModel;
    PicViewModel *picVM = [PicViewModel new];
    ZJPatrolDetail_results_answers *answer = self.cellModel.answer;
    //根据是否存在附件判断是添加还是查看
    if (answer.attachmenturls.count > 0 ||
        answer.resultAttachmentId != nil ||
        self.cellModel.viewModel.state.type != PatrolExamStateProcessing) {
        picVM.type = kPicCellTypeRead;
    }else{
        picVM.type = kPicCellTypeAdd;
    }
    //根据单据状态判断是添加还是查看
    attVC.viewModel = picVM;
    [self.viewController pushViewController:attVC animated:YES];
}

- (PatrolStandardViewController *)standardVC {
    _standardVC = [PatrolStandardViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
    _standardVC.question = self.cellModel.question;
    _standardVC.superVC = self.viewController;
    return _standardVC;
}

@end
