//
//  PatrolExamInputCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamInputCell.h"

@interface PatrolExamInputCell ()<UITextViewDelegate>

@end
@implementation PatrolExamInputCell


- (void)awakeFromNib {
    [super awakeFromNib];
    self.textView.delegate = self;
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    
    self.textView.text = cellModel.answer.content;
}


- (void)textViewDidChange:(UITextView *)textView {
    ZJPatrolDetail_results_answers *answer = self.cellModel.getAnswer;
    answer.content = textView.text;
    self.cellModel.viewModel.blockAnswerAction();
    
}

- (void)textViewDidEndEditing:(UITextView *)textView {
    [self.cellModel postNoti];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/



@end
